/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.resolver;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ArtifactCollectionInternal;
import org.gradle.api.internal.artifacts.configurations.DefaultArtifactCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProviderBackedSelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.resolver.ResolutionAccess;
import org.gradle.api.internal.artifacts.resolver.ResolutionOutputsInternal;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Actions;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.CalculatedValueFactory;

public class DefaultResolutionOutputs
implements ResolutionOutputsInternal {
    private final ResolutionAccess resolutionAccess;
    private final TaskDependencyFactory taskDependencyFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final AttributesFactory attributesFactory;
    private final AttributeDesugaring attributeDesugaring;
    private final ObjectFactory objectFactory;

    public DefaultResolutionOutputs(ResolutionAccess resolutionAccess, TaskDependencyFactory taskDependencyFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, AttributesFactory attributesFactory, AttributeDesugaring attributeDesugaring, ObjectFactory objectFactory) {
        this.resolutionAccess = resolutionAccess;
        this.taskDependencyFactory = taskDependencyFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.attributesFactory = attributesFactory;
        this.attributeDesugaring = attributeDesugaring;
        this.objectFactory = objectFactory;
    }

    @Override
    public Provider<ResolvedVariantResult> getRootVariant() {
        return new DefaultProvider(() -> {
            MinimalResolutionResult resolutionResult = this.getResolutionResult();
            return resolutionResult.getRootSource().get().getVariant(resolutionResult.getRootVariantId());
        });
    }

    @Override
    public Provider<ResolvedComponentResult> getRootComponent() {
        return new DefaultProvider(() -> this.getResolutionResult().getRootSource().get());
    }

    private MinimalResolutionResult getResolutionResult() {
        return this.resolutionAccess.getResults().getValue().getVisitedGraph().getResolutionResult();
    }

    @Override
    public FileCollectionInternal getFiles() {
        return this.doGetArtifactView((Action<? super ArtifactView.ViewConfiguration>)Actions.doNothing()).getFiles();
    }

    @Override
    public ArtifactCollectionInternal getArtifacts() {
        return this.doGetArtifactView((Action<? super ArtifactView.ViewConfiguration>)Actions.doNothing()).getArtifacts();
    }

    @Override
    public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> action) {
        return this.doGetArtifactView(action);
    }

    private DefaultArtifactView doGetArtifactView(Action<? super ArtifactView.ViewConfiguration> action) {
        DefaultArtifactViewConfiguration viewConfiguration = (DefaultArtifactViewConfiguration)this.objectFactory.newInstance(DefaultArtifactViewConfiguration.class, new Object[]{this.attributesFactory});
        action.execute((Object)viewConfiguration);
        return new DefaultArtifactView(viewConfiguration.lenient, (Spec<? super ComponentIdentifier>)viewConfiguration.componentFilter, viewConfiguration.reselectVariants, viewConfiguration.viewAttributes, this.resolutionAccess, this.taskDependencyFactory, this.calculatedValueContainerFactory, this.attributesFactory, this.attributeDesugaring);
    }

    @VisibleForTesting
    public static class DefaultArtifactView
    implements ArtifactView {
        private final boolean lenient;
        private final Spec<? super ComponentIdentifier> componentFilter;
        private final boolean reselectVariants;
        private final AttributeContainerInternal viewAttributes;
        private final ResolutionAccess resolutionAccess;
        private final TaskDependencyFactory taskDependencyFactory;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final AttributesFactory attributesFactory;
        private final AttributeDesugaring attributeDesugaring;

        public DefaultArtifactView(boolean lenient, Spec<? super ComponentIdentifier> componentFilter, boolean reselectVariants, AttributeContainerInternal viewAttributes, ResolutionAccess resolutionAccess, TaskDependencyFactory taskDependencyFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, AttributesFactory attributesFactory, AttributeDesugaring attributeDesugaring) {
            this.lenient = lenient;
            this.componentFilter = componentFilter;
            this.reselectVariants = reselectVariants;
            this.viewAttributes = viewAttributes;
            this.resolutionAccess = resolutionAccess;
            this.taskDependencyFactory = taskDependencyFactory;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.attributesFactory = attributesFactory;
            this.attributeDesugaring = attributeDesugaring;
        }

        public ArtifactCollectionInternal getArtifacts() {
            return new DefaultArtifactCollection(this.getFiles(), this.lenient, this.resolutionAccess.getHost(), (CalculatedValueFactory)this.calculatedValueContainerFactory, this.attributeDesugaring);
        }

        public ResolutionBackedFileCollection getFiles() {
            return new ResolutionBackedFileCollection(new ResolutionResultProviderBackedSelectedArtifactSet(this.resolutionAccess.getResults().map(this::selectArtifacts)), this.lenient, this.resolutionAccess.getHost(), this.taskDependencyFactory);
        }

        private SelectedArtifactSet selectArtifacts(ResolverResults results) {
            boolean allowNoMatchingVariants = !this.viewAttributes.isEmpty();
            return results.getVisitedArtifacts().select(new ArtifactSelectionSpec(this.getAttributes(), this.componentFilter, this.reselectVariants, allowNoMatchingVariants, this.resolutionAccess.getDefaultSortOrder()));
        }

        public ImmutableAttributes getAttributes() {
            ImmutableAttributes baseAttributes = this.resolutionAccess.getAttributes();
            if (this.viewAttributes.isEmpty()) {
                return baseAttributes;
            }
            if (this.reselectVariants) {
                return this.viewAttributes.asImmutable();
            }
            return this.attributesFactory.concat(baseAttributes, this.viewAttributes.asImmutable());
        }
    }

    public static class DefaultArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter = Specs.satisfyAll();
        private boolean lenient;
        private boolean reselectVariants;

        @Inject
        public DefaultArtifactViewConfiguration(AttributesFactory attributesFactory) {
            this.viewAttributes = attributesFactory.mutable();
        }

        public AttributeContainer getAttributes() {
            return this.viewAttributes;
        }

        public ArtifactView.ViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute((Object)this.viewAttributes);
            return this;
        }

        public ArtifactView.ViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            if (this.componentFilter != Specs.SATISFIES_ALL) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
            this.componentFilter = componentFilter;
            return this;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        public ArtifactView.ViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public ArtifactView.ViewConfiguration withVariantReselection() {
            this.reselectVariants = true;
            return this;
        }
    }
}

