/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildModelLifecycleListener;
import org.gradle.internal.build.BuildToolingModelControllerFactory;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.DefaultBuildLifecycleController;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultBuildLifecycleControllerFactory
implements BuildLifecycleControllerFactory {
    private final StateTransitionControllerFactory stateTransitionControllerFactory;
    private final BuildToolingModelControllerFactory buildToolingModelControllerFactory;
    private final ExceptionAnalyser exceptionAnalyser;

    public DefaultBuildLifecycleControllerFactory(StateTransitionControllerFactory stateTransitionControllerFactory, BuildToolingModelControllerFactory buildToolingModelControllerFactory, ExceptionAnalyser exceptionAnalyser) {
        this.stateTransitionControllerFactory = stateTransitionControllerFactory;
        this.buildToolingModelControllerFactory = buildToolingModelControllerFactory;
        this.exceptionAnalyser = exceptionAnalyser;
    }

    @Override
    public BuildLifecycleController newInstance(BuildDefinition buildDefinition, BuildScopeServices buildScopeServices) {
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        File customSettingsFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getSettingsFile());
        if (customSettingsFile != null) {
            DefaultBuildLifecycleControllerFactory.logFileDeprecationWarning(DeprecationLogger.deprecateAction((String)"Specifying custom settings file location"));
        }
        File customBuildFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getBuildFile());
        if (customBuildFile != null) {
            DefaultBuildLifecycleControllerFactory.logFileDeprecationWarning(DeprecationLogger.deprecateAction((String)"Specifying custom build file location"));
        }
        GradleInternal gradle = (GradleInternal)buildScopeServices.get(GradleInternal.class);
        ListenerManager listenerManager = (ListenerManager)buildScopeServices.get(ListenerManager.class);
        BuildModelController buildModelController = (BuildModelController)buildScopeServices.get(BuildModelController.class);
        InternalProblems problems = (InternalProblems)buildScopeServices.get(InternalProblems.class);
        return new DefaultBuildLifecycleController(gradle, buildModelController, this.exceptionAnalyser, gradle.getBuildListenerBroadcaster(), (BuildModelLifecycleListener)listenerManager.getBroadcaster(BuildModelLifecycleListener.class), (BuildWorkPreparer)gradle.getServices().get(BuildWorkPreparer.class), (BuildWorkExecutor)gradle.getServices().get(BuildWorkExecutor.class), this.buildToolingModelControllerFactory, this.stateTransitionControllerFactory);
    }

    private static void logFileDeprecationWarning(DeprecationMessageBuilder<?> specifyingCustomFileLocation) {
        ((DeprecationMessageBuilder.WithDocumentation)specifyingCustomFileLocation.willBeRemovedInGradle9().withUpgradeGuideSection(7, "configuring_custom_build_layout")).nagUser();
    }
}

