/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.problems.internal.ProblemCategory;

public class DefaultProblemCategory
implements ProblemCategory,
Serializable {
    public static final String GRADLE_CORE_NAMESPACE = "org.gradle";
    private static final String SEPARATOR = ":";
    public static final String DEPRECATION = "deprecation";
    public static final String VALIDATION = "type-validation";
    private final String namespace;
    private final String category;
    private final List<String> subcategories;

    private DefaultProblemCategory(String namespace, String category, String ... subcategories) {
        this.namespace = namespace;
        this.category = category;
        this.subcategories = Arrays.asList(subcategories);
    }

    public static DefaultProblemCategory create(String namespace, String category, String ... subcategories) {
        return new DefaultProblemCategory(namespace, category, subcategories);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.namespace);
        sb.append(SEPARATOR);
        sb.append(this.category);
        for (String sc : this.subcategories) {
            sb.append(SEPARATOR);
            sb.append(sc);
        }
        return sb.toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public List<String> getSubcategories() {
        return ImmutableList.copyOf(this.subcategories);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblemCategory that = (DefaultProblemCategory)o;
        return Objects.equal((Object)this.namespace, (Object)that.namespace) && Objects.equal((Object)this.category, (Object)that.category) && Objects.equal(this.subcategories, that.subcategories);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.namespace, this.category, this.subcategories});
    }
}

