/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Iterator;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.plugin.management.internal.PluginCoordinates;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolutionVisitor;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class ArtifactRepositoriesPluginResolver
implements PluginResolver {
    public static final String PLUGIN_MARKER_SUFFIX = ".gradle.plugin";
    @VisibleForTesting
    static final String SOURCE_NAME = "Plugin Repositories";
    private final DependencyResolutionServices resolutionServices;

    public ArtifactRepositoriesPluginResolver(DependencyResolutionServices resolutionServices) {
        this.resolutionServices = resolutionServices;
    }

    @Override
    public PluginResolutionResult resolve(PluginRequestInternal pluginRequest) {
        boolean autoApplied;
        ModuleDependency markerDependency = this.getMarkerDependency(pluginRequest);
        String markerVersion = markerDependency.getVersion();
        if (Strings.isNullOrEmpty((String)markerVersion)) {
            return PluginResolutionResult.notFound(SOURCE_NAME, "plugin dependency must include a version number for this source");
        }
        boolean bl = autoApplied = pluginRequest.getOrigin() == PluginRequestInternal.Origin.AUTO_APPLIED;
        if (this.exists(markerDependency) || autoApplied) {
            return PluginResolutionResult.found(new ExternalPluginResolution(pluginRequest, autoApplied));
        }
        return this.handleNotFound("could not resolve plugin artifact '" + this.getNotation((Dependency)markerDependency) + "'");
    }

    private PluginResolutionResult handleNotFound(String message) {
        StringBuilder detail = new StringBuilder("Searched in the following repositories:\n");
        Iterator it = this.resolutionServices.getResolveRepositoryHandler().iterator();
        while (it.hasNext()) {
            detail.append("  ").append(((ArtifactRepositoryInternal)it.next()).getDisplayName());
            if (!it.hasNext()) continue;
            detail.append("\n");
        }
        return PluginResolutionResult.notFound(SOURCE_NAME, message, detail.toString());
    }

    private boolean exists(ModuleDependency dependency) {
        ConfigurationContainer configurations = this.resolutionServices.getConfigurationContainer();
        Configuration configuration = configurations.detachedConfiguration(new Dependency[]{dependency});
        configuration.setTransitive(false);
        ArtifactView lenientView = configuration.getIncoming().artifactView(view -> view.setLenient(true));
        return lenientView.getArtifacts().getFailures().isEmpty();
    }

    private ModuleDependency getMarkerDependency(PluginRequestInternal pluginRequest) {
        ModuleVersionSelector selector = pluginRequest.getModule();
        if (selector == null) {
            String id = pluginRequest.getId().getId();
            return new DefaultExternalModuleDependency(id, id + PLUGIN_MARKER_SUFFIX, pluginRequest.getVersion());
        }
        return new DefaultExternalModuleDependency(selector.getGroup(), selector.getName(), selector.getVersion());
    }

    private String getNotation(Dependency dependency) {
        return Joiner.on((char)':').join((Object)dependency.getGroup(), (Object)dependency.getName(), new Object[]{dependency.getVersion()});
    }

    static class ExternalPluginResolution
    implements PluginResolution {
        private final PluginRequestInternal pluginRequest;
        private final boolean useWeakVersion;

        public ExternalPluginResolution(PluginRequestInternal pluginRequest, boolean useWeakVersion) {
            this.pluginRequest = pluginRequest;
            this.useWeakVersion = useWeakVersion;
        }

        @Override
        public PluginId getPluginId() {
            return this.pluginRequest.getId();
        }

        @Override
        public String getPluginVersion() {
            if (this.pluginRequest.getModule() != null) {
                return this.pluginRequest.getModule().getVersion();
            }
            return this.pluginRequest.getVersion();
        }

        @Override
        public void accept(PluginResolutionVisitor visitor) {
            String id = this.pluginRequest.getId().getId();
            ModuleVersionSelector selector = this.pluginRequest.getModule();
            ModuleIdentifier module = selector != null ? selector.getModule() : DefaultModuleIdentifier.newId((String)id, (String)(id + ArtifactRepositoriesPluginResolver.PLUGIN_MARKER_SUFFIX));
            this.visitDependency(visitor, module);
            this.pluginRequest.getAlternativeCoordinates().ifPresent(altCoords -> ExternalPluginResolution.visitModuleReplacements(visitor, altCoords, id, module));
        }

        private void visitDependency(PluginResolutionVisitor visitor, ModuleIdentifier module) {
            DefaultMutableVersionConstraint versionConstraint = this.useWeakVersion ? DefaultMutableVersionConstraint.withPreferredVersion((String)this.getPluginVersion()) : DefaultMutableVersionConstraint.withVersion((String)this.getPluginVersion());
            visitor.visitDependency((Dependency)new DefaultExternalModuleDependency(module, (MutableVersionConstraint)versionConstraint, null));
        }

        private static void visitModuleReplacements(PluginResolutionVisitor visitor, PluginCoordinates altCoords, String id, ModuleIdentifier module) {
            String altId = altCoords.getId().getId();
            visitor.visitReplacement(DefaultModuleIdentifier.newId((String)id, (String)(id + ArtifactRepositoriesPluginResolver.PLUGIN_MARKER_SUFFIX)), DefaultModuleIdentifier.newId((String)altId, (String)(altId + ArtifactRepositoriesPluginResolver.PLUGIN_MARKER_SUFFIX)));
            if (altCoords.getModule() != null) {
                visitor.visitReplacement(module, altCoords.getModule().getModule());
            }
        }

        @Override
        public void applyTo(PluginManagerInternal pluginManager) {
            PluginCoordinates altCoords = this.pluginRequest.getAlternativeCoordinates().orElse(null);
            if (altCoords != null && pluginManager.hasPlugin(altCoords.getId().getId())) {
                return;
            }
            pluginManager.apply(this.pluginRequest.getId().getId());
        }
    }
}

