/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakList;

public final class ModalityStateEx
extends ModalityState {
    private final WeakList<Object> myModalEntities;
    private static final Set<Object> ourTransparentEntities = Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap());

    public ModalityStateEx() {
        this.myModalEntities = new WeakList();
    }

    ModalityStateEx(@NotNull List<?> modalEntities) {
        if (modalEntities == null) {
            ModalityStateEx.$$$reportNull$$$0(0);
        }
        this.myModalEntities = new WeakList();
        if (modalEntities.contains(null)) {
            throw new IllegalArgumentException("Must not pass null modality: " + modalEntities);
        }
        this.myModalEntities.addAll((Collection<Object>)modalEntities);
    }

    @NotNull
    private @NotNull List<@NotNull Object> getModalEntities() {
        List<Object> list = this.myModalEntities.toStrongList();
        if (list == null) {
            ModalityStateEx.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ModalityStateEx.$$$reportNull$$$0(2);
        }
        ModalityStateEx modalityStateEx = this.appendEntity(progress);
        if (modalityStateEx == null) {
            ModalityStateEx.$$$reportNull$$$0(3);
        }
        return modalityStateEx;
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        if (anEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(6);
        }
        List<@NotNull Object> modalEntities = this.getModalEntities();
        ArrayList<Object> list = new ArrayList<Object>(modalEntities.size() + 1);
        list.addAll(modalEntities);
        list.add(anEntity);
        return new ModalityStateEx(list);
    }

    @Override
    public boolean dominates(@NotNull ModalityState otherState) {
        if (otherState == null) {
            ModalityStateEx.$$$reportNull$$$0(8);
        }
        if (otherState == this || otherState == ModalityState.any()) {
            return false;
        }
        if (this.myModalEntities.isEmpty()) {
            return false;
        }
        return !((ModalityStateEx)otherState).myModalEntities.containsAll(this.myModalEntities, entity -> !ourTransparentEntities.contains(entity));
    }

    @Override
    @NonNls
    public String toString() {
        return this == NON_MODAL ? "ModalityState.NON_MODAL" : "ModalityState:{" + StringUtil.join(this.getModalEntities(), it -> "[" + it + "]", ", ") + "}";
    }

    void removeModality(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(9);
        }
        this.myModalEntities.remove(modalEntity);
    }

    static void unmarkTransparent(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(10);
        }
        ourTransparentEntities.remove(modalEntity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntities";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ModalityStateEx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anEntity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherState";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ModalityStateEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalEntities";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendProgress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "appendJob";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendProgress";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendJob";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendEntity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceModalEntities";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeModality";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unmarkTransparent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

