/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.matching.AttributeSelectionSchema;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;

public class CachingAttributeSelectionSchema
implements AttributeSelectionSchema {
    private final AttributeSelectionSchema delegate;
    private final InMemoryLoadingCache<ExtraAttributesKey, Attribute<?>[]> extraAttributesCache;
    private final InMemoryLoadingCache<MatchValueKey<?>, Boolean> matchValueCache;

    public CachingAttributeSelectionSchema(AttributeSelectionSchema delegate, InMemoryCacheFactory cacheFactory) {
        this.delegate = delegate;
        this.extraAttributesCache = cacheFactory.create(this::doCollectExtraAttributes);
        this.matchValueCache = cacheFactory.create(this::doMatchValue);
    }

    @Override
    public boolean hasAttribute(Attribute<?> attribute) {
        return this.delegate.hasAttribute(attribute);
    }

    @Override
    @Nullable
    public <T> Set<T> disambiguate(Attribute<T> attribute, @Nullable T requested, Set<T> candidates) {
        return this.delegate.disambiguate(attribute, requested, candidates);
    }

    @Override
    public <T> boolean matchValue(Attribute<T> attribute, T requested, T candidate) {
        return (Boolean)this.matchValueCache.get(new MatchValueKey(attribute, requested, candidate));
    }

    private <T> boolean doMatchValue(MatchValueKey<T> key) {
        return this.delegate.matchValue(((MatchValueKey)key).attribute, ((MatchValueKey)key).requested, ((MatchValueKey)key).candidate);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    @Override
    public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requested) {
        ExtraAttributesKey entry = new ExtraAttributesKey(candidateAttributeSets, requested);
        return (Attribute[])this.extraAttributesCache.get((Object)entry);
    }

    private Attribute<?>[] doCollectExtraAttributes(ExtraAttributesKey key) {
        return this.delegate.collectExtraAttributes(key.candidates, key.requested);
    }

    @Override
    public AttributeSelectionSchema.PrecedenceResult orderByPrecedence(Collection<Attribute<?>> requested) {
        return this.delegate.orderByPrecedence(requested);
    }

    private static class MatchValueKey<T> {
        private final Attribute<T> attribute;
        private final T requested;
        private final T candidate;
        private final int hashCode;

        private MatchValueKey(Attribute<T> attribute, T requested, T candidate) {
            this.attribute = attribute;
            this.requested = requested;
            this.candidate = candidate;
            this.hashCode = this.computeHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchValueKey that = (MatchValueKey)o;
            return this.attribute.equals(that.attribute) && this.requested.equals(that.requested) && this.candidate.equals(that.candidate);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int computeHashCode() {
            int result = this.attribute.hashCode();
            result = 31 * result + this.requested.hashCode();
            result = 31 * result + this.candidate.hashCode();
            return result;
        }
    }

    private static class ExtraAttributesKey {
        private final ImmutableAttributes[] candidates;
        private final ImmutableAttributes requested;
        private final int hashCode;

        private ExtraAttributesKey(ImmutableAttributes[] candidates, ImmutableAttributes requested) {
            this.candidates = candidates;
            this.requested = requested;
            this.hashCode = ExtraAttributesKey.computeHashCode(candidates, requested);
        }

        private static int computeHashCode(ImmutableAttributes[] candidates, ImmutableAttributes requested) {
            int hash = requested.hashCode();
            for (ImmutableAttributes candidate : candidates) {
                hash = 31 * hash + candidate.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraAttributesKey that = (ExtraAttributesKey)o;
            if (this.requested != that.requested) {
                return false;
            }
            if (this.candidates.length != that.candidates.length) {
                return false;
            }
            for (int i = 0; i < this.candidates.length; ++i) {
                if (this.candidates[i] == that.candidates[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

