/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.internal.component.external.model.DefaultModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ExternalComponentGraphResolveMetadata;
import org.gradle.internal.component.external.model.ExternalComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.DefaultIvyComponentGraphResolveState;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DefaultExternalComponentGraphResolveState;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class ModuleComponentGraphResolveStateFactory {
    private final ComponentIdGenerator idGenerator;
    private final AttributeDesugaring attributeDesugaring;

    public ModuleComponentGraphResolveStateFactory(ComponentIdGenerator idFactory, AttributeDesugaring attributeDesugaring) {
        this.idGenerator = idFactory;
        this.attributeDesugaring = attributeDesugaring;
    }

    public ModuleComponentGraphResolveState stateFor(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)metadata;
            return new DefaultIvyComponentGraphResolveState(this.idGenerator.nextComponentId(), ivyMetadata, this.attributeDesugaring, this.idGenerator);
        }
        return new DefaultModuleComponentGraphResolveState<ModuleComponentResolveMetadata>(this.idGenerator.nextComponentId(), metadata, this.attributeDesugaring, this.idGenerator);
    }

    public ComponentGraphResolveState stateFor(ExternalComponentGraphResolveMetadata graphMetadata, ExternalComponentResolveMetadata artifactMetadata) {
        return new DefaultExternalComponentGraphResolveState<ExternalComponentGraphResolveMetadata, ExternalComponentResolveMetadata>(this.idGenerator.nextComponentId(), graphMetadata, artifactMetadata, this.attributeDesugaring, this.idGenerator);
    }
}

