/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.matching.AttributeSelectionSchema;

public class CachingAttributeSelectionSchema
implements AttributeSelectionSchema {
    private final AttributeSelectionSchema delegate;
    private final Map<ExtraAttributesEntry, Attribute<?>[]> extraAttributesCache = new ConcurrentHashMap<ExtraAttributesEntry, Attribute<?>[]>();

    public CachingAttributeSelectionSchema(AttributeSelectionSchema delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean hasAttribute(Attribute<?> attribute) {
        return this.delegate.hasAttribute(attribute);
    }

    @Override
    @Nullable
    public <T> Set<T> disambiguate(Attribute<T> attribute, @Nullable T requested, Set<T> candidates) {
        return this.delegate.disambiguate(attribute, requested, candidates);
    }

    @Override
    public <T> boolean matchValue(Attribute<T> attribute, T requested, T candidate) {
        return this.delegate.matchValue(attribute, requested, candidate);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    @Override
    public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requested) {
        ExtraAttributesEntry entry = new ExtraAttributesEntry(candidateAttributeSets, requested);
        return this.extraAttributesCache.computeIfAbsent(entry, key -> this.delegate.collectExtraAttributes(((ExtraAttributesEntry)key).candidates, ((ExtraAttributesEntry)key).requested));
    }

    @Override
    public AttributeSelectionSchema.PrecedenceResult orderByPrecedence(Collection<Attribute<?>> requested) {
        return this.delegate.orderByPrecedence(requested);
    }

    private static class ExtraAttributesEntry {
        private final ImmutableAttributes[] candidates;
        private final ImmutableAttributes requested;
        private final int hashCode;

        private ExtraAttributesEntry(ImmutableAttributes[] candidates, ImmutableAttributes requested) {
            this.candidates = candidates;
            this.requested = requested;
            this.hashCode = ExtraAttributesEntry.computeHashCode(candidates, requested);
        }

        private static int computeHashCode(ImmutableAttributes[] candidates, ImmutableAttributes requested) {
            int hash = requested.hashCode();
            for (ImmutableAttributes candidate : candidates) {
                hash = 31 * hash + candidate.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraAttributesEntry that = (ExtraAttributesEntry)o;
            if (this.requested != that.requested) {
                return false;
            }
            if (this.candidates.length != that.candidates.length) {
                return false;
            }
            for (int i = 0; i < this.candidates.length; ++i) {
                if (this.candidates[i] == that.candidates[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

