/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.Project;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.Path;

public class DefaultProjectDependencyFactory {
    private final Instantiator instantiator;
    private final boolean buildProjectDependencies;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultProjectDependencyFactory(Instantiator instantiator, boolean buildProjectDependencies, NotationParser<Object, Capability> capabilityNotationParser, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, TaskDependencyFactory taskDependencyFactory, ProjectStateRegistry projectStateRegistry) {
        this.instantiator = instantiator;
        this.buildProjectDependencies = buildProjectDependencies;
        this.capabilityNotationParser = capabilityNotationParser;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.taskDependencyFactory = taskDependencyFactory;
        this.projectStateRegistry = projectStateRegistry;
    }

    public ProjectDependency create(ProjectInternal project, String configuration) {
        DefaultProjectDependency projectDependency = (DefaultProjectDependency)((Object)this.instantiator.newInstance(DefaultProjectDependency.class, new Object[]{project, configuration, this.buildProjectDependencies, this.taskDependencyFactory}));
        this.injectServices(projectDependency);
        return projectDependency;
    }

    public ProjectDependency create(Project project) {
        DefaultProjectDependency projectDependency = (DefaultProjectDependency)((Object)this.instantiator.newInstance(DefaultProjectDependency.class, new Object[]{project, this.buildProjectDependencies, this.taskDependencyFactory}));
        this.injectServices(projectDependency);
        return projectDependency;
    }

    public ProjectDependency create(Path projectIdentityPath) {
        ProjectInternal project = this.projectStateRegistry.stateFor(projectIdentityPath).getMutableModel();
        return this.create((Project)project);
    }

    private void injectServices(DefaultProjectDependency projectDependency) {
        projectDependency.setAttributesFactory(this.attributesFactory);
        projectDependency.setCapabilityNotationParser(this.capabilityNotationParser);
        projectDependency.setObjectFactory(this.objectFactory);
    }
}

