/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkInputListeners;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.ValueSnapshot;

public abstract class AbstractSkipEmptyWorkStep<C extends WorkspaceContext>
implements Step<C, CachingResult> {
    private final WorkInputListeners workInputListeners;
    protected final Step<? super C, ? extends CachingResult> delegate;

    protected AbstractSkipEmptyWorkStep(WorkInputListeners workInputListeners, Step<? super C, ? extends CachingResult> delegate) {
        this.workInputListeners = workInputListeners;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, C context) {
        ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots;
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFileFingerprints = ((IdentityContext)context).getInputFileProperties();
        InputFingerprinter.Result newInputs = this.fingerprintPrimaryInputs(work, context, knownFileFingerprints, knownValueSnapshots = ((IdentityContext)context).getInputProperties());
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties = newInputs.getFileFingerprints();
        if (sourceFileProperties.isEmpty()) {
            return this.executeWithNonEmptySources(work, context);
        }
        if (AbstractSkipEmptyWorkStep.hasEmptySources(sourceFileProperties, newInputs.getPropertiesRequiringIsEmptyCheck(), work)) {
            return this.skipExecutionWithEmptySources(work, context);
        }
        return this.executeWithNonEmptySources(work, this.recreateContextWithNewInputFiles(context, newInputs.getAllFileFingerprints()));
    }

    protected abstract C recreateContextWithNewInputFiles(C var1, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasEmptySources(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties, ImmutableSet<String> propertiesRequiringIsEmptyCheck, UnitOfWork work) {
        if (propertiesRequiringIsEmptyCheck.isEmpty()) {
            return sourceFileProperties.values().stream().allMatch(CurrentFileCollectionFingerprint::isEmpty);
        }
        if (!AbstractSkipEmptyWorkStep.hasEmptyFingerprints(sourceFileProperties, propertyName -> !propertiesRequiringIsEmptyCheck.contains(propertyName))) return false;
        if (!AbstractSkipEmptyWorkStep.hasEmptyInputFileCollections(work, arg_0 -> propertiesRequiringIsEmptyCheck.contains(arg_0))) return false;
        return true;
    }

    private static boolean hasEmptyFingerprints(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties, Predicate<String> propertyNameFilter) {
        return sourceFileProperties.entrySet().stream().filter(entry -> propertyNameFilter.test((String)entry.getKey())).map(Map.Entry::getValue).allMatch(CurrentFileCollectionFingerprint::isEmpty);
    }

    private static boolean hasEmptyInputFileCollections(UnitOfWork work, Predicate<String> propertyNameFilter) {
        EmptyCheckingVisitor visitor = new EmptyCheckingVisitor(propertyNameFilter);
        work.visitRegularInputs(visitor);
        return visitor.isAllEmpty();
    }

    private InputFingerprinter.Result fingerprintPrimaryInputs(UnitOfWork work, C context, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFileFingerprints, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots) {
        return work.getInputFingerprinter().fingerprintInputProperties(this.getKnownInputProperties(context), this.getKnownInputFileProperties(context), knownValueSnapshots, knownFileFingerprints, visitor -> work.visitRegularInputs(new UnitOfWork.InputVisitor((UnitOfWork.InputVisitor)visitor){
            final /* synthetic */ UnitOfWork.InputVisitor val$visitor;
            {
                this.val$visitor = inputVisitor;
            }

            @Override
            public void visitInputFileProperty(String propertyName, InputBehavior behavior, UnitOfWork.InputFileValueSupplier value) {
                if (behavior.shouldSkipWhenEmpty()) {
                    this.val$visitor.visitInputFileProperty(propertyName, behavior, value);
                }
            }
        }));
    }

    protected abstract ImmutableSortedMap<String, ValueSnapshot> getKnownInputProperties(C var1);

    protected abstract ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getKnownInputFileProperties(C var1);

    @Nonnull
    private CachingResult skipExecutionWithEmptySources(UnitOfWork work, C context) {
        CachingResult result = this.performSkip(work, context);
        this.broadcastWorkInputs(work, true);
        return result;
    }

    protected abstract CachingResult performSkip(UnitOfWork var1, C var2);

    private CachingResult executeWithNonEmptySources(UnitOfWork work, C context) {
        this.broadcastWorkInputs(work, false);
        return this.delegate.execute(work, context);
    }

    private void broadcastWorkInputs(UnitOfWork work, boolean onlyPrimaryInputs) {
        this.workInputListeners.broadcastFileSystemInputsOf(work, onlyPrimaryInputs ? EnumSet.of(InputBehavior.PRIMARY) : EnumSet.allOf(InputBehavior.class));
    }

    private static class EmptyCheckingVisitor
    implements UnitOfWork.InputVisitor {
        private final Predicate<String> propertyNameFilter;
        private boolean allEmpty = true;

        public EmptyCheckingVisitor(Predicate<String> propertyNameFilter) {
            this.propertyNameFilter = propertyNameFilter;
        }

        @Override
        public void visitInputFileProperty(String propertyName, InputBehavior behavior, UnitOfWork.InputFileValueSupplier value) {
            if (this.propertyNameFilter.test(propertyName)) {
                this.allEmpty = this.allEmpty && value.getFiles().isEmpty();
            }
        }

        public boolean isAllEmpty() {
            return this.allEmpty;
        }
    }
}

