/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableList;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemAwareFailure;
import org.gradle.internal.exceptions.CompilationFailedIndicator;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.problems.internal.rendering.ProblemRenderer;

public class CompilationFailedException
extends RuntimeException
implements CompilationFailedIndicator,
ProblemAwareFailure,
ResolutionProvider {
    public static final String RESOLUTION_MESSAGE = "Check your code and dependencies to fix the compilation error(s)";
    public static final String COMPILATION_FAILED_DETAILS_ABOVE = "Compilation failed; see the compiler error output for details.";
    public static final String COMPILATION_FAILED_DETAILS_BELOW = "Compilation failed; see the compiler output below.";
    private final ApiCompilerResult compilerPartialResult;
    private final List<Problem> reportedProblems;

    public CompilationFailedException() {
        this((ApiCompilerResult)null);
    }

    public CompilationFailedException(int exitCode) {
        super(String.format("Compilation failed with exit code %d; see the compiler error output for details.", exitCode));
        this.compilerPartialResult = null;
        this.reportedProblems = Collections.emptyList();
    }

    public CompilationFailedException(Throwable cause) {
        super(cause);
        this.compilerPartialResult = null;
        this.reportedProblems = Collections.emptyList();
    }

    public CompilationFailedException(@Nullable ApiCompilerResult result) {
        super(COMPILATION_FAILED_DETAILS_ABOVE);
        this.compilerPartialResult = result;
        this.reportedProblems = Collections.emptyList();
    }

    public CompilationFailedException(ApiCompilerResult result, List<Problem> reportedProblems, String diagnosticCounts) {
        super(CompilationFailedException.exceptionMessage(COMPILATION_FAILED_DETAILS_BELOW + System.lineSeparator(), reportedProblems, diagnosticCounts));
        this.compilerPartialResult = result;
        this.reportedProblems = reportedProblems;
    }

    private static String exceptionMessage(String prefix, List<Problem> problems, String diagnosticCounts) {
        StringWriter result = new StringWriter();
        result.append(prefix);
        new ProblemRenderer((Writer)result).render(problems);
        result.append(diagnosticCounts);
        return result.toString();
    }

    public Optional<ApiCompilerResult> getCompilerPartialResult() {
        return Optional.ofNullable(this.compilerPartialResult);
    }

    public Collection<Problem> getProblems() {
        return this.reportedProblems;
    }

    public List<String> getResolutions() {
        if (this.reportedProblems.isEmpty()) {
            return ImmutableList.of((Object)RESOLUTION_MESSAGE);
        }
        return this.reportedProblems.stream().map(Problem::getSolutions).flatMap(Collection::stream).filter(solution -> !solution.isEmpty()).collect(Collectors.toList());
    }
}

