/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import org.gradle.api.Describable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;

public class JavaToolchain
implements Describable,
JavaInstallationMetadata {
    private final Directory javaHome;
    private final JavaLanguageVersion javaVersion;
    private final JvmInstallationMetadata metadata;
    private final JavaToolchainInput input;
    private final boolean isFallbackToolchain;

    public JavaToolchain(JvmInstallationMetadata metadata, FileFactory fileFactory, JavaToolchainInput input, boolean isFallbackToolchain) {
        this.javaHome = fileFactory.dir(metadata.getJavaHome().toFile());
        this.javaVersion = JavaLanguageVersion.of(metadata.getJavaMajorVersion());
        this.metadata = metadata;
        this.input = input;
        this.isFallbackToolchain = isFallbackToolchain;
    }

    @Nested
    protected JavaToolchainInput getTaskInputs() {
        return this.input;
    }

    @Override
    public JavaLanguageVersion getLanguageVersion() {
        return this.javaVersion;
    }

    @Override
    @Internal
    public String getJavaRuntimeVersion() {
        return this.metadata.getRuntimeVersion();
    }

    @Override
    public String getJvmVersion() {
        return this.metadata.getJvmVersion();
    }

    @Override
    @Internal
    public Directory getInstallationPath() {
        return this.javaHome;
    }

    @Override
    @Internal
    public boolean isCurrentJvm() {
        return this.javaHome.getAsFile().equals(Jvm.current().getJavaHome());
    }

    @Internal
    public JvmInstallationMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getVendor() {
        return this.metadata.getVendor().getDisplayName();
    }

    @Internal
    public String getDisplayName() {
        return this.javaHome.toString();
    }

    @Internal
    public boolean isFallbackToolchain() {
        return this.isFallbackToolchain;
    }

    public RegularFile findExecutable(String toolName) {
        return this.getInstallationPath().file(this.getBinaryPath(toolName));
    }

    public String toString() {
        return "JavaToolchain(javaHome=" + this.getDisplayName() + ")";
    }

    private String getBinaryPath(String java) {
        return "bin/" + OperatingSystem.current().getExecutableName(java);
    }
}

