/* SPDX-License-Identifier: GPL-2.0 */
/*
 * MT regs definitions, follows on from mipsregs.h
 * Copyright (C) 2004 - 2005 MIPS Technologies, Inc.  All rights reserved.
 * Elizabeth Clarke et. al.
 *
 */
#ifndef _ASM_MIPSMTREGS_H
#define _ASM_MIPSMTREGS_H

#include <asm/mipsregs.h>

/*
 * Macros for use in assembly language code
 */

#define CP0_MVPCONTROL		$0, 1
#define CP0_MVPCONF0		$0, 2
#define CP0_MVPCONF1		$0, 3
#define CP0_VPECONTROL		$1, 1
#define CP0_VPECONF0		$1, 2
#define CP0_VPECONF1		$1, 3
#define CP0_YQMASK		$1, 4
#define CP0_VPESCHEDULE		$1, 5
#define CP0_VPESCHEFBK		$1, 6
#define CP0_TCSTATUS		$2, 1
#define CP0_TCBIND		$2, 2
#define CP0_TCRESTART		$2, 3
#define CP0_TCHALT		$2, 4
#define CP0_TCCONTEXT		$2, 5
#define CP0_TCSCHEDULE		$2, 6
#define CP0_TCSCHEFBK		$2, 7
#define CP0_SRSCONF0		$6, 1
#define CP0_SRSCONF1		$6, 2
#define CP0_SRSCONF2		$6, 3
#define CP0_SRSCONF3		$6, 4
#define CP0_SRSCONF4		$6, 5

/* MVPControl fields */
#define MVPCONTROL_EVP		(_ULCAST_(1))

#define MVPCONTROL_VPC_SHIFT	1
#define MVPCONTROL_VPC		(_ULCAST_(1) << MVPCONTROL_VPC_SHIFT)

#define MVPCONTROL_STLB_SHIFT	2
#define MVPCONTROL_STLB		(_ULCAST_(1) << MVPCONTROL_STLB_SHIFT)

/* MVPConf0 fields */
#define MVPCONF0_PTC_SHIFT	0
#define MVPCONF0_PTC		(_ULCAST_(0xff))
#define MVPCONF0_PVPE_SHIFT	10
#define MVPCONF0_PVPE		(_ULCAST_(0xf) << MVPCONF0_PVPE_SHIFT)
#define MVPCONF0_TCA_SHIFT	15
#define MVPCONF0_TCA		(_ULCAST_(1) << MVPCONF0_TCA_SHIFT)
#define MVPCONF0_PTLBE_SHIFT	16
#define MVPCONF0_PTLBE		(_ULCAST_(0x3ff) << MVPCONF0_PTLBE_SHIFT)
#define MVPCONF0_TLBS_SHIFT	29
#define MVPCONF0_TLBS		(_ULCAST_(1) << MVPCONF0_TLBS_SHIFT)
#define MVPCONF0_M_SHIFT	31
#define MVPCONF0_M		(_ULCAST_(0x1) << MVPCONF0_M_SHIFT)

/* config3 fields */
#define CONFIG3_MT_SHIFT	2
#define CONFIG3_MT		(_ULCAST_(1) << CONFIG3_MT_SHIFT)

/* VPEControl fields (per VPE) */
#define VPECONTROL_TARGTC	(_ULCAST_(0xff))

#define VPECONTROL_TE_SHIFT	15
#define VPECONTROL_TE		(_ULCAST_(1) << VPECONTROL_TE_SHIFT)
#define VPECONTROL_EXCPT_SHIFT	16
#define VPECONTROL_EXCPT	(_ULCAST_(0x7) << VPECONTROL_EXCPT_SHIFT)

/* Thread Exception Codes for EXCPT field */
#define THREX_TU		0
#define THREX_TO		1
#define THREX_IYQ		2
#define THREX_GSX		3
#define THREX_YSCH		4
#define THREX_GSSCH		5

#define VPECONTROL_GSI_SHIFT	20
#define VPECONTROL_GSI		(_ULCAST_(1) << VPECONTROL_GSI_SHIFT)
#define VPECONTROL_YSI_SHIFT	21
#define VPECONTROL_YSI		(_ULCAST_(1) << VPECONTROL_YSI_SHIFT)

/* VPEConf0 fields (per VPE) */
#define VPECONF0_VPA_SHIFT	0
#define VPECONF0_VPA		(_ULCAST_(1) << VPECONF0_VPA_SHIFT)
#define VPECONF0_MVP_SHIFT	1
#define VPECONF0_MVP		(_ULCAST_(1) << VPECONF0_MVP_SHIFT)
#define VPECONF0_XTC_SHIFT	21
#define VPECONF0_XTC		(_ULCAST_(0xff) << VPECONF0_XTC_SHIFT)

/* VPEConf1 fields (per VPE) */
#define VPECONF1_NCP1_SHIFT	0
#define VPECONF1_NCP1		(_ULCAST_(0xff) << VPECONF1_NCP1_SHIFT)
#define VPECONF1_NCP2_SHIFT	10
#define VPECONF1_NCP2		(_ULCAST_(0xff) << VPECONF1_NCP2_SHIFT)
#define VPECONF1_NCX_SHIFT	20
#define VPECONF1_NCX		(_ULCAST_(0xff) << VPECONF1_NCX_SHIFT)

/* TCStatus fields (per TC) */
#define TCSTATUS_TASID		(_ULCAST_(0xff))
#define TCSTATUS_IXMT_SHIFT	10
#define TCSTATUS_IXMT		(_ULCAST_(1) << TCSTATUS_IXMT_SHIFT)
#define TCSTATUS_TKSU_SHIFT	11
#define TCSTATUS_TKSU		(_ULCAST_(3) << TCSTATUS_TKSU_SHIFT)
#define TCSTATUS_A_SHIFT	13
#define TCSTATUS_A		(_ULCAST_(1) << TCSTATUS_A_SHIFT)
#define TCSTATUS_DA_SHIFT	15
#define TCSTATUS_DA		(_ULCAST_(1) << TCSTATUS_DA_SHIFT)
#define TCSTATUS_DT_SHIFT	20
#define TCSTATUS_DT		(_ULCAST_(1) << TCSTATUS_DT_SHIFT)
#define TCSTATUS_TDS_SHIFT	21
#define TCSTATUS_TDS		(_ULCAST_(1) << TCSTATUS_TDS_SHIFT)
#define TCSTATUS_TSST_SHIFT	22
#define TCSTATUS_TSST		(_ULCAST_(1) << TCSTATUS_TSST_SHIFT)
#define TCSTATUS_RNST_SHIFT	23
#define TCSTATUS_RNST		(_ULCAST_(3) << TCSTATUS_RNST_SHIFT)
/* Codes for RNST */
#define TC_RUNNING		0
#define TC_WAITING		1
#define TC_YIELDING		2
#define TC_GATED		3

#define TCSTATUS_TMX_SHIFT	27
#define TCSTATUS_TMX		(_ULCAST_(1) << TCSTATUS_TMX_SHIFT)
/* TCStatus TCU bits can use same definitions/offsets as CU bits in Status */

/* TCBind */
#define TCBIND_CURVPE_SHIFT	0
#define TCBIND_CURVPE		(_ULCAST_(0xf))

#define TCBIND_CURTC_SHIFT	21

#define TCBIND_CURTC		(_ULCAST_(0xff) << TCBIND_CURTC_SHIFT)

/* TCHalt */
#define TCHALT_H		(_ULCAST_(1))

#endif
