; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc -max-registers-for-gc-values=256 -verify-machineinstrs -stop-after twoaddressinstruction < %s | FileCheck --check-prefix=CHECK-LV %s
; RUN: llc -max-registers-for-gc-values=256 -verify-machineinstrs -stop-after twoaddressinstruction -early-live-intervals < %s | FileCheck --check-prefix=CHECK-LIS %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128-ni:1-p2:32:8:8:32-ni:2"
target triple = "x86_64-unknown-linux-gnu"

declare void @foo() gc "statepoint-example"
declare void @bar(ptr addrspace(1)) gc "statepoint-example"

declare ptr @fake_personality_function()

; Simplest possible test demonstrating the problem
define void @test(ptr addrspace(1) %a)  gc "statepoint-example" {
  ; CHECK-LV-LABEL: name: test
  ; CHECK-LV: bb.0.entry:
  ; CHECK-LV-NEXT:   successors: %bb.2(0x30000000), %bb.1(0x50000000)
  ; CHECK-LV-NEXT:   liveins: $rdi
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   [[COPY:%[0-9]+]]:gr64 = COPY killed $rdi
  ; CHECK-LV-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   [[COPY1:%[0-9]+]]:gr64 = COPY [[COPY]]
  ; CHECK-LV-NEXT:   [[COPY1:%[0-9]+]]:gr64 = STATEPOINT 2, 5, 0, undef %2:gr64, 2, 0, 2, 0, 2, 0, 2, 1, [[COPY1]](tied-def 0), 2, 0, 2, 1, 0, 0, csr_64, implicit-def $rsp, implicit-def $ssp
  ; CHECK-LV-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   TEST64rr killed [[COPY]], [[COPY]], implicit-def $eflags
  ; CHECK-LV-NEXT:   JCC_1 %bb.2, 4, implicit killed $eflags
  ; CHECK-LV-NEXT:   JMP_1 %bb.1
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.1.not_zero:
  ; CHECK-LV-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   $rdi = COPY killed [[COPY1]]
  ; CHECK-LV-NEXT:   STATEPOINT 2, 5, 1, undef %3:gr64, killed $rdi, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, csr_64, implicit-def $rsp, implicit-def $ssp
  ; CHECK-LV-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   RET 0
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.2.zero:
  ; CHECK-LV-NEXT:   RET 0
  ;
  ; CHECK-LIS-LABEL: name: test
  ; CHECK-LIS: bb.0.entry:
  ; CHECK-LIS-NEXT:   successors: %bb.2(0x30000000), %bb.1(0x50000000)
  ; CHECK-LIS-NEXT:   liveins: $rdi
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   [[COPY:%[0-9]+]]:gr64 = COPY $rdi
  ; CHECK-LIS-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   [[COPY1:%[0-9]+]]:gr64 = COPY [[COPY]]
  ; CHECK-LIS-NEXT:   [[COPY1:%[0-9]+]]:gr64 = STATEPOINT 2, 5, 0, undef %2:gr64, 2, 0, 2, 0, 2, 0, 2, 1, [[COPY1]](tied-def 0), 2, 0, 2, 1, 0, 0, csr_64, implicit-def $rsp, implicit-def $ssp
  ; CHECK-LIS-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   TEST64rr [[COPY]], [[COPY]], implicit-def $eflags
  ; CHECK-LIS-NEXT:   JCC_1 %bb.2, 4, implicit killed $eflags
  ; CHECK-LIS-NEXT:   JMP_1 %bb.1
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.1.not_zero:
  ; CHECK-LIS-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   $rdi = COPY [[COPY1]]
  ; CHECK-LIS-NEXT:   STATEPOINT 2, 5, 1, undef %3:gr64, $rdi, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, csr_64, implicit-def $rsp, implicit-def $ssp
  ; CHECK-LIS-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   RET 0
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.2.zero:
  ; CHECK-LIS-NEXT:   RET 0
entry:
  %not7 = icmp eq ptr addrspace(1) %a, null
  %statepoint_token1745 = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2, i32 5, ptr nonnull elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(), "gc-live"(ptr addrspace(1) %a) ]
  br i1 %not7, label %zero, label %not_zero

not_zero:
  %a.relocated = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %statepoint_token1745, i32 0, i32 0) ; (%a, %a)
  %statepoint_token1752 = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2, i32 5, ptr nonnull elementtype(void (ptr addrspace(1))) @bar, i32 1, i32 0, ptr addrspace(1) %a.relocated, i32 0, i32 0) [ "deopt"(), "gc-live"() ]
  ret void

zero:
  ret void
}

; A bit more complex test, where both registers are used in same successor BB
define void @test2(ptr addrspace(1) %this, i32 %0, ptr addrspace(1) %p0, ptr addrspace(1) %p1) gc "statepoint-example" personality ptr @fake_personality_function {
  ; CHECK-LV-LABEL: name: test2
  ; CHECK-LV: bb.0.preheader:
  ; CHECK-LV-NEXT:   successors: %bb.1(0x80000000)
  ; CHECK-LV-NEXT:   liveins: $rdx, $rcx
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   [[COPY:%[0-9]+]]:gr64 = COPY killed $rcx
  ; CHECK-LV-NEXT:   [[COPY1:%[0-9]+]]:gr64 = COPY killed $rdx
  ; CHECK-LV-NEXT:   [[MOV32r0_:%[0-9]+]]:gr32 = MOV32r0 implicit-def dead $eflags
  ; CHECK-LV-NEXT:   [[COPY2:%[0-9]+]]:gr64 = COPY killed [[COPY1]]
  ; CHECK-LV-NEXT:   [[COPY3:%[0-9]+]]:gr64 = COPY killed [[COPY]]
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.1.loop.head:
  ; CHECK-LV-NEXT:   successors: %bb.6(0x04000000), %bb.2(0x7c000000)
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   [[COPY4:%[0-9]+]]:gr64 = COPY killed [[COPY3]]
  ; CHECK-LV-NEXT:   [[COPY5:%[0-9]+]]:gr64 = COPY killed [[COPY2]]
  ; CHECK-LV-NEXT:   TEST64rr killed [[COPY5]], [[COPY5]], implicit-def $eflags
  ; CHECK-LV-NEXT:   JCC_1 %bb.6, 5, implicit killed $eflags
  ; CHECK-LV-NEXT:   JMP_1 %bb.2
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.2.BB3:
  ; CHECK-LV-NEXT:   successors: %bb.3(0x7ffff800), %bb.7(0x00000800)
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   [[COPY4:%[0-9]+]]:gr64 = STATEPOINT 2882400000, 0, 0, undef %11:gr64, 2, 0, 2, 0, 2, 0, 2, 1, [[COPY4]](tied-def 0), 2, 0, 2, 1, 0, 0, csr_64, implicit-def $rsp, implicit-def $ssp, implicit-def dead $rax
  ; CHECK-LV-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   EH_LABEL <mcsymbol >
  ; CHECK-LV-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   [[COPY6:%[0-9]+]]:gr64 = COPY [[COPY4]]
  ; CHECK-LV-NEXT:   [[COPY6:%[0-9]+]]:gr64 = STATEPOINT 2882400000, 0, 0, undef %13:gr64, 2, 0, 2, 0, 2, 0, 2, 1, [[COPY6]](tied-def 0), 2, 0, 2, 1, 0, 0, csr_64, implicit-def $rsp, implicit-def $ssp, implicit-def dead $rax
  ; CHECK-LV-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LV-NEXT:   EH_LABEL <mcsymbol >
  ; CHECK-LV-NEXT:   JMP_1 %bb.3
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.3.BB2:
  ; CHECK-LV-NEXT:   successors: %bb.4(0x40000000), %bb.5(0x40000000)
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   [[COPY7:%[0-9]+]]:gr8 = COPY [[MOV32r0_]].sub_8bit
  ; CHECK-LV-NEXT:   TEST8rr killed [[COPY7]], [[COPY7]], implicit-def $eflags
  ; CHECK-LV-NEXT:   JCC_1 %bb.5, 5, implicit killed $eflags
  ; CHECK-LV-NEXT:   JMP_1 %bb.4
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.4.BB4:
  ; CHECK-LV-NEXT:   successors: %bb.5(0x80000000)
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.5.tail:
  ; CHECK-LV-NEXT:   successors: %bb.6(0x04000000), %bb.1(0x7c000000)
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   [[COPY8:%[0-9]+]]:gr64 = COPY [[COPY6]]
  ; CHECK-LV-NEXT:   [[COPY9:%[0-9]+]]:gr64 = COPY killed [[COPY6]]
  ; CHECK-LV-NEXT:   [[COPY9:%[0-9]+]]:gr64 = nuw ADD64ri32 [[COPY9]], 8, implicit-def dead $eflags
  ; CHECK-LV-NEXT:   TEST64rr killed [[COPY4]], [[COPY4]], implicit-def $eflags
  ; CHECK-LV-NEXT:   [[COPY2:%[0-9]+]]:gr64 = COPY killed [[COPY9]]
  ; CHECK-LV-NEXT:   [[COPY3:%[0-9]+]]:gr64 = COPY killed [[COPY8]]
  ; CHECK-LV-NEXT:   JCC_1 %bb.1, 5, implicit killed $eflags
  ; CHECK-LV-NEXT:   JMP_1 %bb.6
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.6.BB1:
  ; CHECK-LV-NEXT:   RET 0
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT: bb.7.BB6 (landing-pad):
  ; CHECK-LV-NEXT:   liveins: $rax, $rdx
  ; CHECK-LV-NEXT: {{  $}}
  ; CHECK-LV-NEXT:   EH_LABEL <mcsymbol >
  ; CHECK-LV-NEXT:   RET 0
  ;
  ; CHECK-LIS-LABEL: name: test2
  ; CHECK-LIS: bb.0.preheader:
  ; CHECK-LIS-NEXT:   successors: %bb.1(0x80000000)
  ; CHECK-LIS-NEXT:   liveins: $rdx, $rcx
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   [[COPY:%[0-9]+]]:gr64 = COPY $rcx
  ; CHECK-LIS-NEXT:   [[COPY1:%[0-9]+]]:gr64 = COPY $rdx
  ; CHECK-LIS-NEXT:   [[MOV32r0_:%[0-9]+]]:gr32 = MOV32r0 implicit-def dead $eflags
  ; CHECK-LIS-NEXT:   [[COPY2:%[0-9]+]]:gr64 = COPY [[COPY1]]
  ; CHECK-LIS-NEXT:   [[COPY3:%[0-9]+]]:gr64 = COPY [[COPY]]
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.1.loop.head:
  ; CHECK-LIS-NEXT:   successors: %bb.6(0x04000000), %bb.2(0x7c000000)
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   [[COPY4:%[0-9]+]]:gr64 = COPY [[COPY3]]
  ; CHECK-LIS-NEXT:   [[COPY5:%[0-9]+]]:gr64 = COPY [[COPY2]]
  ; CHECK-LIS-NEXT:   TEST64rr [[COPY5]], [[COPY5]], implicit-def $eflags
  ; CHECK-LIS-NEXT:   JCC_1 %bb.6, 5, implicit killed $eflags
  ; CHECK-LIS-NEXT:   JMP_1 %bb.2
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.2.BB3:
  ; CHECK-LIS-NEXT:   successors: %bb.3(0x7ffff800), %bb.7(0x00000800)
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   [[COPY4:%[0-9]+]]:gr64 = STATEPOINT 2882400000, 0, 0, undef %11:gr64, 2, 0, 2, 0, 2, 0, 2, 1, [[COPY4]](tied-def 0), 2, 0, 2, 1, 0, 0, csr_64, implicit-def $rsp, implicit-def $ssp, implicit-def dead $rax
  ; CHECK-LIS-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   EH_LABEL <mcsymbol >
  ; CHECK-LIS-NEXT:   ADJCALLSTACKDOWN64 0, 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   [[COPY6:%[0-9]+]]:gr64 = COPY [[COPY4]]
  ; CHECK-LIS-NEXT:   [[COPY6:%[0-9]+]]:gr64 = STATEPOINT 2882400000, 0, 0, undef %13:gr64, 2, 0, 2, 0, 2, 0, 2, 1, [[COPY6]](tied-def 0), 2, 0, 2, 1, 0, 0, csr_64, implicit-def $rsp, implicit-def $ssp, implicit-def dead $rax
  ; CHECK-LIS-NEXT:   ADJCALLSTACKUP64 0, 0, implicit-def dead $rsp, implicit-def dead $eflags, implicit-def dead $ssp, implicit $rsp, implicit $ssp
  ; CHECK-LIS-NEXT:   EH_LABEL <mcsymbol >
  ; CHECK-LIS-NEXT:   JMP_1 %bb.3
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.3.BB2:
  ; CHECK-LIS-NEXT:   successors: %bb.4(0x40000000), %bb.5(0x40000000)
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   [[COPY7:%[0-9]+]]:gr8 = COPY [[MOV32r0_]].sub_8bit
  ; CHECK-LIS-NEXT:   TEST8rr [[COPY7]], [[COPY7]], implicit-def $eflags
  ; CHECK-LIS-NEXT:   JCC_1 %bb.5, 5, implicit killed $eflags
  ; CHECK-LIS-NEXT:   JMP_1 %bb.4
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.4.BB4:
  ; CHECK-LIS-NEXT:   successors: %bb.5(0x80000000)
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.5.tail:
  ; CHECK-LIS-NEXT:   successors: %bb.6(0x04000000), %bb.1(0x7c000000)
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   [[COPY8:%[0-9]+]]:gr64 = COPY [[COPY6]]
  ; CHECK-LIS-NEXT:   [[COPY9:%[0-9]+]]:gr64 = COPY killed [[COPY6]]
  ; CHECK-LIS-NEXT:   [[COPY9:%[0-9]+]]:gr64 = nuw ADD64ri32 [[COPY9]], 8, implicit-def dead $eflags
  ; CHECK-LIS-NEXT:   TEST64rr killed [[COPY4]], [[COPY4]], implicit-def $eflags
  ; CHECK-LIS-NEXT:   [[COPY2:%[0-9]+]]:gr64 = COPY [[COPY9]]
  ; CHECK-LIS-NEXT:   [[COPY3:%[0-9]+]]:gr64 = COPY [[COPY8]]
  ; CHECK-LIS-NEXT:   JCC_1 %bb.1, 5, implicit killed $eflags
  ; CHECK-LIS-NEXT:   JMP_1 %bb.6
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.6.BB1:
  ; CHECK-LIS-NEXT:   RET 0
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT: bb.7.BB6 (landing-pad):
  ; CHECK-LIS-NEXT:   liveins: $rax, $rdx
  ; CHECK-LIS-NEXT: {{  $}}
  ; CHECK-LIS-NEXT:   EH_LABEL <mcsymbol >
  ; CHECK-LIS-NEXT:   RET 0
preheader:
  br label %loop.head

loop.head:
  %phi1 = phi ptr addrspace(1) [ %p0, %preheader ], [ %addr.i.i46797.remat64523, %tail ]
  %v1 = phi ptr addrspace(1) [ %p1, %preheader ], [ %v3, %tail ]
  %not3= icmp ne ptr addrspace(1) %phi1, null
  br i1 %not3, label %BB1, label %BB3

BB3:
  %token1 = call token (i64, i32, ptr addrspace(1) ()*, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr addrspace(1) ()* elementtype(ptr addrspace(1) ()) undef, i32 0, i32 0, i32 0, i32 0) [ "deopt"(), "gc-live"(ptr addrspace(1) %v1) ]
  %v2 = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %token1, i32 0, i32 0) ; (%v1, %v1)
  %cond = icmp eq ptr addrspace(1) null, %v2
  %token2 = invoke token (i64, i32, ptr addrspace(1) ()*, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr addrspace(1) ()* elementtype(ptr addrspace(1) ()) undef, i32 0, i32 0, i32 0, i32 0) [ "deopt"(), "gc-live"(ptr addrspace(1) %v2, ptr addrspace(1) %phi1) ]
          to label %BB2 unwind label %BB6

BB2:
  %v3 = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %token2, i32 0, i32 0) ; (%v2, %v2)
  %.remat64522 = getelementptr inbounds i8, ptr addrspace(1) %v3, i64 8
  %addr.i.i46797.remat64523 = bitcast ptr addrspace(1) %.remat64522 to ptr addrspace(1)
  br i1 undef, label %BB4, label %tail

BB4:
  %dummy = ptrtoint ptr undef to i64
  br label %tail

tail:
  br i1 %cond, label %BB1, label %loop.head

BB1:
  ret void

BB6:
  %lpad.split-lp = landingpad token
          cleanup
  ret void

}


declare ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token, i32 immarg, i32 immarg) #5
declare token @llvm.experimental.gc.statepoint.p0(i64 immarg, i32 immarg, ptr addrspace(1) ()*, i32 immarg, i32 immarg, ...)
