#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017-2025 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
# ----------------------------------------------------------------------------
#

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "community",
}

DOCUMENTATION = r"""
---
author:
  - Google Inc. (@googlecloudplatform)
description:
  - Configuration for an automated build in response to source repository changes.
extends_documentation_fragment:
  - google.cloud.gcp
module: gcp_cloudbuild_trigger
notes:
  - 'API Reference: U(https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.triggers)'
  - 'Automating builds using build triggers Guide: U(https://cloud.google.com/cloud-build/docs/running-builds/automate-builds)'
options:
  approval_config:
    description:
      - Configuration for manual approval to start a build invocation of this BuildTrigger.
      - Builds created by this trigger will require approval before they execute.
      - Any user with a Cloud Build Approver role for the project can approve a build.
    suboptions:
      approval_required:
        default: false
        description:
          - Whether or not approval is needed.
          - If this is set on a build, it will become pending when run, and will need to be explicitly approved to start.
        type: bool
    type: dict
  bitbucket_server_trigger_config:
    description:
      - BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
    suboptions:
      bitbucket_server_config_resource:
        description:
          - The Bitbucket server config resource that this trigger config maps to.
        required: true
        type: str
      project_key:
        description:
          - Key of the project that the repo is in.
          - 'For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".'
        required: true
        type: str
      pull_request:
        description:
          - Filter to match changes in pull requests.
        suboptions:
          branch:
            description:
              - Regex of branches to match.
              - The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax.
            required: true
            type: str
          comment_control:
            choices:
              - COMMENTS_DISABLED
              - COMMENTS_ENABLED
              - COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY
            description:
              - Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
            type: str
          invert_regex:
            description:
              - If true, branches that do NOT match the git_ref will trigger a build.
            type: bool
        type: dict
      push:
        description:
          - Filter to match changes in refs like branches, tags.
        suboptions:
          branch:
            description:
              - Regex of branches to match.
              - Specify only one of branch or tag.
            type: str
          invert_regex:
            description:
              - When true, only trigger a build if the revision regex does NOT match the gitRef regex.
            type: bool
          tag:
            description:
              - Regex of tags to match.
              - Specify only one of branch or tag.
            type: str
        type: dict
      repo_slug:
        description:
          - Slug of the repository.
          - A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
          - >-
            For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in

            https://mybitbucket.server/projects/TEST/repos/test-repo.
        required: true
        type: str
    type: dict
  build:
    description:
      - Contents of the build template.
      - Either a filename or build template must be provided.
    suboptions:
      artifacts:
        description:
          - Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        suboptions:
          images:
            description:
              - A list of images to be pushed upon the successful completion of all build steps.
              - The images will be pushed using the builder service account's credentials.
              - The digests of the pushed images will be stored in the Build resource's results field.
              - If any of the images fail to be pushed, the build is marked FAILURE.
            elements: str
            type: list
          maven_artifacts:
            description:
              - A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
              - The location and generation of the uploaded objects will be stored in the Build resource's results field.
              - If any objects fail to be pushed, the build is marked FAILURE.
            elements: dict
            suboptions:
              artifact_id:
                description:
                  - Maven artifactId value used when uploading the artifact to Artifact Registry.
                type: str
              group_id:
                description:
                  - Maven groupId value used when uploading the artifact to Artifact Registry.
                type: str
              path:
                description:
                  - Path to an artifact in the build's workspace to be uploaded to Artifact Registry.
                  - This can be either an absolute path, e.g.
                  - /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g.
                  - my-app/target/my-app-1.0.SNAPSHOT.jar.
                type: str
              repository:
                description:
                  - >-
                    Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY" Artifact in the workspace specified by path

                    will be uploaded to Artifact Registry with this location as a prefix.
                type: str
              version:
                description:
                  - Maven version value used when uploading the artifact to Artifact Registry.
                type: str
            type: list
          npm_packages:
            description:
              - Npm package to upload to Artifact Registry upon successful completion of all build steps.
              - The location and generation of the uploaded objects will be stored in the Build resource's results field.
              - If any objects fail to be pushed, the build is marked FAILURE.
            elements: dict
            suboptions:
              package_path:
                description:
                  - Path to the package.json.
                  - e.g.
                  - workspace/path/to/package.
                type: str
              repository:
                description:
                  - >-
                    Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY" Npm package in the workspace specified by path

                    will be zipped and uploaded to Artifact Registry with this location as a prefix.
                type: str
            type: list
          objects:
            description:
              - A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
              - >-
                Files in the workspace matching specified paths globs will be uploaded to the Cloud Storage location using the builder service account's

                credentials.
              - The location and generation of the uploaded objects will be stored in the Build resource's results field.
              - If any objects fail to be pushed, the build is marked FAILURE.
            suboptions:
              location:
                description:
                  - Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
                  - Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
                type: str
              paths:
                description:
                  - Path globs used to match files in the build's workspace.
                elements: str
                type: list
              timing:
                description:
                  - Output only.
                  - Stores timing information for pushing all artifact objects.
                suboptions:
                  end_time:
                    description:
                      - End of time span.
                      - A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
                      - 'Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".'
                    type: str
                  start_time:
                    description:
                      - Start of time span.
                      - A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
                      - 'Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".'
                    type: str
                type: dict
            type: dict
          python_packages:
            description:
              - Python package to upload to Artifact Registry upon successful completion of all build steps.
              - A package can encapsulate multiple objects to be uploaded to a single repository.
              - The location and generation of the uploaded objects will be stored in the Build resource's results field.
              - If any objects fail to be pushed, the build is marked FAILURE.
            elements: dict
            suboptions:
              paths:
                description:
                  - Path globs used to match files in the build's workspace.
                  - For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
                elements: str
                type: list
              repository:
                description:
                  - >-
                    Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY" Files in the workspace matching any path

                    pattern will be uploaded to Artifact Registry with this location as a prefix.
                type: str
            type: list
        type: dict
      available_secrets:
        description:
          - Secrets and secret environment variables.
        suboptions:
          secret_manager:
            description:
              - Pairs a secret environment variable with a SecretVersion in Secret Manager.
            elements: dict
            required: true
            suboptions:
              env:
                description:
                  - Environment variable name to associate with the secret.
                  - Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
                required: true
                type: str
              version_name:
                description:
                  - Resource name of the SecretVersion.
                  - 'In format: projects/*/secrets/*/versions/*.'
                required: true
                type: str
            type: list
        type: dict
      images:
        description:
          - A list of images to be pushed upon the successful completion of all build steps.
          - The images are pushed using the builder service account's credentials.
          - The digests of the pushed images will be stored in the Build resource's results field.
          - If any of the images fail to be pushed, the build status is marked FAILURE.
        elements: str
        type: list
      logs_bucket:
        description:
          - Google Cloud Storage bucket where logs should be written.
          - Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        type: str
      options:
        description:
          - Special options for this build.
        suboptions:
          disk_size_gb:
            description:
              - Requested disk size for the VM that runs the build.
              - Note that this is NOT "disk free"; some of the space will be used by the operating system and build utilities.
              - Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested.
              - At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
            type: int
          dynamic_substitutions:
            description:
              - Option to specify whether or not to apply bash style string operations to the substitutions.
              - NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
            type: bool
          env:
            description:
              - A list of global environment variable definitions that will exist for all build steps in this build.
              - If a variable is defined in both globally and in a build step, the variable will use the build step value.
              - The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
            elements: str
            type: list
          log_streaming_option:
            choices:
              - STREAM_DEFAULT
              - STREAM_ON
              - STREAM_OFF
            description:
              - Option to define build log streaming behavior to Google Cloud Storage.
            type: str
          logging:
            choices:
              - LOGGING_UNSPECIFIED
              - LEGACY
              - GCS_ONLY
              - STACKDRIVER_ONLY
              - CLOUD_LOGGING_ONLY
              - NONE
            description:
              - Option to specify the logging mode, which determines if and where build logs are stored.
            type: str
          machine_type:
            description:
              - Compute Engine machine type on which to run the build.
            type: str
          requested_verify_option:
            choices:
              - NOT_VERIFIED
              - VERIFIED
            description:
              - Requested verifiability options.
            type: str
          secret_env:
            description:
              - A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key.
              - These values must be specified in the build's Secret.
              - These variables will be available to all build steps in this build.
            elements: str
            type: list
          source_provenance_hash:
            description:
              - Requested hash for SourceProvenance.
            elements: str
            type: list
          substitution_option:
            choices:
              - MUST_MATCH
              - ALLOW_LOOSE
            description:
              - Option to specify behavior when there is an error in the substitution checks.
              - NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
            type: str
          volumes:
            description:
              - Global list of volumes to mount for ALL build steps  Each volume is created as an empty volume prior to starting the build process.
              - Upon completion of the build, volumes and their contents are discarded.
              - Global volume names and paths cannot conflict with the volumes defined a build step.
              - Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
            elements: dict
            suboptions:
              name:
                description:
                  - Name of the volume to mount.
                  - Volume names must be unique per build step and must be valid names for Docker volumes.
                  - Each named volume must be used by at least two build steps.
                type: str
              path:
                description:
                  - Path at which to mount the volume.
                  - Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
                type: str
            type: list
          worker_pool:
            description:
              - Option to specify a WorkerPool for the build.
              - Format projects/{project}/workerPools/{workerPool}  This field is experimental.
            type: str
        type: dict
      queue_ttl:
        description:
          - TTL in queue for this build.
          - If provided and the build is enqueued longer than this value, the build will expire and the build status will be EXPIRED.
          - The TTL starts ticking from createTime.
          - A duration in seconds with up to nine fractional digits, terminated by 's'.
          - 'Example: "3.5s".'
        type: str
      secret:
        description:
          - Secrets to decrypt using Cloud Key Management Service.
        elements: dict
        suboptions:
          kms_key_name:
            description:
              - Cloud KMS key name to use to decrypt these envs.
            required: true
            type: str
          secret_env:
            description:
              - Map of environment variable name to its encrypted value.
              - Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
              - Values can be at most 64 KB in size.
              - There can be at most 100 secret values across all of a build's secrets.
            type: dict
        type: list
      source:
        description:
          - The location of the source files to build.
          - One of `storageSource` or `repoSource` must be provided.
        suboptions:
          repo_source:
            description:
              - Location of the source in a Google Cloud Source Repository.
            suboptions:
              branch_name:
                description:
                  - Regex matching branches to build.
                  - Exactly one a of branch name, tag, or commit SHA must be provided.
                  - The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax.
                type: str
              commit_sha:
                description:
                  - Explicit commit SHA to build.
                  - Exactly one a of branch name, tag, or commit SHA must be provided.
                type: str
              dir:
                description:
                  - Directory, relative to the source root, in which to run the build.
                  - This must be a relative path.
                  - If a step's dir is specified and is an absolute path, this value is ignored for that step's execution.
                type: str
              invert_regex:
                description:
                  - Only trigger a build if the revision regex does NOT match the revision regex.
                type: bool
              project_id:
                description:
                  - ID of the project that owns the Cloud Source Repository.
                  - If omitted, the project ID requesting the build is assumed.
                type: str
              repo_name:
                description:
                  - Name of the Cloud Source Repository.
                required: true
                type: str
              substitutions:
                description:
                  - Substitutions to use in a triggered build.
                  - Should only be used with triggers.run.
                type: dict
              tag_name:
                description:
                  - Regex matching tags to build.
                  - Exactly one a of branch name, tag, or commit SHA must be provided.
                  - The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax.
                type: str
            type: dict
          storage_source:
            description:
              - Location of the source in an archive file in Google Cloud Storage.
            suboptions:
              bucket:
                description:
                  - Google Cloud Storage bucket containing the source.
                required: true
                type: str
              generation:
                description:
                  - Google Cloud Storage generation for the object.
                  - If the generation is omitted, the latest generation will be used.
                type: str
              object:
                description:
                  - Google Cloud Storage object containing the source.
                  - This object must be a gzipped archive file (.tar.gz) containing source to build.
                required: true
                type: str
            type: dict
        type: dict
      step:
        description:
          - The operations to be performed on the workspace.
        elements: dict
        required: true
        suboptions:
          allow_exit_codes:
            description:
              - Allow this build step to fail without failing the entire build if and only if the exit code is one of the specified codes.
              - If `allowFailure` is also specified, this field will take precedence.
            elements: int
            type: list
          allow_failure:
            description:
              - Allow this build step to fail without failing the entire build.
              - If false, the entire build will fail if this step fails.
              - Otherwise, the build will succeed, but this step will still have a failure status.
              - Error information will be reported in the `failureDetail` field.
              - '`allowExitCodes` takes precedence over this field.'
            type: bool
          args:
            description:
              - A list of arguments that will be presented to the step when it is started.
              - If the image used to run the step's container has an entrypoint, the args are used as arguments to that entrypoint.
              - >-
                If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as

                arguments.
            elements: str
            type: list
          dir:
            description:
              - Working directory to use when running this step's container.
              - If this value is a relative path, it is relative to the build's working directory.
              - >-
                If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted

                across build step executions, unless a `volume` for that path is specified.
              - >-
                If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is

                ignored for the step's execution.
            type: str
          entrypoint:
            description:
              - Entrypoint to be used instead of the build step image's default entrypoint.
              - If unset, the image's default entrypoint is used.
            type: str
          env:
            description:
              - A list of environment variable definitions to be used when running a step.
              - The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
            elements: str
            type: list
          id:
            description:
              - Unique identifier for this build step, used in `wait_for` to reference this build step as a dependency.
            type: str
          name:
            description:
              - The name of the container image that will run this particular build step.
              - If the image is available in the host's Docker daemon's cache, it will be run directly.
              - If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary.
              - >-
                The Docker daemon's cache will already have the latest versions of all of the officially supported build steps (see

                https://github.com/GoogleCloudPlatform/cloud-builders for images and examples).
              - >-
                The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at

                the time you attempt to use them.
              - >-
                If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name

                for a later build step.
            required: true
            type: str
          script:
            description:
              - A shell script to be executed in the step.
              - When script is provided, the user cannot specify the entrypoint or args.
            type: str
          secret_env:
            description:
              - A list of environment variables which are encrypted using a Cloud Key Management Service crypto key.
              - These values must be specified in the build's `Secret`.
            elements: str
            type: list
          timeout:
            description:
              - Time limit for executing this build step.
              - If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
            type: str
          timing:
            description:
              - Output only.
              - Stores timing information for executing this build step.
            type: str
          volumes:
            description:
              - List of volumes to mount into the build step.
              - Each volume is created as an empty volume prior to execution of the build step.
              - Upon completion of the build, volumes and their contents are discarded.
              - Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
            elements: dict
            suboptions:
              name:
                description:
                  - Name of the volume to mount.
                  - Volume names must be unique per build step and must be valid names for Docker volumes.
                  - Each named volume must be used by at least two build steps.
                required: true
                type: str
              path:
                description:
                  - Path at which to mount the volume.
                  - Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
                required: true
                type: str
            type: list
          wait_for:
            description:
              - The ID(s) of the step(s) that this build step depends on.
              - This build step will not start until all the build steps in `wait_for` have completed successfully.
              - If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
            elements: str
            type: list
        type: list
      substitutions:
        description:
          - Substitutions data for Build resource.
        type: dict
      tags:
        description:
          - Tags for annotation of a Build.
          - These are not docker tags.
        elements: str
        type: list
      timeout:
        default: 600s
        description:
          - Amount of time that this build should be allowed to run, to second granularity.
          - If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
          - This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
          - The expected format is the number of seconds followed by s.
          - Default time is ten minutes (600s).
        type: str
    type: dict
  description:
    description:
      - Human-readable description of the trigger.
    type: str
  disabled:
    description:
      - Whether the trigger is disabled or not.
      - If true, the trigger will never result in a build.
    type: bool
  filename:
    description:
      - Path, from the source root, to a file whose contents is used for the template.
      - Either a filename or build template must be provided.
      - Set this only when using trigger_template or github.
      - When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
    type: str
  filter:
    description:
      - A Common Expression Language string.
      - Used only with Pub/Sub and Webhook.
    type: str
  git_file_source:
    description:
      - The file source describing the local or remote Build template.
    suboptions:
      bitbucket_server_config:
        description:
          - The full resource name of the bitbucket server config.
          - 'Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.'
        type: str
      github_enterprise_config:
        description:
          - The full resource name of the github enterprise config.
          - 'Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}.'
          - projects/{project}/githubEnterpriseConfigs/{id}.
        type: str
      path:
        description:
          - The path of the file, with the repo root as the root of the path.
        required: true
        type: str
      repo_type:
        choices:
          - UNKNOWN
          - CLOUD_SOURCE_REPOSITORIES
          - GITHUB
          - BITBUCKET_SERVER
        description:
          - The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
          - Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER.
        required: true
        type: str
      repository:
        description:
          - The fully qualified resource name of the Repo API repository.
          - The fully qualified resource name of the Repo API repository.
          - If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        type: str
      revision:
        description:
          - The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the filename (optional).
          - >-
            This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions If unspecified, the revision from

            which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        type: str
      uri:
        description:
          - The URI of the repo (optional).
          - If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        type: str
    type: dict
  github:
    description:
      - Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
      - One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
    suboptions:
      enterprise_config_resource_name:
        description:
          - The resource name of the github enterprise config that should be applied to this installation.
          - 'For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}".'
        type: str
      name:
        description:
          - Name of the repository.
          - 'For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".'
        type: str
      owner:
        description:
          - Owner of the repository.
          - 'For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".'
        type: str
      pull_request:
        description:
          - filter to match changes in pull requests.
          - Specify only one of `pull_request` or `push`.
        suboptions:
          branch:
            description:
              - Regex of branches to match.
            required: true
            type: str
          comment_control:
            choices:
              - COMMENTS_DISABLED
              - COMMENTS_ENABLED
              - COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY
            description:
              - Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
            type: str
          invert_regex:
            description:
              - If true, branches that do NOT match the git_ref will trigger a build.
            type: bool
        type: dict
      push:
        description:
          - filter to match changes in refs, like branches or tags.
          - Specify only one of `pull_request` or `push`.
        suboptions:
          branch:
            description:
              - Regex of branches to match.
              - Specify only one of branch or tag.
            type: str
          invert_regex:
            description:
              - When true, only trigger a build if the revision regex does NOT match the git_ref regex.
            type: bool
          tag:
            description:
              - Regex of tags to match.
              - Specify only one of branch or tag.
            type: str
        type: dict
    type: dict
  ignored_files:
    description:
      - ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for `**`.
      - If ignoredFiles and changed files are both empty, then they are not used to determine whether or not to trigger a build.
      - If ignoredFiles is not empty, then we ignore any files that match any of the ignored_file globs.
      - If the change has no files that are outside of the ignoredFiles globs, then we do not trigger a build.
    elements: str
    type: list
  include_build_logs:
    choices:
      - INCLUDE_BUILD_LOGS_UNSPECIFIED
      - INCLUDE_BUILD_LOGS_WITH_STATUS
    description:
      - Build logs will be sent back to GitHub as part of the checkrun result.
      - Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or INCLUDE_BUILD_LOGS_WITH_STATUS.
    type: str
  included_files:
    description:
      - ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for `**`.
      - >-
        If any of the files altered in the commit pass the ignoredFiles filter and includedFiles is empty, then as far as this filter is concerned,

        we should trigger the build.
      - >-
        If any of the files altered in the commit pass the ignoredFiles filter and includedFiles is not empty, then we make sure that at least one

        of those files matches a includedFiles glob.
      - If not, then we do not trigger a build.
    elements: str
    type: list
  location:
    default: global
    description:
      - The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
      - If not specified, "global" is used.
    type: str
  name:
    description:
      - Name of the trigger.
      - Must be unique within the project.
    type: str
  pubsub_config:
    description:
      - PubsubConfig describes the configuration of a trigger that creates a build whenever a Pub/Sub message is published.
      - One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
    suboptions:
      service_account_email:
        description:
          - Service account that will make the push request.
        type: str
      state:
        description:
          - Potential issues with the underlying Pub/Sub subscription configuration.
          - Only populated on get requests.
        type: str
      subscription:
        description:
          - Output only.
          - Name of the subscription.
        type: str
      topic:
        description:
          - The name of the topic from which this subscription is receiving messages.
        required: true
        type: str
    type: dict
  repository_event_config:
    description:
      - The configuration of a trigger that creates a build whenever an event from Repo API is received.
    suboptions:
      pull_request:
        description:
          - Contains filter properties for matching Pull Requests.
        suboptions:
          branch:
            description:
              - Regex of branches to match.
              - The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax.
            type: str
          comment_control:
            choices:
              - COMMENTS_DISABLED
              - COMMENTS_ENABLED
              - COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY
            description:
              - Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
            type: str
          invert_regex:
            description:
              - If true, branches that do NOT match the git_ref will trigger a build.
            type: bool
        type: dict
      push:
        description:
          - Contains filter properties for matching git pushes.
        suboptions:
          branch:
            description:
              - Regex of branches to match.
              - The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax.
            type: str
          invert_regex:
            description:
              - If true, only trigger a build if the revision regex does NOT match the git_ref regex.
            type: bool
          tag:
            description:
              - Regex of tags to match.
              - The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax.
            type: str
        type: dict
      repository:
        description:
          - The resource name of the Repo API resource.
        type: str
    type: dict
  service_account:
    description:
      - The service account used for all user-controlled operations including triggers.patch, triggers.run, builds.create, and builds.cancel.
      - If no service account is set, then the standard Cloud Build service account ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
      - 'Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}.'
    type: str
  source_to_build:
    description:
      - The repo and ref of the repository from which to build.
      - This field is used only for those triggers that do not respond to SCM events.
      - Triggers that respond to such events build source at whatever commit caused the event.
      - This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
      - One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
    suboptions:
      bitbucket_server_config:
        description:
          - The full resource name of the bitbucket server config.
          - 'Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.'
        type: str
      github_enterprise_config:
        description:
          - The full resource name of the github enterprise config.
          - 'Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}.'
          - projects/{project}/githubEnterpriseConfigs/{id}.
        type: str
      ref:
        description:
          - The branch or tag to use.
          - Must start with "refs/" (required).
        required: true
        type: str
      repo_type:
        choices:
          - UNKNOWN
          - CLOUD_SOURCE_REPOSITORIES
          - GITHUB
          - BITBUCKET_SERVER
        description:
          - The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
          - Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER.
        required: true
        type: str
      repository:
        description:
          - The qualified resource name of the Repo API repository.
          - Either uri or repository can be specified and is required.
        type: str
      uri:
        description:
          - The URI of the repo.
        type: str
    type: dict
  state:
    choices:
      - present
      - absent
    default: present
    description:
      - Whether the resource should exist in GCP.
    type: str
  substitutions:
    description:
      - Substitutions data for Build resource.
    type: dict
  tags:
    description:
      - Tags for annotation of a BuildTrigger.
    elements: str
    type: list
  trigger_template:
    description:
      - Template describing the types of source changes to trigger a build.
      - Branch and tag names in trigger templates are interpreted as regular expressions.
      - Any branch or tag change that matches that regular expression will trigger a build.
      - One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
    suboptions:
      branch_name:
        description:
          - Name of the branch to build.
          - Exactly one a of branch name, tag, or commit SHA must be provided.
          - This field is a regular expression.
        type: str
      commit_sha:
        description:
          - Explicit commit SHA to build.
          - Exactly one of a branch name, tag, or commit SHA must be provided.
        type: str
      dir:
        description:
          - Directory, relative to the source root, in which to run the build.
          - This must be a relative path.
          - If a step's dir is specified and is an absolute path, this value is ignored for that step's execution.
        type: str
      invert_regex:
        description:
          - Only trigger a build if the revision regex does NOT match the revision regex.
        type: bool
      project_id:
        description:
          - ID of the project that owns the Cloud Source Repository.
          - If omitted, the project ID requesting the build is assumed.
        type: str
      repo_name:
        default: default
        description:
          - Name of the Cloud Source Repository.
          - If omitted, the name "default" is assumed.
        type: str
      tag_name:
        description:
          - Name of the tag to build.
          - Exactly one of a branch name, tag, or commit SHA must be provided.
          - This field is a regular expression.
        type: str
    type: dict
  webhook_config:
    description:
      - WebhookConfig describes the configuration of a trigger that creates a build whenever a webhook is sent to a trigger's webhook URL.
      - One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
    suboptions:
      secret:
        description:
          - Resource name for the secret required as a URL parameter.
        required: true
        type: str
      state:
        description:
          - Potential issues with the underlying Pub/Sub subscription configuration.
          - Only populated on get requests.
        type: str
    type: dict
requirements:
  - python >= 3.8
  - requests >= 2.18.4
  - google-auth >= 2.25.1
short_description: Creates a GCP CloudBuild.Trigger resource
"""

EXAMPLES = r"""
- name: Trigger build with filename
  google.cloud.gcp_cloudbuild_trigger_build:
    name: "{{ resource_name }}"
    state: present
    location: us-central1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    trigger_template:
      repo_name: my-repo-name
      branch_name: main
    filename: my-cloudbuild.yml

################################################################################

- name: Trigger build example
  google.cloud.gcp_cloudbuild_trigger_build:
    name: "{{ resource_name }}"
    state: present
    location: us-central1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    trigger_template:
      branch_name: main
      repo_name: my-repo-name
    logs_bucket: gs://my-bucket/logs
    step:
      - name: gcr.io/cloud-builders/gsutil
        args: ["cp", "gs://my-bucket/remotefile.zip", "localfile.zip"]
        secret_env: ["MY_SECRET"]
      - name: ubuntu
        script: |
          echo "Hello, world!"
    source:
      storage_source:
        bucket: my-bucket
        object: sourcecode.zip
    artifacts:
      images:
        - gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA
      objects:
        location: "gs://bucket/path/to/somewhere/"
        paths: ["path"]
      npm_packages:
        package_path: "package.json"
        repository: "https://us-west1-npm.pkg.dev/myProject/quickstart-nodejs-repo"
      python_packages:
        paths: ["dist/*"]
        repository: "https://us-west1-python.pkg.dev/myProject/quickstart-python-repo"

################################################################################

- name: Trigger build with pubsub config
  google.cloud.gcp_cloudbuild_trigger_build:
    name: "{{ resource_name }}"
    state: present
    location: us-central1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    pubsub_config:
      topic: pubsub_topic.my_topic.id
    source_to_build:
      uri: https://my-host.com/my-user/my-repo-name.git
      ref: refs/heads/main
      repo_type: UNKNOWN
    git_file_source:
      path: cloudbuild.yaml
      uri: https://my-host.com/my-user/my-repo-name.git
      revision: refs/heads/main
      repo_type: UNKNOWN
    substitutions:
      _ACTION: "$(body.message.data.action)"
    filter: "_ACTION.matches('INSERT')"

################################################################################

- name: Trigger build with webhook config
  google.cloud.gcp_cloudbuild_trigger_build:
    name: "{{ resource_name }}"
    state: present
    location: us-central1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    source_to_build:
      uri: https://my-host.com/my-user/my-repo-name.git
      ref: refs/heads/main
      repo_type: UNKNOWN
    git_file_source:
      path: cloudbuild.yaml
      uri: https://my-host.com/my-user/my-repo-name.git
      revision: refs/heads/main
      repo_type: UNKNOWN
    webhook_config:
      secret: projects/{{ gcp_project }}/secrets/webhook-secret/versions/1

################################################################################

- name: Trigger manual build with approval needed
  google.cloud.gcp_cloudbuild_trigger_build:
    name: "{{ resource_name }}"
    state: present
    location: us-central1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    source_to_build:
      uri: https://my-host.com/my-user/my-repo-name.git
      ref: refs/heads/main
      repo_type: UNKNOWN
    git_file_source:
      path: cloudbuild.yaml
      uri: https://my-host.com/my-user/my-repo-name.git
      revision: refs/heads/main
      repo_type: UNKNOWN
    approval_config:
      approval_required: true

################################################################################

- name: Trigger build with repository event config
  google.cloud.gcp_cloudbuild_trigger_build:
    name: "{{ resource_name }}"
    state: present
    location: us-central1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    repository_event_config:
      pull_request:
        branch: 'feature/*'
      push:
        branch: main
      repository: "{{ repository_name }}"
"""

RETURN = r"""
changed:
  description: Whether the resource was changed.
  returned: always
  type: bool
createTime:
  description:
    - Time when the trigger was created.
  returned: success
  type: str
state:
  description: The current state of the resource.
  returned: always
  type: str
trigger_id:
  description:
    - The unique identifier for the trigger.
  returned: success
  type: str
"""

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils import gcp_utils as gcp
import copy

# BEGIN Custom imports
# END Custom imports


def build_link(module, uri):
    params = module.params.copy()

    return "https://cloudbuild.googleapis.com/v1/" + uri.format(**params)


class ApprovalConfig(gcp.Resource):
    def _request(self):
        return {
            "approvalRequired": self.request.get("approval_required"),
        }

    def _response(self):
        return {
            "approvalRequired": self.response.get("approvalRequired"),
        }


class BitbucketServerTriggerConfig(gcp.Resource):
    def _request(self):
        return {
            "bitbucketServerConfigResource": self.request.get("bitbucket_server_config_resource"),
            "projectKey": self.request.get("project_key"),
            "pullRequest": BitbucketServerTriggerConfigPullRequest(self.request.get("pull_request", {})).to_request(),
            "push": BitbucketServerTriggerConfigPush(self.request.get("push", {})).to_request(),
            "repoSlug": self.request.get("repo_slug"),
        }

    def _response(self):
        return {
            "bitbucketServerConfigResource": self.response.get("bitbucketServerConfigResource"),
            "projectKey": self.response.get("projectKey"),
            "pullRequest": BitbucketServerTriggerConfigPullRequest().from_response(
                self.response.get("pullRequest", {})
            ),
            "push": BitbucketServerTriggerConfigPush().from_response(self.response.get("push", {})),
            "repoSlug": self.response.get("repoSlug"),
        }


class BitbucketServerTriggerConfigPullRequest(gcp.Resource):
    def _request(self):
        return {
            "branch": self.request.get("branch"),
            "commentControl": self.request.get("comment_control"),
            "invertRegex": self.request.get("invert_regex"),
        }

    def _response(self):
        return {
            "branch": self.response.get("branch"),
            "commentControl": self.response.get("commentControl"),
            "invertRegex": self.response.get("invertRegex"),
        }


class BitbucketServerTriggerConfigPush(gcp.Resource):
    def _request(self):
        return {
            "branch": self.request.get("branch"),
            "invertRegex": self.request.get("invert_regex"),
            "tag": self.request.get("tag"),
        }

    def _response(self):
        return {
            "branch": self.response.get("branch"),
            "invertRegex": self.response.get("invertRegex"),
            "tag": self.response.get("tag"),
        }


class Build(gcp.Resource):
    def _request(self):
        return {
            "artifacts": BuildArtifacts(self.request.get("artifacts", {})).to_request(),
            "availableSecrets": BuildAvailableSecrets(self.request.get("available_secrets", {})).to_request(),
            "images": self.request.get("images"),
            "logsBucket": self.request.get("logs_bucket"),
            "options": BuildOptions(self.request.get("options", {})).to_request(),
            "queueTtl": self.request.get("queue_ttl"),
            "secrets": [BuildSecret(item).to_request() for item in (self.request.get("secret") or [])],
            "source": BuildSource(self.request.get("source", {})).to_request(),
            "steps": [BuildStep(item).to_request() for item in (self.request.get("step") or [])],
            "substitutions": self.request.get("substitutions"),
            "tags": self.request.get("tags"),
            "timeout": self.request.get("timeout"),
        }

    def _response(self):
        return {
            "artifacts": BuildArtifacts().from_response(self.response.get("artifacts", {})),
            "availableSecrets": BuildAvailableSecrets().from_response(self.response.get("availableSecrets", {})),
            "images": self.response.get("images"),
            "logsBucket": self.response.get("logsBucket"),
            "options": BuildOptions().from_response(self.response.get("options", {})),
            "queueTtl": self.response.get("queueTtl"),
            "secrets": [BuildSecret().from_response(item) for item in (self.response.get("secrets") or [])],
            "source": BuildSource().from_response(self.response.get("source", {})),
            "steps": [BuildStep().from_response(item) for item in (self.response.get("steps") or [])],
            "substitutions": self.response.get("substitutions"),
            "tags": self.response.get("tags"),
            "timeout": self.response.get("timeout"),
        }


class BuildArtifacts(gcp.Resource):
    def _request(self):
        return {
            "images": self.request.get("images"),
            "mavenArtifacts": [
                BuildArtifactsMavenArtifact(item).to_request() for item in (self.request.get("maven_artifacts") or [])
            ],
            "npmPackages": [
                BuildArtifactsNpmPackage(item).to_request() for item in (self.request.get("npm_packages") or [])
            ],
            "objects": BuildArtifactsObjects(self.request.get("objects", {})).to_request(),
            "pythonPackages": [
                BuildArtifactsPythonPackage(item).to_request() for item in (self.request.get("python_packages") or [])
            ],
        }

    def _response(self):
        return {
            "images": self.response.get("images"),
            "mavenArtifacts": [
                BuildArtifactsMavenArtifact().from_response(item)
                for item in (self.response.get("mavenArtifacts") or [])
            ],
            "npmPackages": [
                BuildArtifactsNpmPackage().from_response(item) for item in (self.response.get("npmPackages") or [])
            ],
            "objects": BuildArtifactsObjects().from_response(self.response.get("objects", {})),
            "pythonPackages": [
                BuildArtifactsPythonPackage().from_response(item)
                for item in (self.response.get("pythonPackages") or [])
            ],
        }


class BuildArtifactsMavenArtifact(gcp.Resource):
    def _request(self):
        return {
            "artifactId": self.request.get("artifact_id"),
            "groupId": self.request.get("group_id"),
            "path": self.request.get("path"),
            "repository": self.request.get("repository"),
            "version": self.request.get("version"),
        }

    def _response(self):
        return {
            "artifactId": self.response.get("artifactId"),
            "groupId": self.response.get("groupId"),
            "path": self.response.get("path"),
            "repository": self.response.get("repository"),
            "version": self.response.get("version"),
        }


class BuildArtifactsNpmPackage(gcp.Resource):
    def _request(self):
        return {
            "packagePath": self.request.get("package_path"),
            "repository": self.request.get("repository"),
        }

    def _response(self):
        return {
            "packagePath": self.response.get("packagePath"),
            "repository": self.response.get("repository"),
        }


class BuildArtifactsObjects(gcp.Resource):
    def _request(self):
        return {
            "location": self.request.get("location"),
            "paths": self.request.get("paths"),
        }

    def _response(self):
        return {
            "location": self.response.get("location"),
            "paths": self.response.get("paths"),
            "timing": BuildArtifactsObjectsTiming().from_response(self.response.get("timing", {})),
        }


class BuildArtifactsObjectsTiming(gcp.Resource):
    def _request(self):
        return {
            "endTime": self.request.get("end_time"),
            "startTime": self.request.get("start_time"),
        }

    def _response(self):
        return {
            "endTime": self.response.get("endTime"),
            "startTime": self.response.get("startTime"),
        }


class BuildArtifactsPythonPackage(gcp.Resource):
    def _request(self):
        return {
            "paths": self.request.get("paths"),
            "repository": self.request.get("repository"),
        }

    def _response(self):
        return {
            "paths": self.response.get("paths"),
            "repository": self.response.get("repository"),
        }


class BuildAvailableSecrets(gcp.Resource):
    def _request(self):
        return {
            "secretManager": [
                BuildAvailableSecretsSecretManager(item).to_request()
                for item in (self.request.get("secret_manager") or [])
            ],
        }

    def _response(self):
        return {
            "secretManager": [
                BuildAvailableSecretsSecretManager().from_response(item)
                for item in (self.response.get("secretManager") or [])
            ],
        }


class BuildAvailableSecretsSecretManager(gcp.Resource):
    def _request(self):
        return {
            "env": self.request.get("env"),
            "versionName": self.request.get("version_name"),
        }

    def _response(self):
        return {
            "env": self.response.get("env"),
            "versionName": self.response.get("versionName"),
        }


class BuildOptions(gcp.Resource):
    def _request(self):
        return {
            "diskSizeGb": self.request.get("disk_size_gb"),
            "dynamicSubstitutions": self.request.get("dynamic_substitutions"),
            "env": self.request.get("env"),
            "logStreamingOption": self.request.get("log_streaming_option"),
            "logging": self.request.get("logging"),
            "machineType": self.request.get("machine_type"),
            "requestedVerifyOption": self.request.get("requested_verify_option"),
            "secretEnv": self.request.get("secret_env"),
            "sourceProvenanceHash": self.request.get("source_provenance_hash"),
            "substitutionOption": self.request.get("substitution_option"),
            "volumes": [BuildOptionsVolume(item).to_request() for item in (self.request.get("volumes") or [])],
            "workerPool": self.request.get("worker_pool"),
        }

    def _response(self):
        return {
            "diskSizeGb": self.response.get("diskSizeGb"),
            "dynamicSubstitutions": self.response.get("dynamicSubstitutions"),
            "env": self.response.get("env"),
            "logStreamingOption": self.response.get("logStreamingOption"),
            "logging": self.response.get("logging"),
            "machineType": self.response.get("machineType"),
            "requestedVerifyOption": self.response.get("requestedVerifyOption"),
            "secretEnv": self.response.get("secretEnv"),
            "sourceProvenanceHash": self.response.get("sourceProvenanceHash"),
            "substitutionOption": self.response.get("substitutionOption"),
            "volumes": [BuildOptionsVolume().from_response(item) for item in (self.response.get("volumes") or [])],
            "workerPool": self.response.get("workerPool"),
        }


class BuildOptionsVolume(gcp.Resource):
    def _request(self):
        return {
            "name": self.request.get("name"),
            "path": self.request.get("path"),
        }

    def _response(self):
        return {
            "name": self.response.get("name"),
            "path": self.response.get("path"),
        }


class BuildSecret(gcp.Resource):
    def _request(self):
        return {
            "kmsKeyName": self.request.get("kms_key_name"),
            "secretEnv": self.request.get("secret_env"),
        }

    def _response(self):
        return {
            "kmsKeyName": self.response.get("kmsKeyName"),
            "secretEnv": self.response.get("secretEnv"),
        }


class BuildSource(gcp.Resource):
    def _request(self):
        return {
            "repoSource": BuildSourceRepoSource(self.request.get("repo_source", {})).to_request(),
            "storageSource": BuildSourceStorageSource(self.request.get("storage_source", {})).to_request(),
        }

    def _response(self):
        return {
            "repoSource": BuildSourceRepoSource().from_response(self.response.get("repoSource", {})),
            "storageSource": BuildSourceStorageSource().from_response(self.response.get("storageSource", {})),
        }


class BuildSourceRepoSource(gcp.Resource):
    def _request(self):
        return {
            "branchName": self.request.get("branch_name"),
            "commitSha": self.request.get("commit_sha"),
            "dir": self.request.get("dir"),
            "invertRegex": self.request.get("invert_regex"),
            "projectId": self.request.get("project_id"),
            "repoName": self.request.get("repo_name"),
            "substitutions": self.request.get("substitutions"),
            "tagName": self.request.get("tag_name"),
        }

    def _response(self):
        return {
            "branchName": self.response.get("branchName"),
            "commitSha": self.response.get("commitSha"),
            "dir": self.response.get("dir"),
            "invertRegex": self.response.get("invertRegex"),
            "projectId": self.response.get("projectId"),
            "repoName": self.response.get("repoName"),
            "substitutions": self.response.get("substitutions"),
            "tagName": self.response.get("tagName"),
        }


class BuildSourceStorageSource(gcp.Resource):
    def _request(self):
        return {
            "bucket": self.request.get("bucket"),
            "generation": self.request.get("generation"),
            "object": self.request.get("object"),
        }

    def _response(self):
        return {
            "bucket": self.response.get("bucket"),
            "generation": self.response.get("generation"),
            "object": self.response.get("object"),
        }


class BuildStep(gcp.Resource):
    def _request(self):
        return {
            "allowExitCodes": self.request.get("allow_exit_codes"),
            "allowFailure": self.request.get("allow_failure"),
            "args": self.request.get("args"),
            "dir": self.request.get("dir"),
            "entrypoint": self.request.get("entrypoint"),
            "env": self.request.get("env"),
            "id": self.request.get("id"),
            "name": self.request.get("name"),
            "script": self.request.get("script"),
            "secretEnv": self.request.get("secret_env"),
            "timeout": self.request.get("timeout"),
            "timing": self.request.get("timing"),
            "volumes": [BuildStepVolume(item).to_request() for item in (self.request.get("volumes") or [])],
            "waitFor": self.request.get("wait_for"),
        }

    def _response(self):
        return {
            "allowExitCodes": self.response.get("allowExitCodes"),
            "allowFailure": self.response.get("allowFailure"),
            "args": self.response.get("args"),
            "dir": self.response.get("dir"),
            "entrypoint": self.response.get("entrypoint"),
            "env": self.response.get("env"),
            "id": self.response.get("id"),
            "name": self.response.get("name"),
            "script": self.response.get("script"),
            "secretEnv": self.response.get("secretEnv"),
            "timeout": self.response.get("timeout"),
            "timing": self.response.get("timing"),
            "volumes": [BuildStepVolume().from_response(item) for item in (self.response.get("volumes") or [])],
            "waitFor": self.response.get("waitFor"),
        }


class BuildStepVolume(gcp.Resource):
    def _request(self):
        return {
            "name": self.request.get("name"),
            "path": self.request.get("path"),
        }

    def _response(self):
        return {
            "name": self.response.get("name"),
            "path": self.response.get("path"),
        }


class GitFileSource(gcp.Resource):
    def _request(self):
        return {
            "bitbucketServerConfig": self.request.get("bitbucket_server_config"),
            "githubEnterpriseConfig": self.request.get("github_enterprise_config"),
            "path": self.request.get("path"),
            "repoType": self.request.get("repo_type"),
            "repository": self.request.get("repository"),
            "revision": self.request.get("revision"),
            "uri": self.request.get("uri"),
        }

    def _response(self):
        return {
            "bitbucketServerConfig": self.response.get("bitbucketServerConfig"),
            "githubEnterpriseConfig": self.response.get("githubEnterpriseConfig"),
            "path": self.response.get("path"),
            "repoType": self.response.get("repoType"),
            "repository": self.response.get("repository"),
            "revision": self.response.get("revision"),
            "uri": self.response.get("uri"),
        }


class Github(gcp.Resource):
    def _request(self):
        return {
            "enterpriseConfigResourceName": self.request.get("enterprise_config_resource_name"),
            "name": self.request.get("name"),
            "owner": self.request.get("owner"),
            "pullRequest": GithubPullRequest(self.request.get("pull_request", {})).to_request(),
            "push": GithubPush(self.request.get("push", {})).to_request(),
        }

    def _response(self):
        return {
            "enterpriseConfigResourceName": self.response.get("enterpriseConfigResourceName"),
            "name": self.response.get("name"),
            "owner": self.response.get("owner"),
            "pullRequest": GithubPullRequest().from_response(self.response.get("pullRequest", {})),
            "push": GithubPush().from_response(self.response.get("push", {})),
        }


class GithubPullRequest(gcp.Resource):
    def _request(self):
        return {
            "branch": self.request.get("branch"),
            "commentControl": self.request.get("comment_control"),
            "invertRegex": self.request.get("invert_regex"),
        }

    def _response(self):
        return {
            "branch": self.response.get("branch"),
            "commentControl": self.response.get("commentControl"),
            "invertRegex": self.response.get("invertRegex"),
        }


class GithubPush(gcp.Resource):
    def _request(self):
        return {
            "branch": self.request.get("branch"),
            "invertRegex": self.request.get("invert_regex"),
            "tag": self.request.get("tag"),
        }

    def _response(self):
        return {
            "branch": self.response.get("branch"),
            "invertRegex": self.response.get("invertRegex"),
            "tag": self.response.get("tag"),
        }


class PubsubConfig(gcp.Resource):
    def _request(self):
        return {
            "service_account_email": self.request.get("service_account_email"),
            "topic": self.request.get("topic"),
        }

    def _response(self):
        return {
            "service_account_email": self.response.get("service_account_email"),
            "state": self.response.get("state"),
            "subscription": self.response.get("subscription"),
            "topic": self.response.get("topic"),
        }


class RepositoryEventConfig(gcp.Resource):
    def _request(self):
        return {
            "pullRequest": RepositoryEventConfigPullRequest(self.request.get("pull_request", {})).to_request(),
            "push": RepositoryEventConfigPush(self.request.get("push", {})).to_request(),
            "repository": self.request.get("repository"),
        }

    def _response(self):
        return {
            "pullRequest": RepositoryEventConfigPullRequest().from_response(self.response.get("pullRequest", {})),
            "push": RepositoryEventConfigPush().from_response(self.response.get("push", {})),
            "repository": self.response.get("repository"),
        }


class RepositoryEventConfigPullRequest(gcp.Resource):
    def _request(self):
        return {
            "branch": self.request.get("branch"),
            "commentControl": self.request.get("comment_control"),
            "invertRegex": self.request.get("invert_regex"),
        }

    def _response(self):
        return {
            "branch": self.response.get("branch"),
            "commentControl": self.response.get("commentControl"),
            "invertRegex": self.response.get("invertRegex"),
        }


class RepositoryEventConfigPush(gcp.Resource):
    def _request(self):
        return {
            "branch": self.request.get("branch"),
            "invertRegex": self.request.get("invert_regex"),
            "tag": self.request.get("tag"),
        }

    def _response(self):
        return {
            "branch": self.response.get("branch"),
            "invertRegex": self.response.get("invertRegex"),
            "tag": self.response.get("tag"),
        }


class SourceToBuild(gcp.Resource):
    def _request(self):
        return {
            "bitbucketServerConfig": self.request.get("bitbucket_server_config"),
            "githubEnterpriseConfig": self.request.get("github_enterprise_config"),
            "ref": self.request.get("ref"),
            "repoType": self.request.get("repo_type"),
            "repository": self.request.get("repository"),
            "uri": self.request.get("uri"),
        }

    def _response(self):
        return {
            "bitbucketServerConfig": self.response.get("bitbucketServerConfig"),
            "githubEnterpriseConfig": self.response.get("githubEnterpriseConfig"),
            "ref": self.response.get("ref"),
            "repoType": self.response.get("repoType"),
            "repository": self.response.get("repository"),
            "uri": self.response.get("uri"),
        }


class TriggerTemplate(gcp.Resource):
    def _request(self):
        return {
            "branchName": self.request.get("branch_name"),
            "commitSha": self.request.get("commit_sha"),
            "dir": self.request.get("dir"),
            "invertRegex": self.request.get("invert_regex"),
            "projectId": self.request.get("project_id"),
            "repoName": self.request.get("repo_name"),
            "tagName": self.request.get("tag_name"),
        }

    def _response(self):
        return {
            "branchName": self.response.get("branchName"),
            "commitSha": self.response.get("commitSha"),
            "dir": self.response.get("dir"),
            "invertRegex": self.response.get("invertRegex"),
            "projectId": self.response.get("projectId"),
            "repoName": self.response.get("repoName"),
            "tagName": self.response.get("tagName"),
        }


class WebhookConfig(gcp.Resource):
    def _request(self):
        return {
            "secret": self.request.get("secret"),
        }

    def _response(self):
        return {
            "secret": self.response.get("secret"),
            "state": self.response.get("state"),
        }


class CloudBuild(gcp.Resource):
    def _request(self):
        return {
            "approvalConfig": ApprovalConfig(self.request.get("approval_config", {})).to_request(),
            "bitbucketServerTriggerConfig": BitbucketServerTriggerConfig(
                self.request.get("bitbucket_server_trigger_config", {})
            ).to_request(),
            "build": Build(self.request.get("build", {})).to_request(),
            "description": self.request.get("description"),
            "disabled": self.request.get("disabled"),
            "filename": self.request.get("filename"),
            "filter": self.request.get("filter"),
            "gitFileSource": GitFileSource(self.request.get("git_file_source", {})).to_request(),
            "github": Github(self.request.get("github", {})).to_request(),
            "ignoredFiles": [str(item) for item in (self.request.get("ignored_files") or [])],
            "includeBuildLogs": self.request.get("include_build_logs"),
            "includedFiles": [str(item) for item in (self.request.get("included_files") or [])],
            "name": self.request.get("name"),
            "pubsubConfig": PubsubConfig(self.request.get("pubsub_config", {})).to_request(),
            "repositoryEventConfig": RepositoryEventConfig(
                self.request.get("repository_event_config", {})
            ).to_request(),
            "serviceAccount": self.request.get("service_account"),
            "sourceToBuild": SourceToBuild(self.request.get("source_to_build", {})).to_request(),
            "substitutions": self.request.get("substitutions"),
            "tags": [str(item) for item in (self.request.get("tags") or [])],
            "triggerTemplate": TriggerTemplate(self.request.get("trigger_template", {})).to_request(),
            "webhookConfig": WebhookConfig(self.request.get("webhook_config", {})).to_request(),
        }

    def _response(self):
        return {
            "approvalConfig": ApprovalConfig().from_response(self.response.get("approvalConfig", {})),
            "bitbucketServerTriggerConfig": BitbucketServerTriggerConfig().from_response(
                self.response.get("bitbucketServerTriggerConfig", {})
            ),
            "build": Build().from_response(self.response.get("build", {})),
            "createTime": self.response.get("createTime"),
            "description": self.response.get("description"),
            "disabled": self.response.get("disabled"),
            "filename": self.response.get("filename"),
            "filter": self.response.get("filter"),
            "gitFileSource": GitFileSource().from_response(self.response.get("gitFileSource", {})),
            "github": Github().from_response(self.response.get("github", {})),
            "ignoredFiles": [str(item) for item in (self.response.get("ignoredFiles") or [])],
            "includeBuildLogs": self.response.get("includeBuildLogs"),
            "includedFiles": [str(item) for item in (self.response.get("includedFiles") or [])],
            "name": self.response.get("name"),
            "pubsubConfig": PubsubConfig().from_response(self.response.get("pubsubConfig", {})),
            "repositoryEventConfig": RepositoryEventConfig().from_response(
                self.response.get("repositoryEventConfig", {})
            ),
            "serviceAccount": self.response.get("serviceAccount"),
            "sourceToBuild": SourceToBuild().from_response(self.response.get("sourceToBuild", {})),
            "substitutions": self.response.get("substitutions"),
            "tags": [str(item) for item in (self.response.get("tags") or [])],
            "triggerTemplate": TriggerTemplate().from_response(self.response.get("triggerTemplate", {})),
            "id": self.response.get("id"),
            "webhookConfig": WebhookConfig().from_response(self.response.get("webhookConfig", {})),
        }


################################################################################
# Main
################################################################################


def encode(obj):
    """
    The encoder is a function which take the `obj` map after it has been
    read from the module caller and mutates it before it is sent to the server
    """

    if obj is None:
        return None
    r = copy.deepcopy(obj)
    # --------- BEGIN custom encoder code ---------
    # --------- END custom encoder code ---------

    return r


def decode(obj):
    """
    The decoder is a function which takes the `obj` map after the read succeeds
    and mutates it before it is returned to the module caller
    """

    if obj is None:
        return None
    r = copy.deepcopy(obj)
    # --------- BEGIN custom decoder code ---------
    # --------- END custom decoder code ---------

    return r


def main():
    """Main function"""

    module = gcp.Module(
        argument_spec=dict(
            name=dict(
                type="str",
            ),
            state=dict(
                type="str",
                default="present",
                choices=["present", "absent"],
            ),
            approval_config=dict(
                type="dict",
                options=dict(
                    approval_required=dict(
                        type="bool",
                        default=False,
                    )
                ),
            ),
            bitbucket_server_trigger_config=dict(
                type="dict",
                options=dict(
                    bitbucket_server_config_resource=dict(
                        type="str",
                        required=True,
                    ),
                    project_key=dict(
                        type="str",
                        required=True,
                        no_log=False,
                    ),
                    pull_request=dict(
                        type="dict",
                        options=dict(
                            branch=dict(
                                type="str",
                                required=True,
                            ),
                            comment_control=dict(
                                type="str",
                                choices=[
                                    "COMMENTS_DISABLED",
                                    "COMMENTS_ENABLED",
                                    "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY",
                                ],
                            ),
                            invert_regex=dict(
                                type="bool",
                            ),
                        ),
                    ),
                    push=dict(
                        type="dict",
                        options=dict(
                            branch=dict(
                                type="str",
                            ),
                            invert_regex=dict(
                                type="bool",
                            ),
                            tag=dict(
                                type="str",
                            ),
                        ),
                    ),
                    repo_slug=dict(
                        type="str",
                        required=True,
                    ),
                ),
            ),
            build=dict(
                type="dict",
                options=dict(
                    artifacts=dict(
                        type="dict",
                        options=dict(
                            images=dict(
                                type="list",
                                elements="str",
                            ),
                            maven_artifacts=dict(
                                type="list",
                                elements="dict",
                                options=dict(
                                    artifact_id=dict(
                                        type="str",
                                    ),
                                    group_id=dict(
                                        type="str",
                                    ),
                                    path=dict(
                                        type="str",
                                    ),
                                    repository=dict(
                                        type="str",
                                    ),
                                    version=dict(
                                        type="str",
                                    ),
                                ),
                            ),
                            npm_packages=dict(
                                type="list",
                                elements="dict",
                                options=dict(
                                    package_path=dict(
                                        type="str",
                                    ),
                                    repository=dict(
                                        type="str",
                                    ),
                                ),
                            ),
                            objects=dict(
                                type="dict",
                                options=dict(
                                    location=dict(
                                        type="str",
                                    ),
                                    paths=dict(
                                        type="list",
                                        elements="str",
                                    ),
                                    timing=dict(
                                        type="dict",
                                        options=dict(
                                            end_time=dict(
                                                type="str",
                                            ),
                                            start_time=dict(
                                                type="str",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                            python_packages=dict(
                                type="list",
                                elements="dict",
                                options=dict(
                                    paths=dict(
                                        type="list",
                                        elements="str",
                                    ),
                                    repository=dict(
                                        type="str",
                                    ),
                                ),
                            ),
                        ),
                    ),
                    available_secrets=dict(
                        type="dict",
                        no_log=False,
                        options=dict(
                            secret_manager=dict(
                                type="list",
                                required=True,
                                elements="dict",
                                no_log=False,
                                options=dict(
                                    env=dict(
                                        type="str",
                                        required=True,
                                    ),
                                    version_name=dict(
                                        type="str",
                                        required=True,
                                    ),
                                ),
                            )
                        ),
                    ),
                    images=dict(
                        type="list",
                        elements="str",
                    ),
                    logs_bucket=dict(
                        type="str",
                    ),
                    options=dict(
                        type="dict",
                        options=dict(
                            disk_size_gb=dict(
                                type="int",
                            ),
                            dynamic_substitutions=dict(
                                type="bool",
                            ),
                            env=dict(
                                type="list",
                                elements="str",
                            ),
                            log_streaming_option=dict(
                                type="str",
                                choices=["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"],
                            ),
                            logging=dict(
                                type="str",
                                choices=[
                                    "LOGGING_UNSPECIFIED",
                                    "LEGACY",
                                    "GCS_ONLY",
                                    "STACKDRIVER_ONLY",
                                    "CLOUD_LOGGING_ONLY",
                                    "NONE",
                                ],
                            ),
                            machine_type=dict(
                                type="str",
                            ),
                            requested_verify_option=dict(
                                type="str",
                                choices=["NOT_VERIFIED", "VERIFIED"],
                            ),
                            secret_env=dict(
                                type="list",
                                elements="str",
                                no_log=False,
                            ),
                            source_provenance_hash=dict(
                                type="list",
                                elements="str",
                            ),
                            substitution_option=dict(
                                type="str",
                                choices=["MUST_MATCH", "ALLOW_LOOSE"],
                            ),
                            volumes=dict(
                                type="list",
                                elements="dict",
                                options=dict(
                                    name=dict(
                                        type="str",
                                    ),
                                    path=dict(
                                        type="str",
                                    ),
                                ),
                            ),
                            worker_pool=dict(
                                type="str",
                            ),
                        ),
                    ),
                    queue_ttl=dict(
                        type="str",
                    ),
                    secret=dict(
                        type="list",
                        elements="dict",
                        no_log=False,
                        options=dict(
                            kms_key_name=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            secret_env=dict(
                                type="dict",
                                no_log=False,
                            ),
                        ),
                    ),
                    source=dict(
                        type="dict",
                        options=dict(
                            repo_source=dict(
                                type="dict",
                                options=dict(
                                    branch_name=dict(
                                        type="str",
                                    ),
                                    commit_sha=dict(
                                        type="str",
                                    ),
                                    dir=dict(
                                        type="str",
                                    ),
                                    invert_regex=dict(
                                        type="bool",
                                    ),
                                    project_id=dict(
                                        type="str",
                                    ),
                                    repo_name=dict(
                                        type="str",
                                        required=True,
                                    ),
                                    substitutions=dict(
                                        type="dict",
                                    ),
                                    tag_name=dict(
                                        type="str",
                                    ),
                                ),
                            ),
                            storage_source=dict(
                                type="dict",
                                options=dict(
                                    bucket=dict(
                                        type="str",
                                        required=True,
                                    ),
                                    generation=dict(
                                        type="str",
                                    ),
                                    object=dict(
                                        type="str",
                                        required=True,
                                    ),
                                ),
                            ),
                        ),
                    ),
                    step=dict(
                        type="list",
                        required=True,
                        elements="dict",
                        options=dict(
                            allow_exit_codes=dict(
                                type="list",
                                elements="int",
                            ),
                            allow_failure=dict(
                                type="bool",
                            ),
                            args=dict(
                                type="list",
                                elements="str",
                            ),
                            dir=dict(
                                type="str",
                            ),
                            entrypoint=dict(
                                type="str",
                            ),
                            env=dict(
                                type="list",
                                elements="str",
                            ),
                            id=dict(
                                type="str",
                            ),
                            name=dict(
                                type="str",
                                required=True,
                            ),
                            script=dict(
                                type="str",
                            ),
                            secret_env=dict(
                                type="list",
                                elements="str",
                                no_log=False,
                            ),
                            timeout=dict(
                                type="str",
                            ),
                            timing=dict(
                                type="str",
                            ),
                            volumes=dict(
                                type="list",
                                elements="dict",
                                options=dict(
                                    name=dict(
                                        type="str",
                                        required=True,
                                    ),
                                    path=dict(
                                        type="str",
                                        required=True,
                                    ),
                                ),
                            ),
                            wait_for=dict(
                                type="list",
                                elements="str",
                            ),
                        ),
                    ),
                    substitutions=dict(
                        type="dict",
                    ),
                    tags=dict(
                        type="list",
                        elements="str",
                    ),
                    timeout=dict(
                        type="str",
                        default="600s",
                    ),
                ),
            ),
            description=dict(
                type="str",
            ),
            disabled=dict(
                type="bool",
            ),
            filename=dict(
                type="str",
            ),
            filter=dict(
                type="str",
            ),
            git_file_source=dict(
                type="dict",
                options=dict(
                    bitbucket_server_config=dict(
                        type="str",
                    ),
                    github_enterprise_config=dict(
                        type="str",
                    ),
                    path=dict(
                        type="str",
                        required=True,
                    ),
                    repo_type=dict(
                        type="str",
                        required=True,
                        choices=["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET_SERVER"],
                    ),
                    repository=dict(
                        type="str",
                    ),
                    revision=dict(
                        type="str",
                    ),
                    uri=dict(
                        type="str",
                    ),
                ),
            ),
            github=dict(
                type="dict",
                options=dict(
                    enterprise_config_resource_name=dict(
                        type="str",
                    ),
                    name=dict(
                        type="str",
                    ),
                    owner=dict(
                        type="str",
                    ),
                    pull_request=dict(
                        type="dict",
                        options=dict(
                            branch=dict(
                                type="str",
                                required=True,
                            ),
                            comment_control=dict(
                                type="str",
                                choices=[
                                    "COMMENTS_DISABLED",
                                    "COMMENTS_ENABLED",
                                    "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY",
                                ],
                            ),
                            invert_regex=dict(
                                type="bool",
                            ),
                        ),
                    ),
                    push=dict(
                        type="dict",
                        options=dict(
                            branch=dict(
                                type="str",
                            ),
                            invert_regex=dict(
                                type="bool",
                            ),
                            tag=dict(
                                type="str",
                            ),
                        ),
                    ),
                ),
            ),
            ignored_files=dict(
                type="list",
                elements="str",
            ),
            include_build_logs=dict(
                type="str",
                choices=["INCLUDE_BUILD_LOGS_UNSPECIFIED", "INCLUDE_BUILD_LOGS_WITH_STATUS"],
            ),
            included_files=dict(
                type="list",
                elements="str",
            ),
            location=dict(
                type="str",
                default="global",
            ),
            pubsub_config=dict(
                type="dict",
                options=dict(
                    service_account_email=dict(
                        type="str",
                    ),
                    state=dict(
                        type="str",
                    ),
                    subscription=dict(
                        type="str",
                    ),
                    topic=dict(
                        type="str",
                        required=True,
                    ),
                ),
            ),
            repository_event_config=dict(
                type="dict",
                options=dict(
                    pull_request=dict(
                        type="dict",
                        options=dict(
                            branch=dict(
                                type="str",
                            ),
                            comment_control=dict(
                                type="str",
                                choices=[
                                    "COMMENTS_DISABLED",
                                    "COMMENTS_ENABLED",
                                    "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY",
                                ],
                            ),
                            invert_regex=dict(
                                type="bool",
                            ),
                        ),
                    ),
                    push=dict(
                        type="dict",
                        options=dict(
                            branch=dict(
                                type="str",
                            ),
                            invert_regex=dict(
                                type="bool",
                            ),
                            tag=dict(
                                type="str",
                            ),
                        ),
                    ),
                    repository=dict(
                        type="str",
                    ),
                ),
            ),
            service_account=dict(
                type="str",
            ),
            source_to_build=dict(
                type="dict",
                options=dict(
                    bitbucket_server_config=dict(
                        type="str",
                    ),
                    github_enterprise_config=dict(
                        type="str",
                    ),
                    ref=dict(
                        type="str",
                        required=True,
                    ),
                    repo_type=dict(
                        type="str",
                        required=True,
                        choices=["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET_SERVER"],
                    ),
                    repository=dict(
                        type="str",
                    ),
                    uri=dict(
                        type="str",
                    ),
                ),
            ),
            substitutions=dict(
                type="dict",
            ),
            tags=dict(
                type="list",
                elements="str",
            ),
            trigger_template=dict(
                type="dict",
                options=dict(
                    branch_name=dict(
                        type="str",
                    ),
                    commit_sha=dict(
                        type="str",
                    ),
                    dir=dict(
                        type="str",
                    ),
                    invert_regex=dict(
                        type="bool",
                    ),
                    project_id=dict(
                        type="str",
                    ),
                    repo_name=dict(
                        type="str",
                        default="default",
                    ),
                    tag_name=dict(
                        type="str",
                    ),
                ),
            ),
            webhook_config=dict(
                type="dict",
                options=dict(
                    secret=dict(
                        type="str",
                        required=True,
                        no_log=False,
                    ),
                    state=dict(
                        type="str",
                    ),
                ),
            ),
        )
    )

    if not module.params["scopes"]:
        module.params["scopes"] = ["https://www.googleapis.com/auth/cloud-platform"]

    state = module.params["state"]
    changed = False

    op_configs = gcp.ResourceOpConfigs(
        {
            "base_url": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/triggers",
                    "async_uri": "",
                    "verb": "GET",
                    "timeout_minutes": 0,
                }
            ),
            "create": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/triggers",
                    "async_uri": "",
                    "verb": "POST",
                    "timeout_minutes": 20,
                }
            ),
            "delete": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/triggers/{trigger_id}",
                    "async_uri": "",
                    "verb": "DELETE",
                    "timeout_minutes": 20,
                }
            ),
            "read": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/triggers/{trigger_id}",
                    "async_uri": "",
                    "verb": "GET",
                    "timeout_minutes": 0,
                }
            ),
            "update": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/triggers/{trigger_id}",
                    "async_uri": "",
                    "verb": "PATCH",
                    "timeout_minutes": 20,
                }
            ),
        }
    )

    params = gcp.remove_nones_from_dict(module.params)
    resource = CloudBuild(
        params, module=module, product="CloudBuild", kind="cloudbuild#trigger", encoder=encode, decoder=decode
    )
    # --------- BEGIN custom pre-read code ---------
    # set the trigger ID from name before reading
    module.params["trigger_id"] = module.params["name"]
    # --------- END custom pre-read code ---------
    read_url = build_link(module, op_configs.read.uri)
    existing_obj = resource.get(read_url, allow_not_found=True)

    if existing_obj is None:
        if state == "present":
            # --------- BEGIN custom pre-create code ---------
            # set the trigger ID from name before creation
            module.params["trigger_id"] = module.params["name"]
            # --------- END custom pre-create code ---------
            is_async = op_configs.create.async_uri != ""
            create_link = build_link(module, op_configs.create.uri)
            create_retries = op_configs.create.timeout
            create_func = getattr(resource, op_configs.create.verb)
            async_create_func = getattr(resource, op_configs.create.verb + "_async")
            async_create_link = build_link(module, "") + op_configs.create.async_uri
            gcp.debug(
                module,
                msg="Creating resource",
                create_link=create_link,
                async_create_link=async_create_link,
                is_async=is_async,
            )
            try:
                if is_async:
                    new_obj = async_create_func(create_link, async_link=async_create_link, retries=create_retries)
                else:
                    new_obj = create_func(create_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            pass  # nothing to do
    else:
        if state == "absent":
            # --------- BEGIN custom pre-delete code ---------
            # set the trigger ID from the existing object's ID before delete
            if existing_obj.get("id") is None:
                module.params["trigger_id"] = existing_obj["name"]
            else:
                module.params["trigger_id"] = existing_obj["id"]
            # --------- END custom pre-delete code ---------
            is_async = op_configs.delete.async_uri != ""
            delete_link = build_link(module, op_configs.delete.uri)
            delete_retries = op_configs.delete.timeout
            delete_func = getattr(resource, op_configs.delete.verb)
            async_delete_func = getattr(resource, op_configs.delete.verb + "_async")
            async_delete_link = build_link(module, "") + op_configs.delete.async_uri
            gcp.debug(
                module,
                msg="Destroying resource",
                delete_link=delete_link,
                async_delete_link=async_delete_link,
                is_async=is_async,
            )
            try:
                if is_async:
                    new_obj = async_delete_func(delete_link, async_link=async_delete_link, retries=delete_retries)
                else:
                    new_obj = delete_func(delete_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            gcp.debug(module, existing=existing_obj, request=resource.to_request())
            if resource.diff(existing_obj):
                # --------- BEGIN custom pre-update code ---------
                # set the trigger ID from the existing object's ID before update
                if existing_obj.get("id") is None:
                    module.params["trigger_id"] = existing_obj["name"]
                else:
                    module.params["trigger_id"] = existing_obj["id"]
                # --------- END custom pre-update code ---------
                is_async = op_configs.update.async_uri != ""
                update_link = build_link(module, op_configs.update.uri)
                update_retries = op_configs.update.timeout
                update_func = getattr(resource, op_configs.update.verb)
                async_update_func = getattr(resource, op_configs.update.verb + "_async")
                async_update_link = build_link(module, "") + op_configs.update.async_uri
                gcp.debug(
                    module,
                    msg="Updating resource",
                    update_link=update_link,
                    async_update_link=async_update_link,
                    is_async=is_async,
                )
                try:
                    if is_async:
                        new_obj = async_update_func(update_link, async_link=async_update_link, retries=update_retries)
                    else:
                        new_obj = update_func(update_link)
                except Exception as e:
                    module.fail_json(msg=str(e))
                changed = True

    new_obj = resource.get(read_url, allow_not_found=True)
    new_obj = resource.from_response(new_obj or {})

    new_obj.update({"changed": changed})
    module.exit_json(**new_obj)


if __name__ == "__main__":
    main()
