# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASExodiff clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASExodiff requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASExodiff build
## ---------------------------------------------------------------------------

set(SEACASExodiff_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(SEACASExodiff_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(SEACASExodiff_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASExodiff_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASExodiff build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASExodiff_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASExodiff_CXX_FLAGS [[ ]])

set(SEACASExodiff_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASExodiff_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASExodiff_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASExodiff_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASExodiff_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(SEACASExodiff_BUILD_SHARED_LIBS "ON")

set(SEACASExodiff_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(SEACASExodiff_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASExodiff_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(SEACASExodiff_LIBRARIES SEACASExodiff::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASExodiff_MPI_LIBRARIES "")
set(SEACASExodiff_MPI_LIBRARY_DIRS "")
set(SEACASExodiff_MPI_INCLUDE_DIRS "")
set(SEACASExodiff_MPI_EXEC "")
set(SEACASExodiff_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASExodiff_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(SEACASExodiff_ENABLE_SEACASExodus ON)
set(SEACASExodiff_ENABLE_SEACASSuplibC ON)
set(SEACASExodiff_ENABLE_SEACASSuplibCpp ON)

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages
if (NOT TARGET SEACASExodus::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
endif()
if (NOT TARGET SEACASSuplibC::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibC/SEACASSuplibCConfig.cmake")
endif()
if (NOT TARGET SEACASSuplibCpp::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibCpp/SEACASSuplibCppConfig.cmake")
endif()

# Import SEACASExodiff targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASExodiffTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASExodiff_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASExodiff_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASExodiff_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASExodiff_EXPORTED_PACKAGE_LIBS_NAMES "")

foreach(libname IN LISTS SEACASExodiff_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASExodiff::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASExodiff::${libname}', or better yet,"
      " 'SEACASExodiff::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASExodiff'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASExodiff_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
