# gh label

> Work with GitHub labels.
> More information: <https://cli.github.com/manual/gh_label>.

- List labels for the repository in the current directory:

`gh label {{[ls|list]}}`

- View labels for the repository in the current directory in the default web browser:

`gh label {{[ls|list]}} {{[-w|--web]}}`

- Create a label with a specific name, description, and color in hexadecimal format for the repository in the current directory:

`gh label create {{name}} {{[-d|--description]}} "{{description}}" {{[-c|--color]}} {{color_hex}}`

- Delete a label for the repository in the current directory, prompting for confirmation:

`gh label delete {{name}}`

- Update the name and description for a specific label for the repository in the current directory:

`gh label edit {{name}} {{[-n|--name]}} {{new_name}} {{[-d|--description]}} "{{description}}"`

- Clone labels from a specific repository into the repository in the current directory:

`gh label clone {{owner}}/{{repository}}`

- Display help for a subcommand:

`gh label {{subcommand}} {{[-h|--help]}}`
