# npm diff

> Сравнивать версии пакетов из реестра `npm` и показывать различия.
> Аналогичен `git diff`.
> Больше информации: <https://docs.npmjs.com/cli/npm-diff/>.

- Сравнить две конкретные версии пакета:

`npm diff --diff {{пакет}}@{{версия1}} --diff {{пакет}}@{{версия2}}`

- Сравнить текущие локальные пакеты с последней опубликованной версией:

`npm diff`

- Сравнить текущий локальный пакет с конкретной версией:

`npm diff --diff {{пакет}}@{{версия}}`

- Сравнить пакет в текущем каталоге с версией из реестра:

`npm diff --diff {{пакет}}`

- Показать только имена отличающихся файлов:

`npm diff --diff-name-only --diff {{пакет}}@{{версия1}} --diff {{пакет}}@{{версия2}}`

- Сравнить только конкретные файлы или каталоги:

`npm diff {{путь/к/файлу_или_каталогу}} --diff {{пакет}}@{{версия1}} --diff {{пакет}}@{{версия2}}`

- Игнорировать пробелы при сравнении:

`npm diff --diff-ignore-all-space --diff {{пакет}}@{{версия1}} --diff {{пакет}}@{{версия2}}`
