# tarsnap

> 원격 Tarsnap 암호화 백업을 조작.
> 참고: `/usr/local/etc/tarsnap.conf` 또는 `~/.tarsnaprc`에서 설정하면 키 파일과 캐시 디렉토리를 지정할 필요가 없습니다.
> 같이 보기: `tarsnap-keygen`.
> 더 많은 정보: <https://www.tarsnap.com/man-tarsnap.1.html>.

- 하나 이상의 파일 또는 디렉토리에 대한 백업 아카이브 생성, 암호화 키와 캐시 디렉토리 지정:

`tarsnap -c --keyfile {{경로/대상/키_파일}} --cachedir {{경로/대상/캐시_디렉토리}} -f {{아카이브_이름}} {{경로/대상/파일_또는_디렉토리1 경로/대상/파일_또는_디렉토리2 ...}}`

- 업로드될 데이터 양 표시:

`tarsnap -c --dry-run --print-stats --keyfile {{경로/대상/키_파일}} --cachedir {{경로/대상/캐시_디렉토리}} -f {{아카이브_이름}} {{경로/대상/파일_또는_디렉토리1 경로/대상/파일_또는_디렉토리2 ...}}`

- 저장된 아카이브 목록 표시:

`tarsnap --list-archives --keyfile {{경로/대상/키_파일}}`

- 특정 아카이브 삭제:

`tarsnap -d --keyfile {{경로/대상/키_파일}} --cachedir {{경로/대상/캐시_디렉토리}} -f {{아카이브_이름}}`

- 특정 아카이브의 내용을 상세 모드로 목록화:

`tarsnap -tv --keyfile {{경로/대상/키_파일}} -f {{아카이브_이름}}`

- 특정 아카이브에서 하나 이상의 파일 또는 디렉토리 복원:

`tarsnap -x --keyfile {{경로/대상/키_파일}} -f {{아카이브_이름}} {{경로/대상/파일_또는_디렉토리1 경로/대상/파일_또는_디렉토리2 ...}}`

- 아카이브 복사:

`tarsnap -c --keyfile {{경로/대상/키_파일}} -f {{새_아카이브_이름}} @@{{원본_아카이브_이름}}`
