# ssh

> Secure Shell은 원격 시스템에 안전하게 로그인하기 위한 프로토콜입니다.
> 원격 서버에 로그인하거나 명령을 실행하는 데 사용할 수 있습니다.
> 더 많은 정보: <https://man.openbsd.org/ssh>.

- 원격 서버에 연결:

`ssh {{사용자 명}}@{{원격_호스트}}`

- 특정 신원(개인 키)으로 원격 서버에 연결:

`ssh -i {{경로/대상/키_파일}} {{사용자 명}}@{{원격_호스트}}`

- 특정 [p]포트를 사용하여 원격 서버에 연결:

`ssh {{사용자 명}}@{{원격_호스트}} -p {{2222}}`

- [t]ty 할당을 통해 원격 명령과 상호 작용하며 원격 서버에서 명령 실행:

`ssh {{사용자 명}}@{{원격_호스트}} -t {{명령어}} {{명령어_인자}}`

- SSH 터널링: [D]동적 포트 포워딩 (`localhost:1080`의 SOCKS 프록시):

`ssh -D {{1080}} {{사용자 명}}@{{원격_호스트}}`

- SSH 터널링: 특정 포트 포워딩 (`localhost:9999`에서 `example.org:80`)과 함께 의사-[T]ty 할당 및 원격 명령 실행 비활성화:

`ssh -L {{9999}}:{{example.org}}:{{80}} -N -T {{사용자 명}}@{{원격_호스트}}`

- SSH [J]점핑: 점프 호스트를 통해 원격 서버에 연결 (여러 점프 홉을 쉼표로 구분하여 지정 가능):

`ssh -J {{사용자 명}}@{{점프_호스트}} {{사용자 명}}@{{원격_호스트}}`

- 멈춘 세션 종료:

`<Enter><~><.>`
