# b2

> Accede fácilmente a todas las funciones de Backblaze B2 Cloud Storage.
> Más información: <https://www.backblaze.com/docs/cloud-storage-command-line-tools>.

- Accede a tu cuenta:

`b2 authorize_account {{clave_id}}`

- Lista los buckets existentes en tu cuenta:

`b2 list_buckets`

- Crea un cubo, indica el nombre del cubo y el tipo de acceso (por ejemplo, allPublic o allPrivate):

`b2 create_bucket {{nombre_cubo}} {{allPublic|allPrivate}}`

- Sube un archivo. Elige un archivo, un bucket y una carpeta:

`b2 upload_file {{nombre_cubo}} {{ruta/al/archivo}} {{nombre_carpeta}}`

- Sube un directorio de origen a un destino de Backblaze B2 bucket:

`b2 sync {{ruta/al/archivo_de_origen}} {{nombre_del_cubo}}`

- Copia un archivo de un bucket a otro bucket:

`b2 copy-file-by-id {{ruta/al/archivo_de_origen}} {{nombre_cubo_destino}} {{ruta/al/archivo/b2}}`

- Muestra los archivos de tu bucket:

`b2 ls {{nombre_bucket}}`

- Elimina una "carpeta" o un conjunto de archivos que coincidan con un patrón:

`b2 rm {{ruta/a/carpeta|patrón}}`
