# bzgrep

> `grep` ব্যবহার করে `bzip2` কম্প্রেসড ফাইলে প্যাটার্ন খুঁজুন।
> আরও তথ্য পাবেন: <https://manned.org/bzgrep>।

- একটি কম্প্রেসড ফাইলের মধ্যে একটি প্যাটার্ন অনুসন্ধান করুন:

`bzgrep "{{সার্চ_প্যাটার্ন}}" {{ফাইল/এর/পাথ}}`

- একটি bzip2 কম্প্রেসড `.tar` আর্কাইভে রিকার্সিভভাবে ফাইলে একটি প্যাটার্ন অনুসন্ধান করুন:

`bzgrep {{[-r|--recursive]}} "{{সার্চ_প্যাটার্ন}}" {{tar_ফাইল/এর/পাথ}}`

- প্রতিটি ম্যাচের আশেপাশে, আগে বা পরে 3 লাইনের [C]ontext প্রিন্ট করুন:

`bzgrep {{--context|--before-context|--after-context}} 3 "{{সার্চ_প্যাটার্ন}}" {{ফাইল/এর/পাথ}}`

- প্রতিটি ম্যাচের জন্য ফাইলের নাম এবং লাইন নম্বর প্রিন্ট করুন:

`bzgrep {{[-H|--with-filename]}} {{[-n|--line-number]}} "{{সার্চ_প্যাটার্ন}}" {{ফাইল/এর/পাথ}}`

- একটি প্যাটার্নের সাথে মিলে যাওয়া লাইন অনুসন্ধান করুন, শুধুমাত্র মিলে যাওয়া টেক্সট প্রিন্ট করুন:

`bzgrep {{[-o|--only-matching]}} "{{সার্চ_প্যাটার্ন}}" {{ফাইল/এর/পাথ}}`

- `stdin`-এ এমন লাইন অনুসন্ধান করুন যা প্যাটার্নের সাথে মেলে না:

`cat {{bz_কম্প্রেসড_ফাইল/এর/পাথ}} | bzgrep {{[-v|--invert-match]}} "{{সার্চ_প্যাটার্ন}}"`

- এক্সটেন্ডেড `regex` ব্যবহার করুন (`?`, `+`, `{}`, `()`, এবং `|` সাপোর্ট করে), case-insensitive মোডে:

`bzgrep {{[-E|--extended-regexp]}} {{[-i|--ignore-case]}} "{{সার্চ_প্যাটার্ন}}" {{ফাইল/এর/পাথ}}`
