# chmod

> 修改文件或目錄的存取權限。
> 使用者類型分為檔案所有者（u）、檔案所有者之群組（g）、以及其他使用者（o）。
> 更多資訊：<https://www.gnu.org/software/coreutils/manual/html_node/chmod-invocation.html>。

- 給予文件所有者執行的權限：

`chmod u+x {{檔案/完整/路徑}}`

- 給予使用者讀寫權利：

`chmod u+rw {{檔案/完整/路徑}}`

- 移除群組執行權限：

`chmod g-x {{檔案/完整/路徑}}`

- 給予全部使用者讀與執行權限：

`chmod a+rx {{檔案/完整/路徑}}`

- 給予其他使用者（o）和檔案所有者之群組（g）一樣的權限：

`chmod o=g {{檔案/完整/路徑}}`

- 移除其他使用者（o）的全部權限：

`chmod o= {{檔案/完整/路徑}}`

- 改變目錄底下所有檔案以及目錄的權限，給予檔案所有者之群組寫的權限，以及其他使用者寫的權限：

`chmod {{[-R|--recursive]}} g+w,o+w {{目標目錄}}`

- 改變目錄底下所有檔案以及目錄的權限，給予全部使用者讀與對其底下檔案之執行權限：

`chmod {{[-R|--recursive]}} a+rX {{目標目錄}}`
