# dotnet publish

> Публикует .NET-приложение и его зависимости в каталог для развёртывания на целевой системе.
> Больше информации: <https://learn.microsoft.com/dotnet/core/tools/dotnet-publish>.

- Скомпилировать проект .NET в режиме release:

`dotnet publish {{[-c|--configuration]}} Release {{путь/к/файлу_проекта}}`

- Опубликовать ваше приложение с заданной средой исполнения .NET Core:

`dotnet publish {{[-sc|--self-contained]}} true {{[-r|--runtime]}} {{идентификатор_среды_исполнения}} {{путь/к/файлу_проекта}}`

- Упаковать приложение в один исполняемый файл для заданной платформы:

`dotnet publish {{[-r|--runtime]}} {{идентификатор_среды_исполнения}} -p:PublishSingleFile=true {{путь/к/файлу_проекта}}`

- Обрезать неиспользуемые библиотеки чтобы уменьшить размер развёртывания приложения:

`dotnet publish {{[-sc|--self-contained]}} true {{[-r|--runtime]}} {{идентификатор_среды_исполнения}} -p:PublishTrimmed=true {{путь/к/файлу_проекта}}`

- Скомпилировать проект .NET без восстановления зависимостей:

`dotnet publish --no-restore {{путь/к/файлу_проекта}}`

- Указать целевой каталог:

`dotnet publish {{[-o|--output]}} {{путь/к/каталогу}} {{путь/к/файлу_проекта}}`
