/* Copyright 2024 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include "LIEF/MachO/BindingInfo.hpp"
#include "LIEF/rust/MachO/SegmentCommand.hpp"
#include "LIEF/rust/MachO/Dylib.hpp"
#include "LIEF/rust/MachO/Symbol.hpp"

class MachO_BindingInfo : public Mirror<LIEF::MachO::BindingInfo> {
  public:
  using lief_t = LIEF::MachO::BindingInfo;
  using Mirror::Mirror;

  uint64_t address() const { return get().address(); };
  int64_t addend() const { return get().addend(); };
  int32_t library_ordinal() const { return get().library_ordinal(); };

  auto library() const {
    return details::try_unique<MachO_Dylib>(get().library());
  }

  auto symbol() const {
    return details::try_unique<MachO_Symbol>(get().symbol());
  }

  auto segment() const {
    return details::try_unique<MachO_SegmentCommand>(get().segment());
  }
};
