import * as KernelMessage from './messages';
import { IModel } from './restapi';
/**
 * Validate a kernel message object.
 */
export declare function validateMessage(msg: KernelMessage.IMessage): asserts msg is KernelMessage.IMessage;
/**
 * Validate a `Kernel.IModel` object.
 */
export declare function validateModel(model: IModel): asserts model is IModel;
/**
 * Validate an array of `IModel` objects.
 */
export declare function validateModels(models: IModel[]): asserts models is IModel[];
