# Використання Request безпосередньо { #using-the-request-directly }

Дотепер ви оголошували потрібні вам частини запиту разом з їх типами.

Отримуючи дані з:
- шляху як параметрів;
- заголовків;
- кукі;
- тощо.

І таким чином **FastAPI** перевіряє ці дані, перетворює їх і автоматично генерує документацію для вашого API.

Але бувають ситуації, коли може знадобитися доступ до об'єкта `Request` безпосередньо.

## Деталі про об'єкт `Request` { #details-about-the-request-object }

Оскільки під капотом **FastAPI** - це **Starlette** з шаром інструментів зверху, ви можете за потреби використовувати <a href="https://www.starlette.dev/requests/" class="external-link" target="_blank">об'єкт `Request`</a> Starlette безпосередньо.

Це також означає, що якщо ви отримуєте дані безпосередньо з об'єкта `Request` (наприклад, читаєте тіло), FastAPI не буде їх перевіряти, перетворювати або документувати (через OpenAPI для автоматичного інтерфейсу користувача API).

Водночас будь-який інший параметр, оголошений звичайним способом (наприклад, тіло з моделлю Pydantic), і надалі буде перевірений, перетворений, анотований тощо.

Але є окремі випадки, коли корисно отримати об'єкт `Request`.

## Використовуйте об'єкт `Request` безпосередньо { #use-the-request-object-directly }

Припустімо, ви хочете отримати IP-адресу/хост клієнта всередині вашої функції операції шляху.

Для цього потрібно звернутися до запиту безпосередньо.

{* ../../docs_src/using_request_directly/tutorial001_py310.py hl[1,7:8] *}

Якщо вказати у функції операції шляху параметр типу `Request`, **FastAPI** передасть у нього об'єкт `Request`.

/// tip | Порада

Зауважте, що в цьому прикладі ми оголошуємо параметр шляху поряд із параметром запиту.

Тому параметр шляху буде витягнуто, перевірено, перетворено до вказаного типу та анотовано в OpenAPI.

Так само ви можете оголошувати будь-які інші параметри звичайним чином і додатково отримувати `Request`.

///

## Документація `Request` { #request-documentation }

Докладніше про <a href="https://www.starlette.dev/requests/" class="external-link" target="_blank">об'єкт `Request` на офіційному сайті документації Starlette</a>.

/// note | Технічні деталі

Ви також можете використати `from starlette.requests import Request`.

**FastAPI** надає його безпосередньо як зручність для вас, розробника. Але він походить безпосередньо із Starlette.

///
