# Тіло – Оновлення

## Оновлення з використанням `PUT`

Щоб оновити елемент, Ви можете використати <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT" class="external-link" target="_blank">HTTP `PUT`</a> операцію.

Ви можете використати `jsonable_encoder`, щоб перетворити вхідні дані на такі, які можна зберігати як JSON (наприклад, у NoSQL базі даних). Наприклад, перетворюючи `datetime` у `str`.

{* ../../docs_src/body_updates/tutorial001_py310.py hl[28:33] *}

`PUT` використовується для отримання даних, які мають замінити чинні дані.

### Попередження про заміну

Це означає, що якщо Ви хочете оновити елемент `bar`, використовуючи `PUT` з тілом:

```Python
{
    "name": "Barz",
    "price": 3,
    "description": None,
}
```

оскільки він не містить вже збереженого атрибута `"tax": 20.2`, модель введення прийме значення за замовчуванням `"tax": 10.5`.

І дані будуть збережені з цим "новим" значенням `tax` = `10.5`.

## Часткові оновлення з `PATCH`

Ви також можете використовувати операцію <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PATCH" class="external-link" target="_blank">HTTP `PATCH`</a> для *часткового* оновлення даних.

Це означає, що Ви можете надіслати лише ті дані, які хочете оновити, залишаючи інші без змін.

/// note | Примітка

`PATCH` менш відомий і рідше використовується, ніж `PUT`.

І багато команд використовують лише `PUT`, навіть для часткових оновлень.

Ви **вільні** використовувати їх так, як хочете, **FastAPI** не накладає обмежень.

Але цей посібник показує Вам більш-менш як їх задумано використовувати.

///

### Використання параметра `exclude_unset` у Pydantic

Якщо Ви хочете отримати часткові оновлення, дуже зручно використовувати параметр `exclude_unset` у методі `.model_dump()` моделі Pydantic.

Наприклад: `item.model_dump(exclude_unset=True)`.

/// info | Інформація

У Pydantic v1 цей метод називався `.dict()`, він був застарілий (але все ще підтримується) у Pydantic v2, і був перейменований у `.model_dump()`.

Приклади тут використовують `.dict()` для сумісності з Pydantic v1, але Вам слід використовувати `.model_dump()`, якщо можете використовувати Pydantic v2.

///

Це створить `dict` лише з тими даними, які були явно встановлені під час створення моделі `item`, виключаючи значення за замовчуванням.

Тоді Ви можете використовувати це, щоб створити `dict` лише з даними, які були встановлені (надіслані у запиті), пропускаючи значення за замовчуванням:

{* ../../docs_src/body_updates/tutorial002_py310.py hl[32] *}

### Використання параметра `update` у Pydantic

Тепер Ви можете створити копію наявної моделі за допомогою `.model_copy()`, і передати параметр `update` з `dict` , який містить дані для оновлення.

/// info | Інформація

У Pydantic v1 метод називався `.copy()`, він був застарілий (але все ще підтримується) у Pydantic v2, і був перейменований у `.model_copy()`.

Приклади тут використовують `.copy()` для сумісності з Pydantic v1, але якщо Ви можете використовувати Pydantic v2 — Вам слід використовувати `.model_copy()` замість цього.

///

Наприклад: `stored_item_model.model_copy(update=update_data)`:

{* ../../docs_src/body_updates/tutorial002_py310.py hl[33] *}

### Підсумок часткових оновлень

У підсумку, щоб застосувати часткові оновлення, Ви:

* (Опціонально) використовуєте `PATCH` замість `PUT`.
* Отримуєте збережені дані.
* Поміщаєте ці дані в модель Pydantic.
* Генеруєте `dict` без значень за замовчуванням з моделі введення (використовуючи `exclude_unset`).
    * Таким чином Ви оновите лише ті значення, які були явно задані користувачем, замість того, щоб перезаписувати вже збережені значення значеннями за замовчуванням з вашої моделі.
* Створюєте копію збереженої моделі, оновлюючи її атрибути отриманими частковими оновленнями (використовуючи параметр `update`).
* Перетворюєте скопійовану модель на щось, що можна зберегти у вашу БД (наприклад, використовуючи `jsonable_encoder`).
    * Це можна порівняти з повторним використанням методу `.model_dump()` моделі, але це гарантує (і перетворює) значення у типи даних, які можна перетворити на JSON, наприклад, `datetime` на `str`.
* Зберігаєте дані у вашу БД.
* Повертаєте оновлену модель.

{* ../../docs_src/body_updates/tutorial002_py310.py hl[28:35] *}

/// tip | Порада

Насправді Ви можете використовувати цю саму техніку і з операцією HTTP `PUT`.

Але приклад тут використовує `PATCH`, тому що він був створений саме для таких випадків.

///

/// note | Примітка

Зверніть увагу, що модель запиту все ще проходить валідацію.

Тож, якщо Ви хочете отримувати часткові оновлення, які можуть не містити жодного атрибута, Вам потрібно мати модель, де всі атрибути позначені як необов’язкові (зі значеннями за замовчуванням або `None`).

Щоб розрізняти моделі з усіма необов’язковими значеннями для **оновлення** і моделі з обов’язковими значеннями для **створення**, Ви можете скористатись ідеями, описаними у [Додаткові моделі](extra-models.md){.internal-link target=_blank}.

///
