// Generated by gmmproc 2.49.4 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtksourceviewmm/buffer.h>
#include <gtksourceviewmm/private/buffer_p.h>


/* buffer.cc
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 * Copyright (C) 2009, 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtksourceview/gtksource.h>

#include <glibmm/vectorutils.h>

namespace Gsv
{

Buffer::Buffer () :
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::TextBuffer(Glib::ConstructParams(buffer_class_.init(), "tag-table",0, nullptr))
{}

Buffer::Buffer (const Glib::RefPtr<Gtk::TextTagTable>& tag_table) :
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::TextBuffer(Glib::ConstructParams(buffer_class_.init(), "tag-table",Glib::unwrap(tag_table), nullptr))
{}

Buffer::Buffer (const Glib::RefPtr<Language> &language) :
    // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::TextBuffer(Glib::ConstructParams(buffer_class_.init(), "tag-table",0,"language",Glib::unwrap(language), nullptr))
{
}

bool Buffer::backward_iter_to_source_mark(Gtk::TextIter& iter)
{
    return gtk_source_buffer_backward_iter_to_source_mark(gobj(), iter.gobj(), 0);
}

bool Buffer::forward_iter_to_source_mark(Gtk::TextIter& iter)
{
    return gtk_source_buffer_forward_iter_to_source_mark(gobj(), iter.gobj(), 0);
}

Glib::RefPtr<Gsv::Mark>
Buffer::create_source_mark(const Glib::ustring& category, const Gtk::TextIter& where)
{
  return Glib::wrap(gtk_source_buffer_create_source_mark(gobj(), 0, category.c_str(), where.gobj()));
}

std::vector<Glib::RefPtr<Gsv::Mark> > Buffer::get_source_marks_at_line(int line) const
{
    return Glib::SListHandler<Glib::RefPtr<Gsv::Mark> >::slist_to_vector(gtk_source_buffer_get_source_marks_at_line(const_cast<GtkSourceBuffer*>(gobj()), line, 0), Glib::OWNERSHIP_SHALLOW);
}

std::vector<Glib::RefPtr<Gsv::Mark> > Buffer::get_source_marks_at_iter(Gtk::TextIter& iter) const
{
    return Glib::SListHandler<Glib::RefPtr<Gsv::Mark> >::slist_to_vector(gtk_source_buffer_get_source_marks_at_iter(const_cast<GtkSourceBuffer*>(gobj()), iter.gobj(), 0), Glib::OWNERSHIP_SHALLOW);
}

void
Buffer::remove_source_marks(const Gtk::TextIter& start, const Gtk::TextIter& end)
{
  gtk_source_buffer_remove_source_marks(gobj(), start.gobj(), end.gobj(), 0);
}

void
Buffer::unset_style_scheme()
{
  gtk_source_buffer_set_style_scheme(gobj(), 0);
}

void
Buffer::set_default_undo_manager()
{
  gtk_source_buffer_set_undo_manager(gobj(), 0);
}

}//end namespace Gsv


namespace
{


static void Buffer_signal_highlight_updated_callback(GtkSourceBuffer* self, GtkTextIter* p0,GtkTextIter* p1,void* data)
{
  using namespace Gsv;
  using SlotType = sigc::slot< void,Gtk::TextIter&,Gtk::TextIter& >;

  auto obj = dynamic_cast<Buffer*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Buffer_signal_highlight_updated_info =
{
  "highlight-updated",
  (GCallback) &Buffer_signal_highlight_updated_callback,
  (GCallback) &Buffer_signal_highlight_updated_callback
};


static void Buffer_signal_source_mark_updated_callback(GtkSourceBuffer* self, GtkTextMark* p0,void* data)
{
  using namespace Gsv;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gtk::TextMark>& >;

  auto obj = dynamic_cast<Buffer*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Buffer_signal_source_mark_updated_info =
{
  "source-mark-updated",
  (GCallback) &Buffer_signal_source_mark_updated_callback,
  (GCallback) &Buffer_signal_source_mark_updated_callback
};


static const Glib::SignalProxyInfo Buffer_signal_undo_info =
{
  "undo",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Buffer_signal_redo_info =
{
  "redo",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Buffer_signal_bracket_matched_callback(GtkSourceBuffer* self, GtkTextIter* p0,GtkSourceBracketMatchType p1,void* data)
{
  using namespace Gsv;
  using SlotType = sigc::slot< void,Gtk::TextIter&,BracketMatchType >;

  auto obj = dynamic_cast<Buffer*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, ((BracketMatchType)(p1))
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Buffer_signal_bracket_matched_info =
{
  "bracket-matched",
  (GCallback) &Buffer_signal_bracket_matched_callback,
  (GCallback) &Buffer_signal_bracket_matched_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gsv::BracketMatchType>::value_type()
{
  return gtk_source_bracket_match_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gsv::Buffer> wrap(GtkSourceBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gsv::Buffer>( dynamic_cast<Gsv::Buffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gsv
{


/* The *_Class implementation: */

const Glib::Class& Buffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Buffer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_source_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Buffer_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->undo = &undo_callback;
  klass->redo = &redo_callback;
  klass->bracket_matched = &bracket_matched_callback;
}


void Buffer_Class::undo_callback(GtkSourceBuffer* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_undo();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->undo)
    (*base->undo)(self);
}
void Buffer_Class::redo_callback(GtkSourceBuffer* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_redo();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->redo)
    (*base->redo)(self);
}
void Buffer_Class::bracket_matched_callback(GtkSourceBuffer* self, GtkTextIter* p0, GtkSourceBracketMatchType p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_bracket_matched(Glib::wrap(p0)
, ((BracketMatchType)(p1))
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->bracket_matched)
    (*base->bracket_matched)(self, p0, p1);
}


Glib::ObjectBase* Buffer_Class::wrap_new(GObject* object)
{
  return new Buffer((GtkSourceBuffer*)object);
}


/* The implementation: */

GtkSourceBuffer* Buffer::gobj_copy()
{
  reference();
  return gobj();
}

Buffer::Buffer(const Glib::ConstructParams& construct_params)
:
  Gtk::TextBuffer(construct_params)
{

}

Buffer::Buffer(GtkSourceBuffer* castitem)
:
  Gtk::TextBuffer((GtkTextBuffer*)(castitem))
{}


Buffer::Buffer(Buffer&& src) noexcept
: Gtk::TextBuffer(std::move(src))
{}

Buffer& Buffer::operator=(Buffer&& src) noexcept
{
  Gtk::TextBuffer::operator=(std::move(src));
  return *this;
}


Buffer::~Buffer() noexcept
{}


Buffer::CppClassType Buffer::buffer_class_; // initialize static member

GType Buffer::get_type()
{
  return buffer_class_.init().get_type();
}


GType Buffer::get_base_type()
{
  return gtk_source_buffer_get_type();
}


Glib::RefPtr<Buffer> Buffer::create()
{
  return Glib::RefPtr<Buffer>( new Buffer() );
}

Glib::RefPtr<Buffer> Buffer::create(const Glib::RefPtr<Gtk::TextTagTable>& tag_table)
{
  return Glib::RefPtr<Buffer>( new Buffer(tag_table) );
}

Glib::RefPtr<Buffer> Buffer::create(const Glib::RefPtr<Language>& language)
{
  return Glib::RefPtr<Buffer>( new Buffer(language) );
}

bool Buffer::get_highlight_matching_brackets() const
{
  return gtk_source_buffer_get_highlight_matching_brackets(const_cast<GtkSourceBuffer*>(gobj()));
}

void Buffer::set_highlight_matching_brackets(bool highlight)
{
  gtk_source_buffer_set_highlight_matching_brackets(gobj(), static_cast<int>(highlight));
}

bool Buffer::get_highlight_syntax() const
{
  return gtk_source_buffer_get_highlight_syntax(const_cast<GtkSourceBuffer*>(gobj()));
}

void Buffer::set_highlight_syntax(bool highlight)
{
  gtk_source_buffer_set_highlight_syntax(gobj(), static_cast<int>(highlight));
}

int Buffer::get_max_undo_levels() const
{
  return gtk_source_buffer_get_max_undo_levels(const_cast<GtkSourceBuffer*>(gobj()));
}

void Buffer::set_max_undo_levels(int max_undo_levels)
{
  gtk_source_buffer_set_max_undo_levels(gobj(), max_undo_levels);
}

Glib::RefPtr<Language> Buffer::get_language()
{
  Glib::RefPtr<Language> retvalue = Glib::wrap(gtk_source_buffer_get_language(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Language> Buffer::get_language() const
{
  return const_cast<Buffer*>(this)->get_language();
}

void Buffer::set_language(const Glib::RefPtr<Language>& language)
{
  gtk_source_buffer_set_language(gobj(), Glib::unwrap(language));
}

bool Buffer::can_undo() const
{
  return gtk_source_buffer_can_undo(const_cast<GtkSourceBuffer*>(gobj()));
}

bool Buffer::can_redo() const
{
  return gtk_source_buffer_can_redo(const_cast<GtkSourceBuffer*>(gobj()));
}

void Buffer::undo()
{
  gtk_source_buffer_undo(gobj());
}

void Buffer::redo()
{
  gtk_source_buffer_redo(gobj());
}

void Buffer::begin_not_undoable_action()
{
  gtk_source_buffer_begin_not_undoable_action(gobj());
}

void Buffer::end_not_undoable_action()
{
  gtk_source_buffer_end_not_undoable_action(gobj());
}

bool Buffer::backward_iter_to_source_mark(Gtk::TextIter& iter, const Glib::ustring& category)
{
  return gtk_source_buffer_backward_iter_to_source_mark(gobj(), (iter).gobj(), category.c_str());
}

bool Buffer::forward_iter_to_source_mark(Gtk::TextIter& iter, const Glib::ustring& category)
{
  return gtk_source_buffer_forward_iter_to_source_mark(gobj(), (iter).gobj(), category.c_str());
}

void Buffer::ensure_highlight(const Gtk::TextIter& start, const Gtk::TextIter& end)
{
  gtk_source_buffer_ensure_highlight(gobj(), (start).gobj(), (end).gobj());
}

Glib::RefPtr<StyleScheme> Buffer::get_style_scheme()
{
  Glib::RefPtr<StyleScheme> retvalue = Glib::wrap(gtk_source_buffer_get_style_scheme(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const StyleScheme> Buffer::get_style_scheme() const
{
  return const_cast<Buffer*>(this)->get_style_scheme();
}

void Buffer::set_style_scheme(const Glib::RefPtr<StyleScheme>& scheme)
{
  gtk_source_buffer_set_style_scheme(gobj(), Glib::unwrap(scheme));
}

Glib::RefPtr<Gsv::Mark> Buffer::create_source_mark(const Glib::ustring& name, const Glib::ustring& category, const Gtk::TextIter& where)
{
  Glib::RefPtr<Gsv::Mark> retvalue = Glib::wrap(gtk_source_buffer_create_source_mark(gobj(), name.c_str(), category.c_str(), (where).gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::vector<Glib::RefPtr<Gsv::Mark> > Buffer::get_source_marks_at_line(int line, const Glib::ustring& category) const
{
  return Glib::SListHandler<Glib::RefPtr<Gsv::Mark> >::slist_to_vector(gtk_source_buffer_get_source_marks_at_line(const_cast<GtkSourceBuffer*>(gobj()), line, category.c_str()), Glib::OWNERSHIP_SHALLOW);
}

std::vector<Glib::RefPtr<Gsv::Mark> > Buffer::get_source_marks_at_iter(Gtk::TextIter& iter, const Glib::ustring& category) const
{
  return Glib::SListHandler<Glib::RefPtr<Gsv::Mark> >::slist_to_vector(gtk_source_buffer_get_source_marks_at_iter(const_cast<GtkSourceBuffer*>(gobj()), (iter).gobj(), category.c_str()), Glib::OWNERSHIP_SHALLOW);
}

void Buffer::remove_source_marks(const Gtk::TextIter& start, const Gtk::TextIter& end, const Glib::ustring& category)
{
  gtk_source_buffer_remove_source_marks(gobj(), (start).gobj(), (end).gobj(), category.c_str());
}

bool Buffer::iter_has_context_class(const Gtk::TextIter& iter, const Glib::ustring& context_class) const
{
  return gtk_source_buffer_iter_has_context_class(const_cast<GtkSourceBuffer*>(gobj()), (iter).gobj(), context_class.c_str());
}

bool Buffer::iter_backward_to_context_class_toggle(Gtk::TextIter& iter, const Glib::ustring& context_class) const
{
  return gtk_source_buffer_iter_backward_to_context_class_toggle(const_cast<GtkSourceBuffer*>(gobj()), (iter).gobj(), context_class.c_str());
}

bool Buffer::iter_forward_to_context_class_toggle(Gtk::TextIter& iter, const Glib::ustring& context_class) const
{
  return gtk_source_buffer_iter_forward_to_context_class_toggle(const_cast<GtkSourceBuffer*>(gobj()), (iter).gobj(), context_class.c_str());
}

std::vector<Glib::ustring> Buffer::get_context_classes_at_iter(const Gtk::TextIter& iter) const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_source_buffer_get_context_classes_at_iter(const_cast<GtkSourceBuffer*>(gobj()), (iter).gobj()), Glib::OWNERSHIP_DEEP);
}

Glib::RefPtr<UndoManager> Buffer::get_undo_manager()
{
  Glib::RefPtr<UndoManager> retvalue = Glib::wrap(gtk_source_buffer_get_undo_manager(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const UndoManager> Buffer::get_undo_manager() const
{
  return const_cast<Buffer*>(this)->get_undo_manager();
}

void Buffer::set_undo_manager(const Glib::RefPtr<const UndoManager>& undo_manager)
{
  gtk_source_buffer_set_undo_manager(gobj(), const_cast<GtkSourceUndoManager*>(Glib::unwrap(undo_manager)));
}

void Buffer::set_implicit_trailing_newline(bool implicit_trailing_newline)
{
  gtk_source_buffer_set_implicit_trailing_newline(gobj(), static_cast<int>(implicit_trailing_newline));
}

bool Buffer::get_implicit_trailing_newline() const
{
  return gtk_source_buffer_get_implicit_trailing_newline(const_cast<GtkSourceBuffer*>(gobj()));
}


Glib::SignalProxy< void,Gtk::TextIter&,Gtk::TextIter& > Buffer::signal_highlight_updated()
{
  return Glib::SignalProxy< void,Gtk::TextIter&,Gtk::TextIter& >(this, &Buffer_signal_highlight_updated_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gtk::TextMark>& > Buffer::signal_source_mark_updated()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gtk::TextMark>& >(this, &Buffer_signal_source_mark_updated_info);
}


Glib::SignalProxy< void > Buffer::signal_undo()
{
  return Glib::SignalProxy< void >(this, &Buffer_signal_undo_info);
}


Glib::SignalProxy< void > Buffer::signal_redo()
{
  return Glib::SignalProxy< void >(this, &Buffer_signal_redo_info);
}


Glib::SignalProxy< void,Gtk::TextIter&,BracketMatchType > Buffer::signal_bracket_matched()
{
  return Glib::SignalProxy< void,Gtk::TextIter&,BracketMatchType >(this, &Buffer_signal_bracket_matched_info);
}


Glib::PropertyProxy< bool > Buffer::property_highlight_syntax() 
{
  return Glib::PropertyProxy< bool >(this, "highlight-syntax");
}

Glib::PropertyProxy_ReadOnly< bool > Buffer::property_highlight_syntax() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "highlight-syntax");
}

Glib::PropertyProxy< bool > Buffer::property_highlight_matching_brackets() 
{
  return Glib::PropertyProxy< bool >(this, "highlight-matching-brackets");
}

Glib::PropertyProxy_ReadOnly< bool > Buffer::property_highlight_matching_brackets() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "highlight-matching-brackets");
}

Glib::PropertyProxy< int > Buffer::property_max_undo_levels() 
{
  return Glib::PropertyProxy< int >(this, "max-undo-levels");
}

Glib::PropertyProxy_ReadOnly< int > Buffer::property_max_undo_levels() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "max-undo-levels");
}

Glib::PropertyProxy< Glib::RefPtr<Language> > Buffer::property_language() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Language> >(this, "language");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Language> > Buffer::property_language() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Language> >(this, "language");
}

Glib::PropertyProxy_ReadOnly< bool > Buffer::property_can_undo() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-undo");
}

Glib::PropertyProxy_ReadOnly< bool > Buffer::property_can_redo() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-redo");
}

Glib::PropertyProxy< Glib::RefPtr<StyleScheme> > Buffer::property_style_scheme() 
{
  return Glib::PropertyProxy< Glib::RefPtr<StyleScheme> >(this, "style-scheme");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<StyleScheme> > Buffer::property_style_scheme() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<StyleScheme> >(this, "style-scheme");
}

Glib::PropertyProxy< Glib::RefPtr<UndoManager> > Buffer::property_undo_manager() 
{
  return Glib::PropertyProxy< Glib::RefPtr<UndoManager> >(this, "undo-manager");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<UndoManager> > Buffer::property_undo_manager() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<UndoManager> >(this, "undo-manager");
}

Glib::PropertyProxy< bool > Buffer::property_implicit_trailing_newline() 
{
  return Glib::PropertyProxy< bool >(this, "implicit-trailing-newline");
}

Glib::PropertyProxy_ReadOnly< bool > Buffer::property_implicit_trailing_newline() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "implicit-trailing-newline");
}


void Gsv::Buffer::on_undo()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->undo)
    (*base->undo)(gobj());
}
void Gsv::Buffer::on_redo()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->redo)
    (*base->redo)(gobj());
}
void Gsv::Buffer::on_bracket_matched(Gtk::TextIter& iter, BracketMatchType state)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->bracket_matched)
    (*base->bracket_matched)(gobj(),(iter).gobj(),((GtkSourceBracketMatchType)(state)));
}


} // namespace Gsv


