! #############################################################################
! # Copyright (C) 2015 German Aerospace Center (DLR/SC)
! #
! # Created: 2015-09-16 Melven Roehrig-Zoellner <Melven.Roehrig-Zoellner@DLR.de>
! #
! # Licensed under the Apache License, Version 2.0 (the "License");
! # you may not use this file except in compliance with the License.
! # You may obtain a copy of the License at
! #
! #     http://www.apache.org/licenses/LICENSE-2.0
! #
! # Unless required by applicable law or agreed to in writing, software
! # distributed under the License is distributed on an "AS IS" BASIS,
! # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! # See the License for the specific language governing permissions and
! # limitations under the License.
! #############################################################################
! 
! # This file is automatically created from tixi.h on 2025-09-30.
! # If you experience any bugs please contact the authors
! 


module tixi
  use, intrinsic :: iso_c_binding, only: C_CHAR
  implicit none
  public


! enum ReturnCode
enum, bind(C)
  enumerator :: SUCCESS = 0
  enumerator :: FAILED = 1
  enumerator :: INVALID_XML_NAME = 2
  enumerator :: NOT_WELL_FORMED = 3
  enumerator :: NOT_SCHEMA_COMPLIANT = 4
  enumerator :: NOT_DTD_COMPLIANT = 5
  enumerator :: INVALID_HANDLE = 6
  enumerator :: INVALID_XPATH = 7
  enumerator :: ELEMENT_NOT_FOUND = 8
  enumerator :: INDEX_OUT_OF_RANGE = 9
  enumerator :: NO_POINT_FOUND = 10
  enumerator :: NOT_AN_ELEMENT = 11
  enumerator :: ATTRIBUTE_NOT_FOUND = 12
  enumerator :: OPEN_FAILED = 13
  enumerator :: OPEN_SCHEMA_FAILED = 14
  enumerator :: OPEN_DTD_FAILED = 15
  enumerator :: CLOSE_FAILED = 16
  enumerator :: ALREADY_SAVED = 17
  enumerator :: ELEMENT_PATH_NOT_UNIQUE = 18
  enumerator :: NO_ELEMENT_NAME = 19
  enumerator :: NO_CHILDREN = 20
  enumerator :: CHILD_NOT_FOUND = 21
  enumerator :: EROROR_CREATE_ROOT_NODE = 22
  enumerator :: DEALLOCATION_FAILED = 23
  enumerator :: NO_NUMBER = 24
  enumerator :: NO_ATTRIBUTE_NAME = 25
  enumerator :: STRING_TRUNCATED = 26
  enumerator :: NON_MATCHING_NAME = 27
  enumerator :: NON_MATCHING_SIZE = 28
  enumerator :: MATRIX_DIMENSION_ERROR = 29
  enumerator :: COORDINATE_NOT_FOUND = 30
  enumerator :: UNKNOWN_STORAGE_MODE = 31
  enumerator :: UID_NOT_UNIQUE = 32
  enumerator :: UID_DONT_EXISTS = 33
  enumerator :: UID_LINK_BROKEN = 34
  enumerator :: INVALID_NAMESPACE_URI = 35
  enumerator :: INVALID_NAMESPACE_PREFIX = 36
end enum

! enum StorageMode
enum, bind(C)
  enumerator :: ROW_WISE = 0
  enumerator :: COLUMN_WISE = 1
end enum

! enum OpenMode
enum, bind(C)
  enumerator :: OPENMODE_PLAIN = 0
  enumerator :: OPENMODE_RECURSIVE = 1
end enum

! enum AddLinkMode
enum, bind(C)
  enumerator :: ADDLINK_CREATE = 0
  enumerator :: ADDLINK_CREATE_AND_OPEN = 1
end enum

! enum MessageType
enum, bind(C)
  enumerator :: MESSAGETYPE_ERROR = 0
  enumerator :: MESSAGETYPE_WARNING = 1
  enumerator :: MESSAGETYPE_STATUS = 2
end enum




abstract interface
    subroutine TixiPrintMsgFnc(messageType, msg) bind(C)
        use, intrinsic :: iso_c_binding
        integer(kind=C_INT), value :: messageType
        character(kind=C_CHAR), intent(in) :: msg(*)
    end subroutine
end interface




interface
! char* tixiGetVersion();
  function tixiGetVersion_c() &
      result(ret) &
      bind(C,name='tixiGetVersion')
    use, intrinsic :: iso_c_binding
    type(C_PTR) :: ret
  end function tixiGetVersion_c


! ReturnCode tixiOpenDocument (const char *xmlFilename, TixiDocumentHandle * handle);
  function tixiOpenDocument_c(xmlFilename, &
        handle) &
      result(ret) &
      bind(C,name='tixiOpenDocument')
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR), intent(in) :: xmlFilename(*)
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret
  end function tixiOpenDocument_c


! ReturnCode tixiOpenDocumentRecursive (const char *xmlFilename, TixiDocumentHandle * handle, OpenMode oMode);
  function tixiOpenDocumentRecursive_c(xmlFilename, &
        handle, &
        oMode) &
      result(ret) &
      bind(C,name='tixiOpenDocumentRecursive')
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR), intent(in) :: xmlFilename(*)
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT), value :: oMode
    integer(kind=C_INT) :: ret
  end function tixiOpenDocumentRecursive_c


! ReturnCode tixiOpenDocumentFromHTTP (const char *httpURL, TixiDocumentHandle * handle);
  function tixiOpenDocumentFromHTTP_c(httpURL, &
        handle) &
      result(ret) &
      bind(C,name='tixiOpenDocumentFromHTTP')
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR), intent(in) :: httpURL(*)
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret
  end function tixiOpenDocumentFromHTTP_c


! ReturnCode tixiCreateDocument (const char *rootElementName, TixiDocumentHandle * handle);
  function tixiCreateDocument_c(rootElementName, &
        handle) &
      result(ret) &
      bind(C,name='tixiCreateDocument')
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR), intent(in) :: rootElementName(*)
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret
  end function tixiCreateDocument_c


! ReturnCode tixiGetDocumentPath (TixiDocumentHandle handle, char** documentPath);
  function tixiGetDocumentPath_c(handle, &
        documentPath) &
      result(ret) &
      bind(C,name='tixiGetDocumentPath')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    type(C_PTR), intent(inout) :: documentPath
    integer(kind=C_INT) :: ret
  end function tixiGetDocumentPath_c


! ReturnCode tixiSaveDocument (TixiDocumentHandle handle, const char *xmlFilename);
  function tixiSaveDocument_c(handle, &
        xmlFilename) &
      result(ret) &
      bind(C,name='tixiSaveDocument')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xmlFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiSaveDocument_c


! ReturnCode tixiSaveCompleteDocument (TixiDocumentHandle handle, const char *xmlFilename);
  function tixiSaveCompleteDocument_c(handle, &
        xmlFilename) &
      result(ret) &
      bind(C,name='tixiSaveCompleteDocument')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xmlFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiSaveCompleteDocument_c


! ReturnCode tixiSaveAndRemoveDocument (TixiDocumentHandle handle, const char *xmlFilename);
  function tixiSaveAndRemoveDocument_c(handle, &
        xmlFilename) &
      result(ret) &
      bind(C,name='tixiSaveAndRemoveDocument')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xmlFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiSaveAndRemoveDocument_c


! ReturnCode tixiCloseDocument (TixiDocumentHandle handle);
  function tixiCloseDocument(handle) &
      result(ret) &
      bind(C,name='tixiCloseDocument')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT) :: ret
  end function tixiCloseDocument


! ReturnCode tixiCloseAllDocuments ();
  function tixiCloseAllDocuments() &
      result(ret) &
      bind(C,name='tixiCloseAllDocuments')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT) :: ret
  end function tixiCloseAllDocuments


! ReturnCode tixiCleanup ();
  function tixiCleanup() &
      result(ret) &
      bind(C,name='tixiCleanup')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT) :: ret
  end function tixiCleanup


! ReturnCode tixiExportDocumentAsString (const TixiDocumentHandle handle, char **text);
  function tixiExportDocumentAsString_c(handle, &
        text) &
      result(ret) &
      bind(C,name='tixiExportDocumentAsString')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    type(C_PTR), intent(inout) :: text
    integer(kind=C_INT) :: ret
  end function tixiExportDocumentAsString_c


! ReturnCode tixiImportFromString (const char *xmlImportString, TixiDocumentHandle * handle);
  function tixiImportFromString_c(xmlImportString, &
        handle) &
      result(ret) &
      bind(C,name='tixiImportFromString')
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR), intent(in) :: xmlImportString(*)
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret
  end function tixiImportFromString_c


! ReturnCode tixiSchemaValidateFromFile (const TixiDocumentHandle handle, const char *xsdFilename);
  function tixiSchemaValidateFromFile_c(handle, &
        xsdFilename) &
      result(ret) &
      bind(C,name='tixiSchemaValidateFromFile')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xsdFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiSchemaValidateFromFile_c


! ReturnCode tixiSchemaValidateWithDefaultsFromFile (const TixiDocumentHandle handle, const char *xsdFilename);
  function tixiSchemaValidateWithDefaultsFromFile_c(handle, &
        xsdFilename) &
      result(ret) &
      bind(C,name='tixiSchemaValidateWithDefaultsFromFile')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xsdFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiSchemaValidateWithDefaultsFromFile_c


! ReturnCode tixiSchemaValidateFromString (const TixiDocumentHandle handle, const char *xsdString);
  function tixiSchemaValidateFromString_c(handle, &
        xsdString) &
      result(ret) &
      bind(C,name='tixiSchemaValidateFromString')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xsdString(*)
    integer(kind=C_INT) :: ret
  end function tixiSchemaValidateFromString_c


! ReturnCode tixiDTDValidate (const TixiDocumentHandle handle, const char *DTDFilename);
  function tixiDTDValidate_c(handle, &
        DTDFilename) &
      result(ret) &
      bind(C,name='tixiDTDValidate')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: DTDFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiDTDValidate_c


! ReturnCode tixiGetTextElement (const TixiDocumentHandle handle, const char *elementPath, char **text);
  function tixiGetTextElement_c(handle, &
        elementPath, &
        text) &
      result(ret) &
      bind(C,name='tixiGetTextElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    type(C_PTR), intent(inout) :: text
    integer(kind=C_INT) :: ret
  end function tixiGetTextElement_c


! ReturnCode tixiGetIntegerElement (const TixiDocumentHandle handle, const char *elementPath, int *number);
  function tixiGetIntegerElement_c(handle, &
        elementPath, &
        number) &
      result(ret) &
      bind(C,name='tixiGetIntegerElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), intent(out) :: number
    integer(kind=C_INT) :: ret
  end function tixiGetIntegerElement_c


! ReturnCode tixiGetDoubleElement (const TixiDocumentHandle handle, const char *elementPath, double *number);
  function tixiGetDoubleElement_c(handle, &
        elementPath, &
        number) &
      result(ret) &
      bind(C,name='tixiGetDoubleElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    real(kind=C_DOUBLE), intent(out) :: number
    integer(kind=C_INT) :: ret
  end function tixiGetDoubleElement_c


! ReturnCode tixiGetBooleanElement (const TixiDocumentHandle handle, const char *elementPath, int *boolean);
  function tixiGetBooleanElement_c(handle, &
        elementPath, &
        boolean) &
      result(ret) &
      bind(C,name='tixiGetBooleanElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), intent(out) :: boolean
    integer(kind=C_INT) :: ret
  end function tixiGetBooleanElement_c


! ReturnCode tixiUpdateTextElement (const TixiDocumentHandle handle, const char *elementPath, const char *text);
  function tixiUpdateTextElement_c(handle, &
        elementPath, &
        text) &
      result(ret) &
      bind(C,name='tixiUpdateTextElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: text(*)
    integer(kind=C_INT) :: ret
  end function tixiUpdateTextElement_c


! ReturnCode tixiUpdateDoubleElement (const TixiDocumentHandle handle, const char *elementPath, double number, const char *format);
  function tixiUpdateDoubleElement_c(handle, &
        elementPath, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiUpdateDoubleElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    real(kind=C_DOUBLE), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiUpdateDoubleElement_c


! ReturnCode tixiUpdateIntegerElement (const TixiDocumentHandle handle, const char *elementPath, int number, const char *format);
  function tixiUpdateIntegerElement_c(handle, &
        elementPath, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiUpdateIntegerElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiUpdateIntegerElement_c


! ReturnCode tixiUpdateBooleanElement (const TixiDocumentHandle handle, const char *elementPath, int boolean);
  function tixiUpdateBooleanElement_c(handle, &
        elementPath, &
        boolean) &
      result(ret) &
      bind(C,name='tixiUpdateBooleanElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), value :: boolean
    integer(kind=C_INT) :: ret
  end function tixiUpdateBooleanElement_c


! ReturnCode tixiAddTextElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, const char *text);
  function tixiAddTextElement_c(handle, &
        parentPath, &
        elementName, &
        text) &
      result(ret) &
      bind(C,name='tixiAddTextElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    character(kind=C_CHAR), intent(in) :: text(*)
    integer(kind=C_INT) :: ret
  end function tixiAddTextElement_c


! ReturnCode tixiAddTextElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char *namespaceURI, const char *text);
  function tixiAddTextElementNS_c(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        text) &
      result(ret) &
      bind(C,name='tixiAddTextElementNS')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    character(kind=C_CHAR), intent(in) :: text(*)
    integer(kind=C_INT) :: ret
  end function tixiAddTextElementNS_c


! ReturnCode tixiAddTextElementAtIndex (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, const char *text, int index);
  function tixiAddTextElementAtIndex_c(handle, &
        parentPath, &
        elementName, &
        text, &
        index) &
      result(ret) &
      bind(C,name='tixiAddTextElementAtIndex')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    character(kind=C_CHAR), intent(in) :: text(*)
    integer(kind=C_INT), value :: index
    integer(kind=C_INT) :: ret
  end function tixiAddTextElementAtIndex_c


! ReturnCode tixiAddTextElementNSAtIndex(const TixiDocumentHandle handle, const char *parentPath, const char* qualifiedName, const char* namespaceURI, const char *text, int index);
  function tixiAddTextElementNSAtIndex_c(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        text, &
        index) &
      result(ret) &
      bind(C,name='tixiAddTextElementNSAtIndex')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    character(kind=C_CHAR), intent(in) :: text(*)
    integer(kind=C_INT), value :: index
    integer(kind=C_INT) :: ret
  end function tixiAddTextElementNSAtIndex_c


! ReturnCode tixiAddBooleanElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, int boolean);
  function tixiAddBooleanElement_c(handle, &
        parentPath, &
        elementName, &
        boolean) &
      result(ret) &
      bind(C,name='tixiAddBooleanElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT), value :: boolean
    integer(kind=C_INT) :: ret
  end function tixiAddBooleanElement_c


! ReturnCode tixiAddBooleanElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char* namespaceURI, int boolean);
  function tixiAddBooleanElementNS_c(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        boolean) &
      result(ret) &
      bind(C,name='tixiAddBooleanElementNS')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    integer(kind=C_INT), value :: boolean
    integer(kind=C_INT) :: ret
  end function tixiAddBooleanElementNS_c


! ReturnCode tixiAddDoubleElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, double number, const char *format);
  function tixiAddDoubleElement_c(handle, &
        parentPath, &
        elementName, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiAddDoubleElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    real(kind=C_DOUBLE), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddDoubleElement_c


! ReturnCode tixiAddDoubleElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char* namespaceURI, double number, const char *format);
  function tixiAddDoubleElementNS_c(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiAddDoubleElementNS')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    real(kind=C_DOUBLE), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddDoubleElementNS_c


! ReturnCode tixiAddIntegerElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, int number, const char *format);
  function tixiAddIntegerElement_c(handle, &
        parentPath, &
        elementName, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiAddIntegerElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddIntegerElement_c


! ReturnCode tixiAddIntegerElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char *namespaceURI, int number, const char *format);
  function tixiAddIntegerElementNS_c(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiAddIntegerElementNS')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    integer(kind=C_INT), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddIntegerElementNS_c


! ReturnCode tixiAddFloatVector (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, const double *vector, const int numElements, const char* format);
! #annotate in: 3A(4)#
  function tixiAddFloatVector_c(handle, &
        parentPath, &
        elementName, &
        vector, &
        numElements, &
        format) &
      result(ret) &
      bind(C,name='tixiAddFloatVector')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT), value :: numElements
    character(kind=C_CHAR), intent(in) :: format(*)
    real(kind=C_DOUBLE), intent(in) :: vector(numElements)
    integer(kind=C_INT) :: ret
  end function tixiAddFloatVector_c


! ReturnCode tixiUpdateFloatVector (const TixiDocumentHandle handle, const char *path, const double *vector, const int numElements, const char* format);
! #annotate in: 2A(3)#
  function tixiUpdateFloatVector_c(handle, &
        path, &
        vector, &
        numElements, &
        format) &
      result(ret) &
      bind(C,name='tixiUpdateFloatVector')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: path(*)
    integer(kind=C_INT), value :: numElements
    character(kind=C_CHAR), intent(in) :: format(*)
    real(kind=C_DOUBLE), intent(in) :: vector(numElements)
    integer(kind=C_INT) :: ret
  end function tixiUpdateFloatVector_c


! ReturnCode tixiCreateElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName);
  function tixiCreateElement_c(handle, &
        parentPath, &
        elementName) &
      result(ret) &
      bind(C,name='tixiCreateElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT) :: ret
  end function tixiCreateElement_c


! ReturnCode tixiCreateElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char* namespaceURI);
  function tixiCreateElementNS_c(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI) &
      result(ret) &
      bind(C,name='tixiCreateElementNS')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    integer(kind=C_INT) :: ret
  end function tixiCreateElementNS_c


! ReturnCode tixiCreateElementAtIndex (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, int index);
  function tixiCreateElementAtIndex_c(handle, &
        parentPath, &
        elementName, &
        index) &
      result(ret) &
      bind(C,name='tixiCreateElementAtIndex')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT), value :: index
    integer(kind=C_INT) :: ret
  end function tixiCreateElementAtIndex_c


! ReturnCode tixiCreateElementNSAtIndex (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, int index, const char* namespaceURI);
  function tixiCreateElementNSAtIndex_c(handle, &
        parentPath, &
        qualifiedName, &
        index, &
        namespaceURI) &
      result(ret) &
      bind(C,name='tixiCreateElementNSAtIndex')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: qualifiedName(*)
    integer(kind=C_INT), value :: index
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    integer(kind=C_INT) :: ret
  end function tixiCreateElementNSAtIndex_c


! ReturnCode tixiRenameElement(const TixiDocumentHandle handle, const char* parentPath, const char* oldName, const char* newName);
  function tixiRenameElement_c(handle, &
        parentPath, &
        oldName, &
        newName) &
      result(ret) &
      bind(C,name='tixiRenameElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: oldName(*)
    character(kind=C_CHAR), intent(in) :: newName(*)
    integer(kind=C_INT) :: ret
  end function tixiRenameElement_c


! ReturnCode tixiRemoveElement (const TixiDocumentHandle handle, const char *elementPath);
  function tixiRemoveElement_c(handle, &
        elementPath) &
      result(ret) &
      bind(C,name='tixiRemoveElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT) :: ret
  end function tixiRemoveElement_c


! ReturnCode tixiGetNodeType (const TixiDocumentHandle handle, const char *nodePath, char **nodeType);
  function tixiGetNodeType_c(handle, &
        nodePath, &
        nodeType) &
      result(ret) &
      bind(C,name='tixiGetNodeType')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: nodePath(*)
    type(C_PTR), intent(inout) :: nodeType
    integer(kind=C_INT) :: ret
  end function tixiGetNodeType_c


! ReturnCode tixiGetNamedChildrenCount (const TixiDocumentHandle handle, const char *elementPath, const char *childName, int *count);
  function tixiGetNamedChildrenCount_c(handle, &
        elementPath, &
        childName, &
        count) &
      result(ret) &
      bind(C,name='tixiGetNamedChildrenCount')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: childName(*)
    integer(kind=C_INT), intent(out) :: count
    integer(kind=C_INT) :: ret
  end function tixiGetNamedChildrenCount_c


! ReturnCode tixiGetChildNodeName (const TixiDocumentHandle handle, const char *parentElementPath, int index, char **name);
  function tixiGetChildNodeName_c(handle, &
        parentElementPath, &
        index, &
        name) &
      result(ret) &
      bind(C,name='tixiGetChildNodeName')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentElementPath(*)
    integer(kind=C_INT), value :: index
    type(C_PTR), intent(inout) :: name
    integer(kind=C_INT) :: ret
  end function tixiGetChildNodeName_c


! ReturnCode tixiGetNumberOfChilds(const TixiDocumentHandle handle, const char *elementPath, int* nChilds);
  function tixiGetNumberOfChilds_c(handle, &
        elementPath, &
        nChilds) &
      result(ret) &
      bind(C,name='tixiGetNumberOfChilds')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), intent(out) :: nChilds
    integer(kind=C_INT) :: ret
  end function tixiGetNumberOfChilds_c


! ReturnCode tixiSwapElements(const TixiDocumentHandle handle, const char* element1Path, const char* element2Path);
  function tixiSwapElements_c(handle, &
        element1Path, &
        element2Path) &
      result(ret) &
      bind(C,name='tixiSwapElements')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: element1Path(*)
    character(kind=C_CHAR), intent(in) :: element2Path(*)
    integer(kind=C_INT) :: ret
  end function tixiSwapElements_c


! ReturnCode tixiExportElementAsString (const TixiDocumentHandle handle, const char* elementPath, char **text);
  function tixiExportElementAsString_c(handle, &
        elementPath, &
        text) &
      result(ret) &
      bind(C,name='tixiExportElementAsString')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    type(C_PTR), intent(inout) :: text
    integer(kind=C_INT) :: ret
  end function tixiExportElementAsString_c


! ReturnCode tixiImportElementFromString (const TixiDocumentHandle handle, const char *parentPath, const char *xmlImportString);
  function tixiImportElementFromString_c(handle, &
        parentPath, &
        xmlImportString) &
      result(ret) &
      bind(C,name='tixiImportElementFromString')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: xmlImportString(*)
    integer(kind=C_INT) :: ret
  end function tixiImportElementFromString_c


! ReturnCode tixiGetTextAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, char **text);
  function tixiGetTextAttribute_c(handle, &
        elementPath, &
        attributeName, &
        text) &
      result(ret) &
      bind(C,name='tixiGetTextAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    type(C_PTR), intent(inout) :: text
    integer(kind=C_INT) :: ret
  end function tixiGetTextAttribute_c


! ReturnCode tixiGetIntegerAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, int *number);
  function tixiGetIntegerAttribute_c(handle, &
        elementPath, &
        attributeName, &
        number) &
      result(ret) &
      bind(C,name='tixiGetIntegerAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    integer(kind=C_INT), intent(out) :: number
    integer(kind=C_INT) :: ret
  end function tixiGetIntegerAttribute_c


! ReturnCode tixiGetBooleanAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, int *boolean);
  function tixiGetBooleanAttribute_c(handle, &
        elementPath, &
        attributeName, &
        boolean) &
      result(ret) &
      bind(C,name='tixiGetBooleanAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    integer(kind=C_INT), intent(out) :: boolean
    integer(kind=C_INT) :: ret
  end function tixiGetBooleanAttribute_c


! ReturnCode tixiGetDoubleAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, double *number);
  function tixiGetDoubleAttribute_c(handle, &
        elementPath, &
        attributeName, &
        number) &
      result(ret) &
      bind(C,name='tixiGetDoubleAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    real(kind=C_DOUBLE), intent(out) :: number
    integer(kind=C_INT) :: ret
  end function tixiGetDoubleAttribute_c


! ReturnCode tixiAddTextAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, const char *attributeValue);
  function tixiAddTextAttribute_c(handle, &
        elementPath, &
        attributeName, &
        attributeValue) &
      result(ret) &
      bind(C,name='tixiAddTextAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    character(kind=C_CHAR), intent(in) :: attributeValue(*)
    integer(kind=C_INT) :: ret
  end function tixiAddTextAttribute_c


! ReturnCode tixiAddDoubleAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, double number, const char *format);
  function tixiAddDoubleAttribute_c(handle, &
        elementPath, &
        attributeName, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiAddDoubleAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    real(kind=C_DOUBLE), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddDoubleAttribute_c


! ReturnCode tixiAddIntegerAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, int number, const char *format);
  function tixiAddIntegerAttribute_c(handle, &
        elementPath, &
        attributeName, &
        number, &
        format) &
      result(ret) &
      bind(C,name='tixiAddIntegerAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    integer(kind=C_INT), value :: number
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddIntegerAttribute_c


! ReturnCode tixiRemoveAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName);
  function tixiRemoveAttribute_c(handle, &
        elementPath, &
        attributeName) &
      result(ret) &
      bind(C,name='tixiRemoveAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    integer(kind=C_INT) :: ret
  end function tixiRemoveAttribute_c


! ReturnCode tixiGetNumberOfAttributes(const TixiDocumentHandle handle, const char *elementPath, int* nAttributes);
  function tixiGetNumberOfAttributes_c(handle, &
        elementPath, &
        nAttributes) &
      result(ret) &
      bind(C,name='tixiGetNumberOfAttributes')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), intent(out) :: nAttributes
    integer(kind=C_INT) :: ret
  end function tixiGetNumberOfAttributes_c


! ReturnCode tixiGetAttributeName(const TixiDocumentHandle handle, const char *elementPath, int attrIndex, char** attrName);
  function tixiGetAttributeName_c(handle, &
        elementPath, &
        attrIndex, &
        attrName) &
      result(ret) &
      bind(C,name='tixiGetAttributeName')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT), value :: attrIndex
    type(C_PTR), intent(inout) :: attrName
    integer(kind=C_INT) :: ret
  end function tixiGetAttributeName_c


! ReturnCode tixiRegisterNamespace(const TixiDocumentHandle handle, const char* namespaceURI, const char* prefix);
  function tixiRegisterNamespace_c(handle, &
        namespaceURI, &
        prefix) &
      result(ret) &
      bind(C,name='tixiRegisterNamespace')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    character(kind=C_CHAR), intent(in) :: prefix(*)
    integer(kind=C_INT) :: ret
  end function tixiRegisterNamespace_c


! ReturnCode tixiRegisterNamespacesFromDocument(const TixiDocumentHandle handle);
  function tixiRegisterNamespacesFromDocument(handle) &
      result(ret) &
      bind(C,name='tixiRegisterNamespacesFromDocument')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT) :: ret
  end function tixiRegisterNamespacesFromDocument


! ReturnCode tixiSetElementNamespace(const TixiDocumentHandle handle, const char* elementPath, const char* namespaceURI, const char* prefix);
  function tixiSetElementNamespace_c(handle, &
        elementPath, &
        namespaceURI, &
        prefix) &
      result(ret) &
      bind(C,name='tixiSetElementNamespace')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    character(kind=C_CHAR), intent(in) :: prefix(*)
    integer(kind=C_INT) :: ret
  end function tixiSetElementNamespace_c


! ReturnCode tixiDeclareNamespace(const TixiDocumentHandle handle, const char* elementPath, const char* namespaceURI, const char* prefix);
  function tixiDeclareNamespace_c(handle, &
        elementPath, &
        namespaceURI, &
        prefix) &
      result(ret) &
      bind(C,name='tixiDeclareNamespace')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: namespaceURI(*)
    character(kind=C_CHAR), intent(in) :: prefix(*)
    integer(kind=C_INT) :: ret
  end function tixiDeclareNamespace_c


! ReturnCode tixiAddExternalLink (const TixiDocumentHandle handle, const char *parentPath, const char *pathOrUrl, const char *filename, AddLinkMode mode);
  function tixiAddExternalLink_c(handle, &
        parentPath, &
        pathOrUrl, &
        filename, &
        mode) &
      result(ret) &
      bind(C,name='tixiAddExternalLink')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: pathOrUrl(*)
    character(kind=C_CHAR), intent(in) :: filename(*)
    integer(kind=C_INT), value :: mode
    integer(kind=C_INT) :: ret
  end function tixiAddExternalLink_c


! ReturnCode tixiRemoveExternalLinks(TixiDocumentHandle handle);
  function tixiRemoveExternalLinks(handle) &
      result(ret) &
      bind(C,name='tixiRemoveExternalLinks')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT) :: ret
  end function tixiRemoveExternalLinks


! ReturnCode tixiAddHeader (const TixiDocumentHandle handle, const char *toolName, const char *version, const char *authorName);
  function tixiAddHeader_c(handle, &
        toolName, &
        version, &
        authorName) &
      result(ret) &
      bind(C,name='tixiAddHeader')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: toolName(*)
    character(kind=C_CHAR), intent(in) :: version(*)
    character(kind=C_CHAR), intent(in) :: authorName(*)
    integer(kind=C_INT) :: ret
  end function tixiAddHeader_c


! ReturnCode tixiAddCpacsHeader (const TixiDocumentHandle handle, const char *name, const char *creator, const char *version, const char *description, const char * cpacsVersion);
  function tixiAddCpacsHeader_c(handle, &
        name, &
        creator, &
        version, &
        description, &
        cpacsVersion) &
      result(ret) &
      bind(C,name='tixiAddCpacsHeader')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: name(*)
    character(kind=C_CHAR), intent(in) :: creator(*)
    character(kind=C_CHAR), intent(in) :: version(*)
    character(kind=C_CHAR), intent(in) :: description(*)
    character(kind=C_CHAR), intent(in) :: cpacsVersion(*)
    integer(kind=C_INT) :: ret
  end function tixiAddCpacsHeader_c


! ReturnCode tixiCheckElement (const TixiDocumentHandle handle, const char *elementPath);
  function tixiCheckElement_c(handle, &
        elementPath) &
      result(ret) &
      bind(C,name='tixiCheckElement')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    integer(kind=C_INT) :: ret
  end function tixiCheckElement_c


! ReturnCode tixiCheckDocumentHandle (const TixiDocumentHandle handle);
  function tixiCheckDocumentHandle(handle) &
      result(ret) &
      bind(C,name='tixiCheckDocumentHandle')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT) :: ret
  end function tixiCheckDocumentHandle


! ReturnCode tixiUsePrettyPrint(TixiDocumentHandle handle, int usePrettyPrint);
  function tixiUsePrettyPrint(handle, &
        usePrettyPrint) &
      result(ret) &
      bind(C,name='tixiUsePrettyPrint')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT), value :: usePrettyPrint
    integer(kind=C_INT) :: ret
  end function tixiUsePrettyPrint


! ReturnCode tixiSetPrintMsgFunc(TixiPrintMsgFnc func);
  function tixiSetPrintMsgFunc_c(func) &
      result(ret) &
      bind(C,name='tixiSetPrintMsgFunc')
    use, intrinsic :: iso_c_binding
    type(C_PTR), intent(out) :: func
    integer(kind=C_INT) :: ret
  end function tixiSetPrintMsgFunc_c


! TixiPrintMsgFnc tixiGetPrintMsgFunc();
  function tixiGetPrintMsgFunc_c() &
      result(ret) &
      bind(C,name='tixiGetPrintMsgFunc')
    use, intrinsic :: iso_c_binding
    type(C_PTR) :: ret
  end function tixiGetPrintMsgFunc_c


! ReturnCode tixiSetCacheEnabled(TixiDocumentHandle handle, int enabled);
  function tixiSetCacheEnabled(handle, &
        enabled) &
      result(ret) &
      bind(C,name='tixiSetCacheEnabled')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT), value :: enabled
    integer(kind=C_INT) :: ret
  end function tixiSetCacheEnabled


! ReturnCode tixiAddDoubleListWithAttributes (const TixiDocumentHandle handle, const char *parentPath, const char *listName, const char *childName, const char *childAttributeName, const double *values, const char *format, const char **attributes, int nValues);
  function tixiAddDoubleListWithAttributes_c(handle, &
        parentPath, &
        listName, &
        childName, &
        childAttributeName, &
        values, &
        format, &
        attributes, &
        nValues) &
      result(ret) &
      bind(C,name='tixiAddDoubleListWithAttributes')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: parentPath(*)
    character(kind=C_CHAR), intent(in) :: listName(*)
    character(kind=C_CHAR), intent(in) :: childName(*)
    character(kind=C_CHAR), intent(in) :: childAttributeName(*)
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT), value :: nValues
    real(kind=C_DOUBLE), intent(in) :: values(*)
    type(C_PTR), value :: attributes
    integer(kind=C_INT) :: ret
  end function tixiAddDoubleListWithAttributes_c


! ReturnCode tixiGetVectorSize (const TixiDocumentHandle handle, const char *vectorPath, int *nElements);
  function tixiGetVectorSize_c(handle, &
        vectorPath, &
        nElements) &
      result(ret) &
      bind(C,name='tixiGetVectorSize')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: vectorPath(*)
    integer(kind=C_INT), intent(out) :: nElements
    integer(kind=C_INT) :: ret
  end function tixiGetVectorSize_c


! ReturnCode tixiGetFloatVector (const TixiDocumentHandle handle, const char *vectorPath, double **vectorArray, const int eNumber);
! #annotate out: 2A(3) #
  function tixiGetFloatVector_c(handle, &
        vectorPath, &
        vectorArray, &
        eNumber) &
      result(ret) &
      bind(C,name='tixiGetFloatVector')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: vectorPath(*)
    integer(kind=C_INT), value :: eNumber
    type(C_PTR), intent(out) :: vectorArray
    integer(kind=C_INT) :: ret
  end function tixiGetFloatVector_c


! ReturnCode tixiGetArrayDimensions (const TixiDocumentHandle handle, const char *arrayPath, int *dimensions);
  function tixiGetArrayDimensions_c(handle, &
        arrayPath, &
        dimensions) &
      result(ret) &
      bind(C,name='tixiGetArrayDimensions')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    integer(kind=C_INT), intent(out) :: dimensions
    integer(kind=C_INT) :: ret
  end function tixiGetArrayDimensions_c


! ReturnCode tixiGetArrayDimensionSizes (const TixiDocumentHandle handle, const char *arrayPath, int *sizes, int *linearArraySize);
! #annotate out: 2AM#
  function tixiGetArrayDimensionSizes_c(handle, &
        arrayPath, &
        sizes, &
        linearArraySize) &
      result(ret) &
      bind(C,name='tixiGetArrayDimensionSizes')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    integer(kind=C_INT), intent(out) :: linearArraySize
    integer(kind=C_INT), intent(out) :: sizes(*)
    integer(kind=C_INT) :: ret
  end function tixiGetArrayDimensionSizes_c


! ReturnCode tixiGetArrayDimensionNames (const TixiDocumentHandle handle, const char *arrayPath, char **dimensionNames);
! #annotate out: 2AM#
  function tixiGetArrayDimensionNames_c(handle, &
        arrayPath, &
        dimensionNames) &
      result(ret) &
      bind(C,name='tixiGetArrayDimensionNames')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    type(C_PTR), intent(out) :: dimensionNames(*)
    integer(kind=C_INT) :: ret
  end function tixiGetArrayDimensionNames_c


! ReturnCode tixiGetArrayDimensionValues (const TixiDocumentHandle handle, const char *arrayPath, const int dimension, double *dimensionValues);
! #annotate out: 3AM#
  function tixiGetArrayDimensionValues_c(handle, &
        arrayPath, &
        dimension, &
        dimensionValues) &
      result(ret) &
      bind(C,name='tixiGetArrayDimensionValues')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    integer(kind=C_INT), value :: dimension
    real(kind=C_DOUBLE), intent(out) :: dimensionValues(*)
    integer(kind=C_INT) :: ret
  end function tixiGetArrayDimensionValues_c


! ReturnCode tixiGetArrayParameters (const TixiDocumentHandle handle, const char *arrayPath, int *parameters);
  function tixiGetArrayParameters_c(handle, &
        arrayPath, &
        parameters) &
      result(ret) &
      bind(C,name='tixiGetArrayParameters')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    integer(kind=C_INT), intent(out) :: parameters
    integer(kind=C_INT) :: ret
  end function tixiGetArrayParameters_c


! ReturnCode tixiGetArrayParameterNames (const TixiDocumentHandle handle, const char *arrayPath, char **parameterNames);
! #annotate out: 2AM#
  function tixiGetArrayParameterNames_c(handle, &
        arrayPath, &
        parameterNames) &
      result(ret) &
      bind(C,name='tixiGetArrayParameterNames')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    type(C_PTR), intent(out) :: parameterNames(*)
    integer(kind=C_INT) :: ret
  end function tixiGetArrayParameterNames_c


! ReturnCode tixiGetArray (const TixiDocumentHandle handle, const char *arrayPath, const char *elementName, int arraySize, double **values);
! #annotate out: 4A(3) #
  function tixiGetArray_c(handle, &
        arrayPath, &
        elementName, &
        arraySize, &
        values) &
      result(ret) &
      bind(C,name='tixiGetArray')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT), value :: arraySize
    type(C_PTR), intent(out) :: values
    integer(kind=C_INT) :: ret
  end function tixiGetArray_c


! double tixiGetArrayValue(const double *array, const int *dimSize, const int *dimPos, const int dims);
  function tixiGetArrayValue(array, &
        dimSize, &
        dimPos, &
        dims) &
      result(ret) &
      bind(C,name='tixiGetArrayValue')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: dims
    real(kind=C_DOUBLE), intent(in) :: array(*)
    integer(kind=C_INT), intent(in) :: dimSize(*)
    integer(kind=C_INT), intent(in) :: dimPos(*)
    real(kind=C_DOUBLE) :: ret
  end function tixiGetArrayValue


! ReturnCode tixiGetArrayElementCount (const TixiDocumentHandle handle, const char *arrayPath, const char *elementName, int *elements);
  function tixiGetArrayElementCount_c(handle, &
        arrayPath, &
        elementName, &
        elements) &
      result(ret) &
      bind(C,name='tixiGetArrayElementCount')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    character(kind=C_CHAR), intent(in) :: elementName(*)
    integer(kind=C_INT), intent(out) :: elements
    integer(kind=C_INT) :: ret
  end function tixiGetArrayElementCount_c


! ReturnCode tixiGetArrayElementNames (const TixiDocumentHandle handle, const char *arrayPath, const char *elementType, char **elementNames);
  function tixiGetArrayElementNames_c(handle, &
        arrayPath, &
        elementType, &
        elementNames) &
      result(ret) &
      bind(C,name='tixiGetArrayElementNames')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: arrayPath(*)
    character(kind=C_CHAR), intent(in) :: elementType(*)
    type(C_PTR), intent(inout) :: elementNames
    integer(kind=C_INT) :: ret
  end function tixiGetArrayElementNames_c


! ReturnCode tixiAddPoint (const TixiDocumentHandle handle, const char *pointParentPath, double x, double y, double z, const char *format);
  function tixiAddPoint_c(handle, &
        pointParentPath, &
        x, &
        y, &
        z, &
        format) &
      result(ret) &
      bind(C,name='tixiAddPoint')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: pointParentPath(*)
    real(kind=C_DOUBLE), value :: x
    real(kind=C_DOUBLE), value :: y
    real(kind=C_DOUBLE), value :: z
    character(kind=C_CHAR), intent(in) :: format(*)
    integer(kind=C_INT) :: ret
  end function tixiAddPoint_c


! ReturnCode tixiGetPoint (const TixiDocumentHandle handle, const char *pointParentPath, double *x, double *y, double *z);
  function tixiGetPoint_c(handle, &
        pointParentPath, &
        x, &
        y, &
        z) &
      result(ret) &
      bind(C,name='tixiGetPoint')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: pointParentPath(*)
    real(kind=C_DOUBLE), intent(out) :: x
    real(kind=C_DOUBLE), intent(out) :: y
    real(kind=C_DOUBLE), intent(out) :: z
    integer(kind=C_INT) :: ret
  end function tixiGetPoint_c


! ReturnCode tixiCheckAttribute(TixiDocumentHandle handle, const char *elementPath, const char *attributeName);
  function tixiCheckAttribute_c(handle, &
        elementPath, &
        attributeName) &
      result(ret) &
      bind(C,name='tixiCheckAttribute')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: elementPath(*)
    character(kind=C_CHAR), intent(in) :: attributeName(*)
    integer(kind=C_INT) :: ret
  end function tixiCheckAttribute_c


! ReturnCode tixiXSLTransformationToString(TixiDocumentHandle handle, const char *xslFilename, char **resultText);
  function tixiXSLTransformationToString_c(handle, &
        xslFilename, &
        resultText) &
      result(ret) &
      bind(C,name='tixiXSLTransformationToString')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xslFilename(*)
    type(C_PTR), intent(inout) :: resultText
    integer(kind=C_INT) :: ret
  end function tixiXSLTransformationToString_c


! ReturnCode tixiXSLTransformationToFile(TixiDocumentHandle handle, const char *xslFilename, const char *resultFilename);
  function tixiXSLTransformationToFile_c(handle, &
        xslFilename, &
        resultFilename) &
      result(ret) &
      bind(C,name='tixiXSLTransformationToFile')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xslFilename(*)
    character(kind=C_CHAR), intent(in) :: resultFilename(*)
    integer(kind=C_INT) :: ret
  end function tixiXSLTransformationToFile_c


! ReturnCode tixiXPathEvaluateNodeNumber(TixiDocumentHandle handle, const char *xPathExpression, int *number);
  function tixiXPathEvaluateNodeNumber_c(handle, &
        xPathExpression, &
        number) &
      result(ret) &
      bind(C,name='tixiXPathEvaluateNodeNumber')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xPathExpression(*)
    integer(kind=C_INT), intent(out) :: number
    integer(kind=C_INT) :: ret
  end function tixiXPathEvaluateNodeNumber_c


! ReturnCode tixiXPathExpressionGetXPath(TixiDocumentHandle handle, const char *xPathExpression, int index, char** xPath);
  function tixiXPathExpressionGetXPath_c(handle, &
        xPathExpression, &
        index, &
        xPath) &
      result(ret) &
      bind(C,name='tixiXPathExpressionGetXPath')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xPathExpression(*)
    integer(kind=C_INT), value :: index
    type(C_PTR), intent(inout) :: xPath
    integer(kind=C_INT) :: ret
  end function tixiXPathExpressionGetXPath_c


! ReturnCode tixiXPathExpressionGetTextByIndex(TixiDocumentHandle handle, const char *xPathExpression, int elementNumber, char **text);
  function tixiXPathExpressionGetTextByIndex_c(handle, &
        xPathExpression, &
        elementNumber, &
        text) &
      result(ret) &
      bind(C,name='tixiXPathExpressionGetTextByIndex')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xPathExpression(*)
    integer(kind=C_INT), value :: elementNumber
    type(C_PTR), intent(inout) :: text
    integer(kind=C_INT) :: ret
  end function tixiXPathExpressionGetTextByIndex_c


! ReturnCode tixiUIDCheckDuplicates(TixiDocumentHandle handle);
  function tixiUIDCheckDuplicates(handle) &
      result(ret) &
      bind(C,name='tixiUIDCheckDuplicates')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT) :: ret
  end function tixiUIDCheckDuplicates


! ReturnCode tixiUIDCheckLinks(TixiDocumentHandle handle);
  function tixiUIDCheckLinks(handle) &
      result(ret) &
      bind(C,name='tixiUIDCheckLinks')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    integer(kind=C_INT) :: ret
  end function tixiUIDCheckLinks


! ReturnCode tixiUIDGetXPath(TixiDocumentHandle handle, const char *uID, char **xPath);
  function tixiUIDGetXPath_c(handle, &
        uID, &
        xPath) &
      result(ret) &
      bind(C,name='tixiUIDGetXPath')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: uID(*)
    type(C_PTR), intent(inout) :: xPath
    integer(kind=C_INT) :: ret
  end function tixiUIDGetXPath_c


! ReturnCode tixiUIDCheckExists(TixiDocumentHandle handle, const char *uID);
  function tixiUIDCheckExists_c(handle, &
        uID) &
      result(ret) &
      bind(C,name='tixiUIDCheckExists')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: uID(*)
    integer(kind=C_INT) :: ret
  end function tixiUIDCheckExists_c


! ReturnCode tixiUIDSetToXPath(TixiDocumentHandle handle, const char *xPath, const char *uID);
  function tixiUIDSetToXPath_c(handle, &
        xPath, &
        uID) &
      result(ret) &
      bind(C,name='tixiUIDSetToXPath')
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), value :: handle
    character(kind=C_CHAR), intent(in) :: xPath(*)
    character(kind=C_CHAR), intent(in) :: uID(*)
    integer(kind=C_INT) :: ret
  end function tixiUIDSetToXPath_c


end interface


  private :: tixiGetVersion_c
  private :: tixiOpenDocument_c
  private :: tixiOpenDocumentRecursive_c
  private :: tixiOpenDocumentFromHTTP_c
  private :: tixiCreateDocument_c
  private :: tixiGetDocumentPath_c
  private :: tixiSaveDocument_c
  private :: tixiSaveCompleteDocument_c
  private :: tixiSaveAndRemoveDocument_c
  private :: tixiExportDocumentAsString_c
  private :: tixiImportFromString_c
  private :: tixiSchemaValidateFromFile_c
  private :: tixiSchemaValidateWithDefaultsFromFile_c
  private :: tixiSchemaValidateFromString_c
  private :: tixiDTDValidate_c
  private :: tixiGetTextElement_c
  private :: tixiGetIntegerElement_c
  private :: tixiGetDoubleElement_c
  private :: tixiGetBooleanElement_c
  private :: tixiUpdateTextElement_c
  private :: tixiUpdateDoubleElement_c
  private :: tixiUpdateIntegerElement_c
  private :: tixiUpdateBooleanElement_c
  private :: tixiAddTextElement_c
  private :: tixiAddTextElementNS_c
  private :: tixiAddTextElementAtIndex_c
  private :: tixiAddTextElementNSAtIndex_c
  private :: tixiAddBooleanElement_c
  private :: tixiAddBooleanElementNS_c
  private :: tixiAddDoubleElement_c
  private :: tixiAddDoubleElementNS_c
  private :: tixiAddIntegerElement_c
  private :: tixiAddIntegerElementNS_c
  private :: tixiAddFloatVector_c
  private :: tixiUpdateFloatVector_c
  private :: tixiCreateElement_c
  private :: tixiCreateElementNS_c
  private :: tixiCreateElementAtIndex_c
  private :: tixiCreateElementNSAtIndex_c
  private :: tixiRenameElement_c
  private :: tixiRemoveElement_c
  private :: tixiGetNodeType_c
  private :: tixiGetNamedChildrenCount_c
  private :: tixiGetChildNodeName_c
  private :: tixiGetNumberOfChilds_c
  private :: tixiSwapElements_c
  private :: tixiExportElementAsString_c
  private :: tixiImportElementFromString_c
  private :: tixiGetTextAttribute_c
  private :: tixiGetIntegerAttribute_c
  private :: tixiGetBooleanAttribute_c
  private :: tixiGetDoubleAttribute_c
  private :: tixiAddTextAttribute_c
  private :: tixiAddDoubleAttribute_c
  private :: tixiAddIntegerAttribute_c
  private :: tixiRemoveAttribute_c
  private :: tixiGetNumberOfAttributes_c
  private :: tixiGetAttributeName_c
  private :: tixiRegisterNamespace_c
  private :: tixiSetElementNamespace_c
  private :: tixiDeclareNamespace_c
  private :: tixiAddExternalLink_c
  private :: tixiAddHeader_c
  private :: tixiAddCpacsHeader_c
  private :: tixiCheckElement_c
  private :: tixiSetPrintMsgFunc_c
  private :: tixiGetPrintMsgFunc_c
  private :: tixiAddDoubleListWithAttributes_c
  private :: tixiGetVectorSize_c
  private :: tixiGetFloatVector_c
  private :: tixiGetArrayDimensions_c
  private :: tixiGetArrayDimensionSizes_c
  private :: tixiGetArrayDimensionNames_c
  private :: tixiGetArrayDimensionValues_c
  private :: tixiGetArrayParameters_c
  private :: tixiGetArrayParameterNames_c
  private :: tixiGetArray_c
  private :: tixiGetArrayElementCount_c
  private :: tixiGetArrayElementNames_c
  private :: tixiAddPoint_c
  private :: tixiGetPoint_c
  private :: tixiCheckAttribute_c
  private :: tixiXSLTransformationToString_c
  private :: tixiXSLTransformationToFile_c
  private :: tixiXPathEvaluateNodeNumber_c
  private :: tixiXPathExpressionGetXPath_c
  private :: tixiXPathExpressionGetTextByIndex_c
  private :: tixiUIDGetXPath_c
  private :: tixiUIDCheckExists_c
  private :: tixiUIDSetToXPath_c

  private :: c_f_stringptr
  private :: f_c_strarrayptr
  private :: c_f_strarrayptr


! we need a wrapper type to create arrays of C-strings as there is no pointer of a pointer in Fortran
type CStringPtr
  character(kind=C_CHAR), pointer :: str(:)
end type


contains
  
  subroutine c_f_stringptr(str_c, str_f)
    use, intrinsic :: iso_c_binding
    type(C_PTR), intent(in) :: str_c
    character(kind=C_CHAR), pointer, intent(inout) :: str_f(:)
    integer :: i
  
    if( .not. c_associated(str_c) ) return
    i = 1
    call c_f_pointer(str_c,str_f,(/i/))
    do while(str_f(i) .ne. C_NULL_CHAR)
      i = i + 1
      call c_f_pointer(str_c,str_f,(/i/))
    end do
    call c_f_pointer(str_c,str_f,(/i-1/))
  
  end subroutine c_f_stringptr
  
  subroutine f_c_strarrayptr(strarray_f,tmp_str,tmp_ptr,strarray_c)
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR,len=*), intent(in) :: strarray_f(:)
    character(kind=C_CHAR), target, allocatable, intent(inout) :: tmp_str(:,:)
    type(C_PTR), target, allocatable, intent(inout) :: tmp_ptr(:)
    type(C_PTR), intent(inout) :: strarray_c
    integer :: i, j
  
    allocate(tmp_str(1+len(strarray_f),size(strarray_f)))
    allocate(tmp_ptr(size(strarray_f)))
    do i = 1, size(strarray_f), 1
      do j = 1, len(strarray_f), 1
        tmp_str(j,i) = strarray_f(i)(j:j)
      end do
      tmp_str(len(strarray_f)+1,i) = C_NULL_CHAR
      tmp_ptr(i) = c_loc( tmp_str(1,i) )
    end do
  
    strarray_c = c_loc(tmp_ptr)
  end subroutine
  
  ! WARNING this function is written such that it
  !         circumvents triggering old GCC gfortran bugs
  subroutine c_f_strarrayptr(n,strarray_c,strarray_f)
    use, intrinsic :: iso_c_binding
    integer, intent(in) :: n
    type(C_PTR), intent(in) :: strarray_c(n)
    type(CStringPtr), target, intent(inout) :: strarray_f(n)
    type(CStringPtr), pointer :: tmp => null()
    integer :: i
  
    do i = 1, n, 1
      tmp => strarray_f(i)
      call c_f_stringptr(strarray_c(i),tmp%str)
    end do
  end subroutine




  
  subroutine tixiGetVersion(str)
    use, intrinsic :: iso_c_binding
    implicit none
    character(kind=C_CHAR), pointer, intent(out) :: str(:)
    type(C_PTR) :: str_c
  
    str_c = tixiGetVersion_c()
    call c_f_stringptr(str_c,str)
  
  end subroutine
  
  ! commented out for gfortran <= 4.3 compatibility
  !function tixiGetPrintMsgFunc() result(fnc)
  !  use, intrinsic :: iso_c_binding
  !  implicit none
  !  procedure(TixiPrintMsgFnc), pointer :: fnc
  !  type(C_FUNPTR) :: fnc_c
  !  type(C_PTR) :: fnc_c_
  !
  !  fnc_c_ = tixiGetPrintMsgFunc_c()
  !  ! ugly conversion from C_PTR to C_FUNPTR
  !  fnc_c = transfer(fnc_c_, fnc_c)
  !  call c_f_procpointer(fnc_c,fnc)
  !end function
  !
  !
  !function tixiSetPrintMsgFunc(fnc) result(ret)
  !  use, intrinsic :: iso_c_binding
  !  implicit none
  !  procedure(TixiPrintMsgFnc), pointer, intent(in) :: fnc
  !  integer(kind=C_INT) :: ret
  !  type(C_FUNPTR) :: fnc_c
  !  type(C_PTR) :: fnc_c_
  !
  !  fnc_c = c_funloc(fnc)
  !  ! ugly conversion from C_FUNPTR to C_PTR
  !  fnc_c_ = transfer(fnc_c, fnc_c_)
  !  ret = tixiSetPrintMsgFunc_c(fnc_c_)
  !end function




! ReturnCode tixiOpenDocument (const char *xmlFilename, TixiDocumentHandle * handle);
  function tixiOpenDocument(xmlFilename, &
        handle) &
      result(ret)
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR,len=*), intent(in) :: xmlFilename
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret

    ret = tixiOpenDocument_c(xmlFilename // C_NULL_CHAR, &
        handle)

  end function tixiOpenDocument


! ReturnCode tixiOpenDocumentRecursive (const char *xmlFilename, TixiDocumentHandle * handle, OpenMode oMode);
  function tixiOpenDocumentRecursive(xmlFilename, &
        handle, &
        oMode) &
      result(ret)
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR,len=*), intent(in) :: xmlFilename
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT), intent(in) :: oMode
    integer(kind=C_INT) :: ret

    ret = tixiOpenDocumentRecursive_c(xmlFilename // C_NULL_CHAR, &
        handle, &
        oMode)

  end function tixiOpenDocumentRecursive


! ReturnCode tixiOpenDocumentFromHTTP (const char *httpURL, TixiDocumentHandle * handle);
  function tixiOpenDocumentFromHTTP(httpURL, &
        handle) &
      result(ret)
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR,len=*), intent(in) :: httpURL
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret

    ret = tixiOpenDocumentFromHTTP_c(httpURL // C_NULL_CHAR, &
        handle)

  end function tixiOpenDocumentFromHTTP


! ReturnCode tixiCreateDocument (const char *rootElementName, TixiDocumentHandle * handle);
  function tixiCreateDocument(rootElementName, &
        handle) &
      result(ret)
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR,len=*), intent(in) :: rootElementName
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret

    ret = tixiCreateDocument_c(rootElementName // C_NULL_CHAR, &
        handle)

  end function tixiCreateDocument


! ReturnCode tixiGetDocumentPath (TixiDocumentHandle handle, char** documentPath);
  function tixiGetDocumentPath(handle, &
        documentPath) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR), pointer :: documentPath(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: documentPath_c

    documentPath_c = C_NULL_PTR


    ret = tixiGetDocumentPath_c(handle, &
        documentPath_c)

    call c_f_stringptr(documentPath_c, documentPath)

  end function tixiGetDocumentPath


! ReturnCode tixiSaveDocument (TixiDocumentHandle handle, const char *xmlFilename);
  function tixiSaveDocument(handle, &
        xmlFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xmlFilename
    integer(kind=C_INT) :: ret

    ret = tixiSaveDocument_c(handle, &
        xmlFilename // C_NULL_CHAR)

  end function tixiSaveDocument


! ReturnCode tixiSaveCompleteDocument (TixiDocumentHandle handle, const char *xmlFilename);
  function tixiSaveCompleteDocument(handle, &
        xmlFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xmlFilename
    integer(kind=C_INT) :: ret

    ret = tixiSaveCompleteDocument_c(handle, &
        xmlFilename // C_NULL_CHAR)

  end function tixiSaveCompleteDocument


! ReturnCode tixiSaveAndRemoveDocument (TixiDocumentHandle handle, const char *xmlFilename);
  function tixiSaveAndRemoveDocument(handle, &
        xmlFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xmlFilename
    integer(kind=C_INT) :: ret

    ret = tixiSaveAndRemoveDocument_c(handle, &
        xmlFilename // C_NULL_CHAR)

  end function tixiSaveAndRemoveDocument


! ReturnCode tixiExportDocumentAsString (const TixiDocumentHandle handle, char **text);
  function tixiExportDocumentAsString(handle, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR), pointer :: text(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: text_c

    text_c = C_NULL_PTR


    ret = tixiExportDocumentAsString_c(handle, &
        text_c)

    call c_f_stringptr(text_c, text)

  end function tixiExportDocumentAsString


! ReturnCode tixiImportFromString (const char *xmlImportString, TixiDocumentHandle * handle);
  function tixiImportFromString(xmlImportString, &
        handle) &
      result(ret)
    use, intrinsic :: iso_c_binding
    character(kind=C_CHAR,len=*), intent(in) :: xmlImportString
    integer(kind=C_INT), intent(out) :: handle
    integer(kind=C_INT) :: ret

    ret = tixiImportFromString_c(xmlImportString // C_NULL_CHAR, &
        handle)

  end function tixiImportFromString


! ReturnCode tixiSchemaValidateFromFile (const TixiDocumentHandle handle, const char *xsdFilename);
  function tixiSchemaValidateFromFile(handle, &
        xsdFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xsdFilename
    integer(kind=C_INT) :: ret

    ret = tixiSchemaValidateFromFile_c(handle, &
        xsdFilename // C_NULL_CHAR)

  end function tixiSchemaValidateFromFile


! ReturnCode tixiSchemaValidateWithDefaultsFromFile (const TixiDocumentHandle handle, const char *xsdFilename);
  function tixiSchemaValidateWithDefaultsFromFile(handle, &
        xsdFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xsdFilename
    integer(kind=C_INT) :: ret

    ret = tixiSchemaValidateWithDefaultsFromFile_c(handle, &
        xsdFilename // C_NULL_CHAR)

  end function tixiSchemaValidateWithDefaultsFromFile


! ReturnCode tixiSchemaValidateFromString (const TixiDocumentHandle handle, const char *xsdString);
  function tixiSchemaValidateFromString(handle, &
        xsdString) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xsdString
    integer(kind=C_INT) :: ret

    ret = tixiSchemaValidateFromString_c(handle, &
        xsdString // C_NULL_CHAR)

  end function tixiSchemaValidateFromString


! ReturnCode tixiDTDValidate (const TixiDocumentHandle handle, const char *DTDFilename);
  function tixiDTDValidate(handle, &
        DTDFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: DTDFilename
    integer(kind=C_INT) :: ret

    ret = tixiDTDValidate_c(handle, &
        DTDFilename // C_NULL_CHAR)

  end function tixiDTDValidate


! ReturnCode tixiGetTextElement (const TixiDocumentHandle handle, const char *elementPath, char **text);
  function tixiGetTextElement(handle, &
        elementPath, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR), pointer :: text(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: text_c

    text_c = C_NULL_PTR


    ret = tixiGetTextElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        text_c)

    call c_f_stringptr(text_c, text)

  end function tixiGetTextElement


! ReturnCode tixiGetIntegerElement (const TixiDocumentHandle handle, const char *elementPath, int *number);
  function tixiGetIntegerElement(handle, &
        elementPath, &
        number) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(out) :: number
    integer(kind=C_INT) :: ret

    ret = tixiGetIntegerElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        number)

  end function tixiGetIntegerElement


! ReturnCode tixiGetDoubleElement (const TixiDocumentHandle handle, const char *elementPath, double *number);
  function tixiGetDoubleElement(handle, &
        elementPath, &
        number) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    real(kind=C_DOUBLE), intent(out) :: number
    integer(kind=C_INT) :: ret

    ret = tixiGetDoubleElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        number)

  end function tixiGetDoubleElement


! ReturnCode tixiGetBooleanElement (const TixiDocumentHandle handle, const char *elementPath, int *boolean);
  function tixiGetBooleanElement(handle, &
        elementPath, &
        boolean) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(out) :: boolean
    integer(kind=C_INT) :: ret

    ret = tixiGetBooleanElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        boolean)

  end function tixiGetBooleanElement


! ReturnCode tixiUpdateTextElement (const TixiDocumentHandle handle, const char *elementPath, const char *text);
  function tixiUpdateTextElement(handle, &
        elementPath, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: text
    integer(kind=C_INT) :: ret

    ret = tixiUpdateTextElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        text // C_NULL_CHAR)

  end function tixiUpdateTextElement


! ReturnCode tixiUpdateDoubleElement (const TixiDocumentHandle handle, const char *elementPath, double number, const char *format);
  function tixiUpdateDoubleElement(handle, &
        elementPath, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    real(kind=C_DOUBLE), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiUpdateDoubleElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiUpdateDoubleElement


! ReturnCode tixiUpdateIntegerElement (const TixiDocumentHandle handle, const char *elementPath, int number, const char *format);
  function tixiUpdateIntegerElement(handle, &
        elementPath, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiUpdateIntegerElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiUpdateIntegerElement


! ReturnCode tixiUpdateBooleanElement (const TixiDocumentHandle handle, const char *elementPath, int boolean);
  function tixiUpdateBooleanElement(handle, &
        elementPath, &
        boolean) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(in) :: boolean
    integer(kind=C_INT) :: ret

    ret = tixiUpdateBooleanElement_c(handle, &
        elementPath // C_NULL_CHAR, &
        boolean)

  end function tixiUpdateBooleanElement


! ReturnCode tixiAddTextElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, const char *text);
  function tixiAddTextElement(handle, &
        parentPath, &
        elementName, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    character(kind=C_CHAR,len=*), intent(in) :: text
    integer(kind=C_INT) :: ret

    ret = tixiAddTextElement_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        text // C_NULL_CHAR)

  end function tixiAddTextElement


! ReturnCode tixiAddTextElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char *namespaceURI, const char *text);
  function tixiAddTextElementNS(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    character(kind=C_CHAR,len=*), intent(in) :: text
    integer(kind=C_INT) :: ret

    ret = tixiAddTextElementNS_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        text // C_NULL_CHAR)

  end function tixiAddTextElementNS


! ReturnCode tixiAddTextElementAtIndex (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, const char *text, int index);
  function tixiAddTextElementAtIndex(handle, &
        parentPath, &
        elementName, &
        text, &
        index) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    character(kind=C_CHAR,len=*), intent(in) :: text
    integer(kind=C_INT), intent(in) :: index
    integer(kind=C_INT) :: ret

    ret = tixiAddTextElementAtIndex_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        text // C_NULL_CHAR, &
        index)

  end function tixiAddTextElementAtIndex


! ReturnCode tixiAddTextElementNSAtIndex(const TixiDocumentHandle handle, const char *parentPath, const char* qualifiedName, const char* namespaceURI, const char *text, int index);
  function tixiAddTextElementNSAtIndex(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        text, &
        index) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    character(kind=C_CHAR,len=*), intent(in) :: text
    integer(kind=C_INT), intent(in) :: index
    integer(kind=C_INT) :: ret

    ret = tixiAddTextElementNSAtIndex_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        text // C_NULL_CHAR, &
        index)

  end function tixiAddTextElementNSAtIndex


! ReturnCode tixiAddBooleanElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, int boolean);
  function tixiAddBooleanElement(handle, &
        parentPath, &
        elementName, &
        boolean) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT), intent(in) :: boolean
    integer(kind=C_INT) :: ret

    ret = tixiAddBooleanElement_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        boolean)

  end function tixiAddBooleanElement


! ReturnCode tixiAddBooleanElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char* namespaceURI, int boolean);
  function tixiAddBooleanElementNS(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        boolean) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    integer(kind=C_INT), intent(in) :: boolean
    integer(kind=C_INT) :: ret

    ret = tixiAddBooleanElementNS_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        boolean)

  end function tixiAddBooleanElementNS


! ReturnCode tixiAddDoubleElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, double number, const char *format);
  function tixiAddDoubleElement(handle, &
        parentPath, &
        elementName, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    real(kind=C_DOUBLE), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddDoubleElement_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiAddDoubleElement


! ReturnCode tixiAddDoubleElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char* namespaceURI, double number, const char *format);
  function tixiAddDoubleElementNS(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    real(kind=C_DOUBLE), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddDoubleElementNS_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiAddDoubleElementNS


! ReturnCode tixiAddIntegerElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, int number, const char *format);
  function tixiAddIntegerElement(handle, &
        parentPath, &
        elementName, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddIntegerElement_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiAddIntegerElement


! ReturnCode tixiAddIntegerElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char *namespaceURI, int number, const char *format);
  function tixiAddIntegerElementNS(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    integer(kind=C_INT), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddIntegerElementNS_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiAddIntegerElementNS


! ReturnCode tixiAddFloatVector (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, const double *vector, const int numElements, const char* format);
! #annotate in: 3A(4)#
  function tixiAddFloatVector(handle, &
        parentPath, &
        elementName, &
        vector, &
        numElements, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT), intent(in) :: numElements
    character(kind=C_CHAR,len=*), intent(in) :: format
    real(kind=C_DOUBLE), intent(in) :: vector(numElements)
    integer(kind=C_INT) :: ret

    ret = tixiAddFloatVector_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        vector, &
        numElements, &
        format // C_NULL_CHAR)

  end function tixiAddFloatVector


! ReturnCode tixiUpdateFloatVector (const TixiDocumentHandle handle, const char *path, const double *vector, const int numElements, const char* format);
! #annotate in: 2A(3)#
  function tixiUpdateFloatVector(handle, &
        path, &
        vector, &
        numElements, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: path
    integer(kind=C_INT), intent(in) :: numElements
    character(kind=C_CHAR,len=*), intent(in) :: format
    real(kind=C_DOUBLE), intent(in) :: vector(numElements)
    integer(kind=C_INT) :: ret

    ret = tixiUpdateFloatVector_c(handle, &
        path // C_NULL_CHAR, &
        vector, &
        numElements, &
        format // C_NULL_CHAR)

  end function tixiUpdateFloatVector


! ReturnCode tixiCreateElement (const TixiDocumentHandle handle, const char *parentPath, const char *elementName);
  function tixiCreateElement(handle, &
        parentPath, &
        elementName) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT) :: ret

    ret = tixiCreateElement_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR)

  end function tixiCreateElement


! ReturnCode tixiCreateElementNS (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, const char* namespaceURI);
  function tixiCreateElementNS(handle, &
        parentPath, &
        qualifiedName, &
        namespaceURI) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    integer(kind=C_INT) :: ret

    ret = tixiCreateElementNS_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR)

  end function tixiCreateElementNS


! ReturnCode tixiCreateElementAtIndex (const TixiDocumentHandle handle, const char *parentPath, const char *elementName, int index);
  function tixiCreateElementAtIndex(handle, &
        parentPath, &
        elementName, &
        index) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT), intent(in) :: index
    integer(kind=C_INT) :: ret

    ret = tixiCreateElementAtIndex_c(handle, &
        parentPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        index)

  end function tixiCreateElementAtIndex


! ReturnCode tixiCreateElementNSAtIndex (const TixiDocumentHandle handle, const char *parentPath, const char *qualifiedName, int index, const char* namespaceURI);
  function tixiCreateElementNSAtIndex(handle, &
        parentPath, &
        qualifiedName, &
        index, &
        namespaceURI) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: qualifiedName
    integer(kind=C_INT), intent(in) :: index
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    integer(kind=C_INT) :: ret

    ret = tixiCreateElementNSAtIndex_c(handle, &
        parentPath // C_NULL_CHAR, &
        qualifiedName // C_NULL_CHAR, &
        index, &
        namespaceURI // C_NULL_CHAR)

  end function tixiCreateElementNSAtIndex


! ReturnCode tixiRenameElement(const TixiDocumentHandle handle, const char* parentPath, const char* oldName, const char* newName);
  function tixiRenameElement(handle, &
        parentPath, &
        oldName, &
        newName) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: oldName
    character(kind=C_CHAR,len=*), intent(in) :: newName
    integer(kind=C_INT) :: ret

    ret = tixiRenameElement_c(handle, &
        parentPath // C_NULL_CHAR, &
        oldName // C_NULL_CHAR, &
        newName // C_NULL_CHAR)

  end function tixiRenameElement


! ReturnCode tixiRemoveElement (const TixiDocumentHandle handle, const char *elementPath);
  function tixiRemoveElement(handle, &
        elementPath) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT) :: ret

    ret = tixiRemoveElement_c(handle, &
        elementPath // C_NULL_CHAR)

  end function tixiRemoveElement


! ReturnCode tixiGetNodeType (const TixiDocumentHandle handle, const char *nodePath, char **nodeType);
  function tixiGetNodeType(handle, &
        nodePath, &
        nodeType) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: nodePath
    character(kind=C_CHAR), pointer :: nodeType(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: nodeType_c

    nodeType_c = C_NULL_PTR


    ret = tixiGetNodeType_c(handle, &
        nodePath // C_NULL_CHAR, &
        nodeType_c)

    call c_f_stringptr(nodeType_c, nodeType)

  end function tixiGetNodeType


! ReturnCode tixiGetNamedChildrenCount (const TixiDocumentHandle handle, const char *elementPath, const char *childName, int *count);
  function tixiGetNamedChildrenCount(handle, &
        elementPath, &
        childName, &
        count) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: childName
    integer(kind=C_INT), intent(out) :: count
    integer(kind=C_INT) :: ret

    ret = tixiGetNamedChildrenCount_c(handle, &
        elementPath // C_NULL_CHAR, &
        childName // C_NULL_CHAR, &
        count)

  end function tixiGetNamedChildrenCount


! ReturnCode tixiGetChildNodeName (const TixiDocumentHandle handle, const char *parentElementPath, int index, char **name);
  function tixiGetChildNodeName(handle, &
        parentElementPath, &
        index, &
        name) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentElementPath
    integer(kind=C_INT), intent(in) :: index
    character(kind=C_CHAR), pointer :: name(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: name_c

    name_c = C_NULL_PTR


    ret = tixiGetChildNodeName_c(handle, &
        parentElementPath // C_NULL_CHAR, &
        index, &
        name_c)

    call c_f_stringptr(name_c, name)

  end function tixiGetChildNodeName


! ReturnCode tixiGetNumberOfChilds(const TixiDocumentHandle handle, const char *elementPath, int* nChilds);
  function tixiGetNumberOfChilds(handle, &
        elementPath, &
        nChilds) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(out) :: nChilds
    integer(kind=C_INT) :: ret

    ret = tixiGetNumberOfChilds_c(handle, &
        elementPath // C_NULL_CHAR, &
        nChilds)

  end function tixiGetNumberOfChilds


! ReturnCode tixiSwapElements(const TixiDocumentHandle handle, const char* element1Path, const char* element2Path);
  function tixiSwapElements(handle, &
        element1Path, &
        element2Path) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: element1Path
    character(kind=C_CHAR,len=*), intent(in) :: element2Path
    integer(kind=C_INT) :: ret

    ret = tixiSwapElements_c(handle, &
        element1Path // C_NULL_CHAR, &
        element2Path // C_NULL_CHAR)

  end function tixiSwapElements


! ReturnCode tixiExportElementAsString (const TixiDocumentHandle handle, const char* elementPath, char **text);
  function tixiExportElementAsString(handle, &
        elementPath, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR), pointer :: text(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: text_c

    text_c = C_NULL_PTR


    ret = tixiExportElementAsString_c(handle, &
        elementPath // C_NULL_CHAR, &
        text_c)

    call c_f_stringptr(text_c, text)

  end function tixiExportElementAsString


! ReturnCode tixiImportElementFromString (const TixiDocumentHandle handle, const char *parentPath, const char *xmlImportString);
  function tixiImportElementFromString(handle, &
        parentPath, &
        xmlImportString) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: xmlImportString
    integer(kind=C_INT) :: ret

    ret = tixiImportElementFromString_c(handle, &
        parentPath // C_NULL_CHAR, &
        xmlImportString // C_NULL_CHAR)

  end function tixiImportElementFromString


! ReturnCode tixiGetTextAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, char **text);
  function tixiGetTextAttribute(handle, &
        elementPath, &
        attributeName, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    character(kind=C_CHAR), pointer :: text(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: text_c

    text_c = C_NULL_PTR


    ret = tixiGetTextAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        text_c)

    call c_f_stringptr(text_c, text)

  end function tixiGetTextAttribute


! ReturnCode tixiGetIntegerAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, int *number);
  function tixiGetIntegerAttribute(handle, &
        elementPath, &
        attributeName, &
        number) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    integer(kind=C_INT), intent(out) :: number
    integer(kind=C_INT) :: ret

    ret = tixiGetIntegerAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        number)

  end function tixiGetIntegerAttribute


! ReturnCode tixiGetBooleanAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, int *boolean);
  function tixiGetBooleanAttribute(handle, &
        elementPath, &
        attributeName, &
        boolean) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    integer(kind=C_INT), intent(out) :: boolean
    integer(kind=C_INT) :: ret

    ret = tixiGetBooleanAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        boolean)

  end function tixiGetBooleanAttribute


! ReturnCode tixiGetDoubleAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, double *number);
  function tixiGetDoubleAttribute(handle, &
        elementPath, &
        attributeName, &
        number) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    real(kind=C_DOUBLE), intent(out) :: number
    integer(kind=C_INT) :: ret

    ret = tixiGetDoubleAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        number)

  end function tixiGetDoubleAttribute


! ReturnCode tixiAddTextAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, const char *attributeValue);
  function tixiAddTextAttribute(handle, &
        elementPath, &
        attributeName, &
        attributeValue) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    character(kind=C_CHAR,len=*), intent(in) :: attributeValue
    integer(kind=C_INT) :: ret

    ret = tixiAddTextAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        attributeValue // C_NULL_CHAR)

  end function tixiAddTextAttribute


! ReturnCode tixiAddDoubleAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, double number, const char *format);
  function tixiAddDoubleAttribute(handle, &
        elementPath, &
        attributeName, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    real(kind=C_DOUBLE), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddDoubleAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiAddDoubleAttribute


! ReturnCode tixiAddIntegerAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName, int number, const char *format);
  function tixiAddIntegerAttribute(handle, &
        elementPath, &
        attributeName, &
        number, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    integer(kind=C_INT), intent(in) :: number
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddIntegerAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR, &
        number, &
        format // C_NULL_CHAR)

  end function tixiAddIntegerAttribute


! ReturnCode tixiRemoveAttribute (const TixiDocumentHandle handle, const char *elementPath, const char *attributeName);
  function tixiRemoveAttribute(handle, &
        elementPath, &
        attributeName) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    integer(kind=C_INT) :: ret

    ret = tixiRemoveAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR)

  end function tixiRemoveAttribute


! ReturnCode tixiGetNumberOfAttributes(const TixiDocumentHandle handle, const char *elementPath, int* nAttributes);
  function tixiGetNumberOfAttributes(handle, &
        elementPath, &
        nAttributes) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(out) :: nAttributes
    integer(kind=C_INT) :: ret

    ret = tixiGetNumberOfAttributes_c(handle, &
        elementPath // C_NULL_CHAR, &
        nAttributes)

  end function tixiGetNumberOfAttributes


! ReturnCode tixiGetAttributeName(const TixiDocumentHandle handle, const char *elementPath, int attrIndex, char** attrName);
  function tixiGetAttributeName(handle, &
        elementPath, &
        attrIndex, &
        attrName) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT), intent(in) :: attrIndex
    character(kind=C_CHAR), pointer :: attrName(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: attrName_c

    attrName_c = C_NULL_PTR


    ret = tixiGetAttributeName_c(handle, &
        elementPath // C_NULL_CHAR, &
        attrIndex, &
        attrName_c)

    call c_f_stringptr(attrName_c, attrName)

  end function tixiGetAttributeName


! ReturnCode tixiRegisterNamespace(const TixiDocumentHandle handle, const char* namespaceURI, const char* prefix);
  function tixiRegisterNamespace(handle, &
        namespaceURI, &
        prefix) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    character(kind=C_CHAR,len=*), intent(in) :: prefix
    integer(kind=C_INT) :: ret

    ret = tixiRegisterNamespace_c(handle, &
        namespaceURI // C_NULL_CHAR, &
        prefix // C_NULL_CHAR)

  end function tixiRegisterNamespace


! ReturnCode tixiSetElementNamespace(const TixiDocumentHandle handle, const char* elementPath, const char* namespaceURI, const char* prefix);
  function tixiSetElementNamespace(handle, &
        elementPath, &
        namespaceURI, &
        prefix) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    character(kind=C_CHAR,len=*), intent(in) :: prefix
    integer(kind=C_INT) :: ret

    ret = tixiSetElementNamespace_c(handle, &
        elementPath // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        prefix // C_NULL_CHAR)

  end function tixiSetElementNamespace


! ReturnCode tixiDeclareNamespace(const TixiDocumentHandle handle, const char* elementPath, const char* namespaceURI, const char* prefix);
  function tixiDeclareNamespace(handle, &
        elementPath, &
        namespaceURI, &
        prefix) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: namespaceURI
    character(kind=C_CHAR,len=*), intent(in) :: prefix
    integer(kind=C_INT) :: ret

    ret = tixiDeclareNamespace_c(handle, &
        elementPath // C_NULL_CHAR, &
        namespaceURI // C_NULL_CHAR, &
        prefix // C_NULL_CHAR)

  end function tixiDeclareNamespace


! ReturnCode tixiAddExternalLink (const TixiDocumentHandle handle, const char *parentPath, const char *pathOrUrl, const char *filename, AddLinkMode mode);
  function tixiAddExternalLink(handle, &
        parentPath, &
        pathOrUrl, &
        filename, &
        mode) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: pathOrUrl
    character(kind=C_CHAR,len=*), intent(in) :: filename
    integer(kind=C_INT), intent(in) :: mode
    integer(kind=C_INT) :: ret

    ret = tixiAddExternalLink_c(handle, &
        parentPath // C_NULL_CHAR, &
        pathOrUrl // C_NULL_CHAR, &
        filename // C_NULL_CHAR, &
        mode)

  end function tixiAddExternalLink


! ReturnCode tixiAddHeader (const TixiDocumentHandle handle, const char *toolName, const char *version, const char *authorName);
  function tixiAddHeader(handle, &
        toolName, &
        version, &
        authorName) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: toolName
    character(kind=C_CHAR,len=*), intent(in) :: version
    character(kind=C_CHAR,len=*), intent(in) :: authorName
    integer(kind=C_INT) :: ret

    ret = tixiAddHeader_c(handle, &
        toolName // C_NULL_CHAR, &
        version // C_NULL_CHAR, &
        authorName // C_NULL_CHAR)

  end function tixiAddHeader


! ReturnCode tixiAddCpacsHeader (const TixiDocumentHandle handle, const char *name, const char *creator, const char *version, const char *description, const char * cpacsVersion);
  function tixiAddCpacsHeader(handle, &
        name, &
        creator, &
        version, &
        description, &
        cpacsVersion) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: name
    character(kind=C_CHAR,len=*), intent(in) :: creator
    character(kind=C_CHAR,len=*), intent(in) :: version
    character(kind=C_CHAR,len=*), intent(in) :: description
    character(kind=C_CHAR,len=*), intent(in) :: cpacsVersion
    integer(kind=C_INT) :: ret

    ret = tixiAddCpacsHeader_c(handle, &
        name // C_NULL_CHAR, &
        creator // C_NULL_CHAR, &
        version // C_NULL_CHAR, &
        description // C_NULL_CHAR, &
        cpacsVersion // C_NULL_CHAR)

  end function tixiAddCpacsHeader


! ReturnCode tixiCheckElement (const TixiDocumentHandle handle, const char *elementPath);
  function tixiCheckElement(handle, &
        elementPath) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    integer(kind=C_INT) :: ret

    ret = tixiCheckElement_c(handle, &
        elementPath // C_NULL_CHAR)

  end function tixiCheckElement


! ReturnCode tixiAddDoubleListWithAttributes (const TixiDocumentHandle handle, const char *parentPath, const char *listName, const char *childName, const char *childAttributeName, const double *values, const char *format, const char **attributes, int nValues);
  function tixiAddDoubleListWithAttributes(handle, &
        parentPath, &
        listName, &
        childName, &
        childAttributeName, &
        values, &
        format, &
        attributes, &
        nValues) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: parentPath
    character(kind=C_CHAR,len=*), intent(in) :: listName
    character(kind=C_CHAR,len=*), intent(in) :: childName
    character(kind=C_CHAR,len=*), intent(in) :: childAttributeName
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT), intent(in) :: nValues
    real(kind=C_DOUBLE), intent(in) :: values(*)
    character(kind=C_CHAR,len=*), intent(in) :: attributes(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: attributes_c
    character(kind=C_CHAR), target, allocatable :: attributes_ctmp1(:,:)
    type(C_PTR), target, allocatable :: attributes_ctmp2(:)

    call f_c_strarrayptr(attributes, attributes_ctmp1, attributes_ctmp2, attributes_c)


    ret = tixiAddDoubleListWithAttributes_c(handle, &
        parentPath // C_NULL_CHAR, &
        listName // C_NULL_CHAR, &
        childName // C_NULL_CHAR, &
        childAttributeName // C_NULL_CHAR, &
        values, &
        format // C_NULL_CHAR, &
        attributes_c, &
        nValues)

  end function tixiAddDoubleListWithAttributes


! ReturnCode tixiGetVectorSize (const TixiDocumentHandle handle, const char *vectorPath, int *nElements);
  function tixiGetVectorSize(handle, &
        vectorPath, &
        nElements) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: vectorPath
    integer(kind=C_INT), intent(out) :: nElements
    integer(kind=C_INT) :: ret

    ret = tixiGetVectorSize_c(handle, &
        vectorPath // C_NULL_CHAR, &
        nElements)

  end function tixiGetVectorSize


! ReturnCode tixiGetFloatVector (const TixiDocumentHandle handle, const char *vectorPath, double **vectorArray, const int eNumber);
! #annotate out: 2A(3) #
  function tixiGetFloatVector(handle, &
        vectorPath, &
        vectorArray, &
        eNumber) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: vectorPath
    integer(kind=C_INT), intent(in) :: eNumber
    real(kind=C_DOUBLE), pointer, intent(out) :: vectorArray(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: vectorArray_c


    ret = tixiGetFloatVector_c(handle, &
        vectorPath // C_NULL_CHAR, &
        vectorArray_c, &
        eNumber)

    call c_f_pointer(vectorArray_c, vectorArray, (/eNumber/))

  end function tixiGetFloatVector


! ReturnCode tixiGetArrayDimensions (const TixiDocumentHandle handle, const char *arrayPath, int *dimensions);
  function tixiGetArrayDimensions(handle, &
        arrayPath, &
        dimensions) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    integer(kind=C_INT), intent(out) :: dimensions
    integer(kind=C_INT) :: ret

    ret = tixiGetArrayDimensions_c(handle, &
        arrayPath // C_NULL_CHAR, &
        dimensions)

  end function tixiGetArrayDimensions


! ReturnCode tixiGetArrayDimensionSizes (const TixiDocumentHandle handle, const char *arrayPath, int *sizes, int *linearArraySize);
! #annotate out: 2AM#
  function tixiGetArrayDimensionSizes(handle, &
        arrayPath, &
        sizes, &
        linearArraySize) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    integer(kind=C_INT), intent(out) :: linearArraySize
    integer(kind=C_INT), intent(out) :: sizes(*)
    integer(kind=C_INT) :: ret

    ret = tixiGetArrayDimensionSizes_c(handle, &
        arrayPath // C_NULL_CHAR, &
        sizes, &
        linearArraySize)

  end function tixiGetArrayDimensionSizes


! ReturnCode tixiGetArrayDimensionNames (const TixiDocumentHandle handle, const char *arrayPath, char **dimensionNames);
! #annotate out: 2AM#
  function tixiGetArrayDimensionNames(handle, &
        arrayPath, &
        dimensionNames) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    type(CStringPtr), intent(out) :: dimensionNames(:)
    integer(kind=C_INT) :: ret
    type(C_PTR), allocatable :: dimensionNames_c(:)

    allocate(dimensionNames_c(size(dimensionNames)))
    dimensionNames_c = C_NULL_PTR


    ret = tixiGetArrayDimensionNames_c(handle, &
        arrayPath // C_NULL_CHAR, &
        dimensionNames_c)

    call c_f_strarrayptr(size(dimensionNames),dimensionNames_c, dimensionNames)

  end function tixiGetArrayDimensionNames


! ReturnCode tixiGetArrayDimensionValues (const TixiDocumentHandle handle, const char *arrayPath, const int dimension, double *dimensionValues);
! #annotate out: 3AM#
  function tixiGetArrayDimensionValues(handle, &
        arrayPath, &
        dimension, &
        dimensionValues) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    integer(kind=C_INT), intent(in) :: dimension
    real(kind=C_DOUBLE), intent(out) :: dimensionValues(*)
    integer(kind=C_INT) :: ret

    ret = tixiGetArrayDimensionValues_c(handle, &
        arrayPath // C_NULL_CHAR, &
        dimension, &
        dimensionValues)

  end function tixiGetArrayDimensionValues


! ReturnCode tixiGetArrayParameters (const TixiDocumentHandle handle, const char *arrayPath, int *parameters);
  function tixiGetArrayParameters(handle, &
        arrayPath, &
        parameters) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    integer(kind=C_INT), intent(out) :: parameters
    integer(kind=C_INT) :: ret

    ret = tixiGetArrayParameters_c(handle, &
        arrayPath // C_NULL_CHAR, &
        parameters)

  end function tixiGetArrayParameters


! ReturnCode tixiGetArrayParameterNames (const TixiDocumentHandle handle, const char *arrayPath, char **parameterNames);
! #annotate out: 2AM#
  function tixiGetArrayParameterNames(handle, &
        arrayPath, &
        parameterNames) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    type(CStringPtr), intent(out) :: parameterNames(:)
    integer(kind=C_INT) :: ret
    type(C_PTR), allocatable :: parameterNames_c(:)

    allocate(parameterNames_c(size(parameterNames)))
    parameterNames_c = C_NULL_PTR


    ret = tixiGetArrayParameterNames_c(handle, &
        arrayPath // C_NULL_CHAR, &
        parameterNames_c)

    call c_f_strarrayptr(size(parameterNames),parameterNames_c, parameterNames)

  end function tixiGetArrayParameterNames


! ReturnCode tixiGetArray (const TixiDocumentHandle handle, const char *arrayPath, const char *elementName, int arraySize, double **values);
! #annotate out: 4A(3) #
  function tixiGetArray(handle, &
        arrayPath, &
        elementName, &
        arraySize, &
        values) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT), intent(in) :: arraySize
    real(kind=C_DOUBLE), pointer, intent(out) :: values(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: values_c


    ret = tixiGetArray_c(handle, &
        arrayPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        arraySize, &
        values_c)

    call c_f_pointer(values_c, values, (/arraySize/))

  end function tixiGetArray


! ReturnCode tixiGetArrayElementCount (const TixiDocumentHandle handle, const char *arrayPath, const char *elementName, int *elements);
  function tixiGetArrayElementCount(handle, &
        arrayPath, &
        elementName, &
        elements) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: arrayPath
    character(kind=C_CHAR,len=*), intent(in) :: elementName
    integer(kind=C_INT), intent(out) :: elements
    integer(kind=C_INT) :: ret

    ret = tixiGetArrayElementCount_c(handle, &
        arrayPath // C_NULL_CHAR, &
        elementName // C_NULL_CHAR, &
        elements)

  end function tixiGetArrayElementCount


! ReturnCode tixiAddPoint (const TixiDocumentHandle handle, const char *pointParentPath, double x, double y, double z, const char *format);
  function tixiAddPoint(handle, &
        pointParentPath, &
        x, &
        y, &
        z, &
        format) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: pointParentPath
    real(kind=C_DOUBLE), intent(in) :: x
    real(kind=C_DOUBLE), intent(in) :: y
    real(kind=C_DOUBLE), intent(in) :: z
    character(kind=C_CHAR,len=*), intent(in) :: format
    integer(kind=C_INT) :: ret

    ret = tixiAddPoint_c(handle, &
        pointParentPath // C_NULL_CHAR, &
        x, &
        y, &
        z, &
        format // C_NULL_CHAR)

  end function tixiAddPoint


! ReturnCode tixiGetPoint (const TixiDocumentHandle handle, const char *pointParentPath, double *x, double *y, double *z);
  function tixiGetPoint(handle, &
        pointParentPath, &
        x, &
        y, &
        z) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: pointParentPath
    real(kind=C_DOUBLE), intent(out) :: x
    real(kind=C_DOUBLE), intent(out) :: y
    real(kind=C_DOUBLE), intent(out) :: z
    integer(kind=C_INT) :: ret

    ret = tixiGetPoint_c(handle, &
        pointParentPath // C_NULL_CHAR, &
        x, &
        y, &
        z)

  end function tixiGetPoint


! ReturnCode tixiCheckAttribute(TixiDocumentHandle handle, const char *elementPath, const char *attributeName);
  function tixiCheckAttribute(handle, &
        elementPath, &
        attributeName) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: elementPath
    character(kind=C_CHAR,len=*), intent(in) :: attributeName
    integer(kind=C_INT) :: ret

    ret = tixiCheckAttribute_c(handle, &
        elementPath // C_NULL_CHAR, &
        attributeName // C_NULL_CHAR)

  end function tixiCheckAttribute


! ReturnCode tixiXSLTransformationToString(TixiDocumentHandle handle, const char *xslFilename, char **resultText);
  function tixiXSLTransformationToString(handle, &
        xslFilename, &
        resultText) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xslFilename
    character(kind=C_CHAR), pointer :: resultText(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: resultText_c

    resultText_c = C_NULL_PTR


    ret = tixiXSLTransformationToString_c(handle, &
        xslFilename // C_NULL_CHAR, &
        resultText_c)

    call c_f_stringptr(resultText_c, resultText)

  end function tixiXSLTransformationToString


! ReturnCode tixiXSLTransformationToFile(TixiDocumentHandle handle, const char *xslFilename, const char *resultFilename);
  function tixiXSLTransformationToFile(handle, &
        xslFilename, &
        resultFilename) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xslFilename
    character(kind=C_CHAR,len=*), intent(in) :: resultFilename
    integer(kind=C_INT) :: ret

    ret = tixiXSLTransformationToFile_c(handle, &
        xslFilename // C_NULL_CHAR, &
        resultFilename // C_NULL_CHAR)

  end function tixiXSLTransformationToFile


! ReturnCode tixiXPathEvaluateNodeNumber(TixiDocumentHandle handle, const char *xPathExpression, int *number);
  function tixiXPathEvaluateNodeNumber(handle, &
        xPathExpression, &
        number) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xPathExpression
    integer(kind=C_INT), intent(out) :: number
    integer(kind=C_INT) :: ret

    ret = tixiXPathEvaluateNodeNumber_c(handle, &
        xPathExpression // C_NULL_CHAR, &
        number)

  end function tixiXPathEvaluateNodeNumber


! ReturnCode tixiXPathExpressionGetXPath(TixiDocumentHandle handle, const char *xPathExpression, int index, char** xPath);
  function tixiXPathExpressionGetXPath(handle, &
        xPathExpression, &
        index, &
        xPath) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xPathExpression
    integer(kind=C_INT), intent(in) :: index
    character(kind=C_CHAR), pointer :: xPath(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: xPath_c

    xPath_c = C_NULL_PTR


    ret = tixiXPathExpressionGetXPath_c(handle, &
        xPathExpression // C_NULL_CHAR, &
        index, &
        xPath_c)

    call c_f_stringptr(xPath_c, xPath)

  end function tixiXPathExpressionGetXPath


! ReturnCode tixiXPathExpressionGetTextByIndex(TixiDocumentHandle handle, const char *xPathExpression, int elementNumber, char **text);
  function tixiXPathExpressionGetTextByIndex(handle, &
        xPathExpression, &
        elementNumber, &
        text) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xPathExpression
    integer(kind=C_INT), intent(in) :: elementNumber
    character(kind=C_CHAR), pointer :: text(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: text_c

    text_c = C_NULL_PTR


    ret = tixiXPathExpressionGetTextByIndex_c(handle, &
        xPathExpression // C_NULL_CHAR, &
        elementNumber, &
        text_c)

    call c_f_stringptr(text_c, text)

  end function tixiXPathExpressionGetTextByIndex


! ReturnCode tixiUIDGetXPath(TixiDocumentHandle handle, const char *uID, char **xPath);
  function tixiUIDGetXPath(handle, &
        uID, &
        xPath) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: uID
    character(kind=C_CHAR), pointer :: xPath(:)
    integer(kind=C_INT) :: ret
    type(C_PTR) :: xPath_c

    xPath_c = C_NULL_PTR


    ret = tixiUIDGetXPath_c(handle, &
        uID // C_NULL_CHAR, &
        xPath_c)

    call c_f_stringptr(xPath_c, xPath)

  end function tixiUIDGetXPath


! ReturnCode tixiUIDCheckExists(TixiDocumentHandle handle, const char *uID);
  function tixiUIDCheckExists(handle, &
        uID) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: uID
    integer(kind=C_INT) :: ret

    ret = tixiUIDCheckExists_c(handle, &
        uID // C_NULL_CHAR)

  end function tixiUIDCheckExists


! ReturnCode tixiUIDSetToXPath(TixiDocumentHandle handle, const char *xPath, const char *uID);
  function tixiUIDSetToXPath(handle, &
        xPath, &
        uID) &
      result(ret)
    use, intrinsic :: iso_c_binding
    integer(kind=C_INT), intent(in) :: handle
    character(kind=C_CHAR,len=*), intent(in) :: xPath
    character(kind=C_CHAR,len=*), intent(in) :: uID
    integer(kind=C_INT) :: ret

    ret = tixiUIDSetToXPath_c(handle, &
        xPath // C_NULL_CHAR, &
        uID // C_NULL_CHAR)

  end function tixiUIDSetToXPath


end module
