# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASAprepro_lib clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASAprepro_lib requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASAprepro_lib build
## ---------------------------------------------------------------------------

set(SEACASAprepro_lib_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(SEACASAprepro_lib_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(SEACASAprepro_lib_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASAprepro_lib_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASAprepro_lib build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASAprepro_lib_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASAprepro_lib_CXX_FLAGS [[ ]])

set(SEACASAprepro_lib_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASAprepro_lib_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASAprepro_lib_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASAprepro_lib_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASAprepro_lib_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(SEACASAprepro_lib_BUILD_SHARED_LIBS "ON")

set(SEACASAprepro_lib_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(SEACASAprepro_lib_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASAprepro_lib_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(SEACASAprepro_lib_LIBRARIES SEACASAprepro_lib::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASAprepro_lib_MPI_LIBRARIES "")
set(SEACASAprepro_lib_MPI_LIBRARY_DIRS "")
set(SEACASAprepro_lib_MPI_INCLUDE_DIRS "")
set(SEACASAprepro_lib_MPI_EXEC "")
set(SEACASAprepro_lib_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASAprepro_lib_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(SEACASAprepro_lib_ENABLE_fmt ON)
set(SEACASAprepro_lib_ENABLE_SEACASExodus ON)

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages
if (NOT TARGET fmt::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/fmt/fmtConfig.cmake")
endif()
if (NOT TARGET SEACASExodus::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
endif()

# Import SEACASAprepro_lib targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASAprepro_libTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASAprepro_lib_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASAprepro_lib_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASAprepro_lib_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASAprepro_lib_EXPORTED_PACKAGE_LIBS_NAMES "aprepro_lib")

foreach(libname IN LISTS SEACASAprepro_lib_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASAprepro_lib::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASAprepro_lib::${libname}', or better yet,"
      " 'SEACASAprepro_lib::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASAprepro_lib'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASAprepro_lib_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
