#===============================================================================
# Chrono project configuration file
#
# This file is automatically generated when Chrono is configured and contains
# information on how the project was configured.  It can be used by third party
# projects in their own CMakeLists files to find the Chrono package and obtain
# information on how to link to the Chrono libraries.
#
# In the call to find_package(), the following Chrono components can be
# requested (case insensitive): 
#   Cascade, CSharp, FMI, FSI, GPU, Irrlicht, OpenGL, VSG, Matlab,
#   Modal, Multicore, PardisoMKL, Parsers, Postprocess, Sensor,
#   Synchrono, Vehicle, VehicleCosim.
# A component can be requested either as required or optional
# (see the CMake documentation for find_package).
# 
# Variables set by this script:
# Chrono_FOUND
#       set to true if Chrono and all required components were found
# CHRONO_CXX_STANDARD
#       C++ standard used while building Chrono
# CHRONO_C_FLAGS
# CHRONO_CXX_FLAGS
#       C and C++ compilation flags
# CHRONO_LINKER_FLAGS
#       additional linker flags
# CHRONO_STATIC
#       set to ON if Chrono has been built as static library, OFF if shared library
# CHRONO_INCLUDE_DIRS
#       full path to Chrono headers
# CHRONO_LIBRARIES
#       list of required libraries (with full path) of both Chrono and its dependencies
# CHRONO_DLL_NAMES
#       list of DLL names (without path) of both Chrono without its dependencies
# CHRONO_DEPENDENCY_DLLS
#       list of DLL names (with full path) of Chrono dependencies
# CHRONO_CSHARP_SOURCES
#       list of all SWIG-generated C# scripts corresponding to the requested components
#       (currently, only the core, Irrlicht, and Vehicle Chrono modules are wrapped for C#)
# CHRONO_DATA_DIR
#       path to the Chrono data directory
# CHRONO_VEHICLE_DATA_DIR
#       path to the Chrono::Vehicle data directory
# CHRONO_FSI_DATA_DIR
#       path to the Chrono::FSI data directory
# SYNCHRONO_DATA_DIR
#       path to the Chrono::Synchrono data directory
#
# In addition, for each requested component [COMPONENT], the following variable
# is set to true (ON) or false (OFF):
# CHRONO_[COMPONENT]_FOUND
#
# Other variables:
# CHRONO_SSE_FOUND
#       set to true if SSE support is available;
#       CHRONO_CXX_FLAGS includes all required flags.
# CHRONO_AVX_FOUND
#       set to true if AVX support is available;
#       CHRONO_CXX_FLAGS includes all required flags.
# CHRONO_MPI_FOUND
#       set to true if MPI support is available;
#       CHRONO_CXX_FLAGS, CHRONO_LINKER_FLAGS, and CHRONO_LIBRARIES include MPI.
#
# Certain Chrono modules can be configured with optional support. The following
# variables (meaningful only if the corresponding Chrono module is requested)
# can be used to check if these options are available:
# * Chrono::Parsers module
#     CHRONO_PARSERS_URDF
#       set to true if URDF support is available.
#     CHRONO_PARSERS_PYTHON
#       set to true if Python support is available.
# * Chrono::Vehicle module
#     CHRONO_VEHICLE_OPENCRG
#       set to true if OpenCRG support is vailable.
#     CHRONO_VEHICLE_IRRKLANG
#       set to true if Irrklang support is available.
# * Chrono::Synchrono module
#     CHRONO_SYNCHRONO_FASTDDS
#       set to true if FastDDS support is available.
#       CHRONO_INCLUDE_DIRS and CHRONO_LIBRARIES include FastDDS.
#       However, the user must still invoke fast_package(fastrtps)!
#===============================================================================

if (CHRONO_CONFIG_INCLUDED)
  return()
endif()
set(CHRONO_CONFIG_INCLUDED TRUE)

message(STATUS "Finding package Chrono...")

#-------------------------------------------------------------------------------
# Initialize output variables with settings for the main Chrono::Engine
#-------------------------------------------------------------------------------

set(CHRONO_CXX_STANDARD 17)

# Collect compiler and linker flags in CMake lists!
string(REGEX REPLACE "[ \t]+" ";" CHRONO_CXX_FLAGS "-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp -march=native -D_MINGW -D_WINDOWS -m64")
string(REGEX REPLACE "[ \t]+" ";" CHRONO_C_FLAGS "-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp -march=native -D_MINGW -D_WINDOWS -m64")
string(REGEX REPLACE "[ \t]+" ";" CHRONO_LINKER_FLAGS " -Wl,--enable-runtime-pseudo-reloc")

if (MSVC)
   list(APPEND CHRONO_CXX_FLAGS "/wd4251;/wd4275;/wd4250")
   list(APPEND CHRONO_C_FLAGS "/wd4251;/wd4275;/wd4250")
endif()

if (NOT ${CMAKE_SYSTEM_NAME} MATCHES "Windows")
  list(APPEND CHRONO_LINKER_FLAGS "-L/mingw64/lib")
endif()

set(CHRONO_STATIC OFF)
if (CHRONO_STATIC)
  add_compile_definitions(CH_STATIC)
endif()

if (MSVC)
   set(CMAKE_MSVC_RUNTIME_LIBRARY "")
endif()

set(CMAKE_C_FLAGS "-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp")
set(CMAKE_C_FLAGS_DEBUG "-g")
set(CMAKE_C_FLAGS_RELEASE "-O3 -DNDEBUG")
set(CMAKE_C_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(CMAKE_C_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(CMAKE_CXX_FLAGS "-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp -march=native -D_MINGW -D_WINDOWS -m64")
set(CMAKE_CXX_FLAGS_DEBUG "-g -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp -march=native -D_MINGW -D_WINDOWS -m64 -D_DEBUG -DDEBUG")
set(CMAKE_CXX_FLAGS_RELEASE "-O3 -DNDEBUG -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1  -fopenmp -march=native -D_MINGW -D_WINDOWS -m64 -DNDEBUG")
set(CMAKE_CXX_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")


list(APPEND CHRONO_INCLUDE_DIRS "/mingw64/include;/mingw64/include/chrono;/mingw64/include/chrono/collision/bullet;/mingw64/include/chrono/collision/gimpact;/mingw64/include/chrono_thirdparty/HACD;/mingw64/include/chrono_thirdparty/HACDv2;D:/a/msys64/mingw64/include/eigen3;")
list(APPEND CHRONO_LIBRARIES "D:/a/msys64/mingw64/lib/libgomp.dll.a;D:/a/msys64/mingw64/lib/libmingwthrd.a;D:/a/msys64/mingw64/lib/libmingwthrd.a")
list(APPEND CHRONO_LIBRARIES "ws2_32;winmm")
list(PREPEND CHRONO_LIB_NAMES "ChronoEngine")
list(PREPEND CHRONO_LIB_NAMES "ChronoModels_robot")
if (NOT CHRONO_STATIC)
  list(APPEND CHRONO_DLL_NAMES "ChronoEngine.dll")
  list(APPEND CHRONO_DLL_NAMES "ChronoModels_robot.dll")
endif()
list(APPEND CHRONO_DEPENDENCY_DLLS "")

set(CHRONO_CXX_STANDARD "17")

set(CHRONO_DATA_DIR "/mingw64/share/chrono/data/")
set(CHRONO_VEHICLE_DATA_DIR "/mingw64/share/chrono/data/vehicle/")
set(CHRONO_FSI_DATA_DIR "/mingw64/share/chrono/data/fsi/")
set(SYNCHRONO_DATA_DIR "/mingw64/share/chrono/data/synchrono/")

set(CHRONO_SSE_FOUND "TRUE")
set(CHRONO_AVX_FOUND "TRUE")
set(CHRONO_MPI_FOUND "FALSE")

#-------------------------------------------------------------------------------
# Local variables specifying which Chrono modules are available
#-------------------------------------------------------------------------------

set(Chrono_CASCADE_AVAILABLE        OFF)
set(Chrono_IRRLICHT_AVAILABLE       ON)
set(Chrono_MATLAB_AVAILABLE         OFF)
set(Chrono_PARDISOMKL_AVAILABLE     OFF)
set(Chrono_MUMPS_AVAILABLE          OFF)
set(Chrono_MULTICORE_AVAILABLE      OFF)
set(Chrono_OPENGL_AVAILABLE         OFF)
set(Chrono_POSTPROCESS_AVAILABLE    OFF)
set(Chrono_PARSERS_AVAILABLE        OFF)
set(Chrono_VEHICLE_AVAILABLE        OFF)
set(Chrono_FSI_AVAILABLE            OFF)
set(Chrono_GPU_AVAILABLE            OFF)
set(Chrono_SENSOR_AVAILABLE         OFF)
set(Chrono_SYNCHRONO_AVAILABLE      OFF)
set(Chrono_MODAL_AVAILABLE          OFF)
set(Chrono_VSG_AVAILABLE            OFF)
set(Chrono_CSHARP_AVAILABLE         OFF)
set(Chrono_FMI_AVAILABLE            OFF)
set(Chrono_ROS_AVAILABLE            OFF)

if(Chrono_VEHICLE_AVAILABLE AND ${CHRONO_MPI_FOUND})
   set(Chrono_VEHICLECOSIM_AVAILABLE TRUE)
else()
   set(Chrono_VEHICLECOSIM_AVAILABLE FALSE)
endif()

#-------------------------------------------------------------------------------
# List of requested component flags
#-------------------------------------------------------------------------------

foreach(COMPONENT ${Chrono_FIND_COMPONENTS})
  string(TOUPPER ${COMPONENT} COMPONENT_UPPER)
  set(Chrono_${COMPONENT_UPPER}_REQUESTED TRUE)
endforeach()

#-------------------------------------------------------------------------------
# Request additional components if requesting a component with dependencies
#-------------------------------------------------------------------------------

if(Chrono_VEHICLE_REQUESTED AND Chrono_VEHICLE_AVAILABLE)
  if(Chrono_FSI_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};FSI")
  endif()
  if(Chrono_MULTICORE_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};Multicore")
  endif()
endif()

if(Chrono_VEHICLECOSIM_REQUESTED AND Chrono_VEHICLECOSIM_AVAILABLE)
  set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};Vehicle")
  if(Chrono_MULTICORE_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};Multicore")
  endif()
  if(Chrono_GPU_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};GPU")
  endif()
  if(Chrono_FSI_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};FSI")
  endif()
  if(Chrono_PARDISOMKL_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};PardisoMKL")
  endif()
  if(Chrono_MUMPS_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};MUMPS")
  endif()
  if(Chrono_IRRLICHT_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};Irrlicht")
  endif()
  if(Chrono_OPENGL_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};OpenGL")
  endif()
  if(Chrono_VSG_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};VSG")
  endif()
endif()

if(Chrono_IRRLICHT_REQUESTED AND Chrono_IRRLICHT_AVAILABLE)
  if(Chrono_POSTPROCESS_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};Postprocess")
  endif()
  if(Chrono_MODAL_AVAILABLE)
    set(Chrono_FIND_COMPONENTS "${Chrono_FIND_COMPONENTS};Modal")
  endif()
endif()

#-------------------------------------------------------------------------------
# Rebuild list of requested component flags
#-------------------------------------------------------------------------------

foreach(COMPONENT ${Chrono_FIND_COMPONENTS})
  string(TOUPPER ${COMPONENT} COMPONENT_UPPER)
  set(Chrono_${COMPONENT_UPPER}_REQUESTED TRUE)
endforeach()

#-------------------------------------------------------------------------------
# Loop over the list of requested components
#-------------------------------------------------------------------------------

foreach(COMPONENT ${Chrono_FIND_COMPONENTS})

  string(TOUPPER ${COMPONENT} COMPONENT_UPPER)

  # Report the name of the component that was requested and whether it was
  # required or optional.

  if(Chrono_FIND_REQUIRED_${COMPONENT})
    set(COMPONENT_REQ_TYPE "REQUIRED")
  else()
    set(COMPONENT_REQ_TYPE "OPTIONAL")
  endif()
  message(STATUS "   Requested component ${COMPONENT} (${COMPONENT_REQ_TYPE})")

  if(NOT Chrono_${COMPONENT_UPPER}_AVAILABLE)  # component NOT available

    # The component is not available. Stop if it is required.
    set(CHRONO_${COMPONENT_UPPER}_FOUND OFF)

    if(Chrono_FIND_REQUIRED_${COMPONENT})
       message("Chrono was not configured with support for the REQUIRED component ${COMPONENT}")
       set(Chrono_FOUND OFF)
       return()
    else()
       message("Chrono was not configured with support for the OPTIONAL component ${COMPONENT}")
    endif()

  else()                                       # component available

    # The component is available. Set as FOUND.
    set(CHRONO_${COMPONENT_UPPER}_FOUND ON)

    if(${COMPONENT_UPPER} MATCHES "MULTICORE")

      separate_arguments(CH_MULTICORE_CXX_FLAGS NATIVE_COMMAND "")
      separate_arguments(CH_MULTICORE_C_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_CXX_FLAGS ${CH_MULTICORE_CXX_FLAGS})
      list(APPEND CHRONO_C_FLAGS ${CH_MULTICORE_C_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_multicore")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_multicore.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "MODAL")

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_modal")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_modal.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "OPENGL")

      set(GLEW_DIR "")
      set(glfw3_DIR "")
      find_package(GLEW REQUIRED)
      find_package(glfw3 REQUIRED)

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_opengl")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_opengl.dll")
      endif()
      list(APPEND CHRONO_DEPENDENCY_DLLS "")
      list(APPEND CHRONO_DEPENDENCY_DLLS "")
      if(${CMAKE_SYSTEM_NAME} MATCHES "Emscripten")
        list(APPEND CHRONO_LINKER_FLAGS "-s" "FULL_ES3=1" "-s" "USE_GLFW=3")
      else()
        list(APPEND CHRONO_LIBRARIES "GLEW::glew")
        list(APPEND CHRONO_LIBRARIES "glfw")
        list(APPEND CHRONO_LIBRARIES "")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "IRRLICHT")

      separate_arguments(CH_IRRLICHT_CXX_FLAGS NATIVE_COMMAND "")
      separate_arguments(CH_IRRLICHT_C_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_CXX_FLAGS ${CH_IRRLICHT_CXX_FLAGS})
      list(APPEND CHRONO_C_FLAGS ${CH_IRRLICHT_C_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "D:/a/msys64/mingw64/include/irrlicht")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_irrlicht")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_irrlicht.dll")
      else()
        # when a library is static does not link against the dependencies;
        # the child project thus needs to link itself
        list(APPEND CHRONO_LIBRARIES "")
      endif()
      list(APPEND CHRONO_DEPENDENCY_DLLS "")

    elseif(${COMPONENT_UPPER} MATCHES "VSG")

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_vsg")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_vsg.dll")
      endif()

      find_package(vsg REQUIRED)
      find_package(vsgImGui REQUIRED)
      find_package(vsgXchange REQUIRED)
      list(APPEND CHRONO_LIBRARIES "vsg::vsg;vsgImGui::vsgImGui;vsgXchange::vsgXchange")

    elseif(${COMPONENT_UPPER} MATCHES "VEHICLE")

      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_vehicle")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_vehicle.dll")
      endif()
      list(PREPEND CHRONO_LIB_NAMES "ChronoModels_vehicle")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoModels_vehicle.dll")
      endif()

      if(Chrono_IRRLICHT_REQUESTED AND Chrono_IRRLICHT_AVAILABLE)
        list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_vehicle_irrlicht")
        if (NOT CHRONO_STATIC)
          list(APPEND CHRONO_DLL_NAMES "ChronoEngine_vehicle_irrlicht.dll")
        endif()
        if()
          list(APPEND CHRONO_INCLUDE_DIRS "")
          list(APPEND CHRONO_DEPENDENCY_DLLS "")
        endif()        
      endif()

      if(Chrono_VSG_REQUESTED AND Chrono_VSG_AVAILABLE)
        list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_vehicle_vsg")
        if (NOT CHRONO_STATIC)
          list(APPEND CHRONO_DLL_NAMES "ChronoEngine_vehicle_vsg.dll")
        endif()
      endif()

      if(Chrono_VEHICLECOSIM_REQUESTED AND Chrono_VEHICLECOSIM_AVAILABLE)
        separate_arguments(MPI_CXX_COMPILE_FLAGS NATIVE_COMMAND "")
        separate_arguments(MPI_CXX_LINK_FLAGS NATIVE_COMMAND "")
        list(APPEND CHRONO_CXX_FLAGS ${MPI_CXX_COMPILE_FLAGS})
        list(APPEND CHRONO_LINKER_FLAGS ${MPI_CXX_LINK_FLAGS})
    
        list(APPEND CHRONO_INCLUDE_DIRS "")
        list(APPEND CHRONO_LIBRARIES "")

        list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_vehicle_cosim")
        if (NOT CHRONO_STATIC)
          list(APPEND CHRONO_DLL_NAMES "ChronoEngine_vehicle_cosim.dll")
        endif()
      endif()

      set(CHRONO_VEHICLE_IRRKLANG )
      set(CHRONO_VEHICLE_OPENCRG )

    elseif(${COMPONENT_UPPER} MATCHES "FSI")

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_fsi")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_fsi.dll")

        # ATTENTION: This is a temporary hack!
        # We only add to the list of DLLs, when we should fully configure the OpenGL and VSG modules.
        # However, full configuration of the OpenGL module leads to problems when using in a C# project (because of FindThreads).
        # This is done only to allow building vehicle C# demos, in case the FSI module was also enabled in Chrono.

        if (Chrono_OPENGL_AVAILABLE)
          list(APPEND CHRONO_DLL_NAMES "ChronoEngine_opengl.dll")
        endif()
        if (Chrono_VSG_AVAILABLE)
          list(APPEND CHRONO_DLL_NAMES "ChronoEngine_vsg.dll")
        endif()
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "SENSOR")

      separate_arguments(CH_SENSOR_CXX_FLAGS NATIVE_COMMAND "")
      separate_arguments(CH_SENSOR_C_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_CXX_FLAGS ${CH_SENSOR_CXX_FLAGS})
      list(APPEND CHRONO_C_FLAGS ${CH_SENSOR_C_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_sensor")
      list(APPEND CHRONO_LIBRARIES "")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_sensor.dll")
      endif()
      #list(APPEND CHRONO_DEPENDENCY_DLLS "")
      list(APPEND CHRONO_DEPENDENCY_DLLS "")
      list(APPEND CHRONO_DEPENDENCY_DLLS "")

    elseif(${COMPONENT_UPPER} MATCHES "SYNCHRONO")

      if()
         set(fastrtps_DIR "")
         find_package(fastrtps REQUIRED)
      endif()

      separate_arguments(MPI_CXX_COMPILE_FLAGS NATIVE_COMMAND "")
      separate_arguments(MPI_CXX_LINK_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_CXX_FLAGS ${MPI_CXX_COMPILE_FLAGS})
      list(APPEND CHRONO_LINKER_FLAGS ${MPI_CXX_LINK_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(APPEND CHRONO_INCLUDE_DIRS "/mingw64/include/chrono_thirdparty/flatbuffers/include")
      list(APPEND CHRONO_LIBRARIES "")
      list(APPEND CHRONO_LIBRARIES "")

      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_synchrono")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_synchrono.dll")
      endif()

      set(CHRONO_SYNCHRONO_FASTDDS )

    elseif(${COMPONENT_UPPER} MATCHES ROS)

      find_package(ROS2 REQUIRED)

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(APPEND CHRONO_LIBRARIES "")

      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_ros")
      list(APPEND CHRONO_DLL_NAMES "ChronoEngine_ros.dll")

    elseif(${COMPONENT_UPPER} MATCHES "GPU")

      separate_arguments(CH_GPU_CXX_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_CXX_FLAGS ${CH_GPU_CXX_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_gpu")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_gpu.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "PARDISOMKL")

      separate_arguments(CH_MKL_LINK_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_LINKER_FLAGS ${CH_MKL_LINK_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "")      
      list(APPEND CHRONO_LIBRARIES "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_pardisomkl")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_pardisomkl.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "MUMPS")

      separate_arguments(CH_MUMPS_LINK_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_LINKER_FLAGS ${CH_MUMPS_LINK_FLAGS})

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_mumps")
      list(APPEND CHRONO_LIBRARIES "")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_mumps.dll")
      endif()
      list(APPEND CHRONO_DEPENDENCY_DLLS "")

    elseif(${COMPONENT_UPPER} MATCHES "POSTPROCESS")

      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_postprocess")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_postprocess.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "CASCADE")

      separate_arguments(OpenCASCADE_CXX_FLAGS NATIVE_COMMAND "")
      separate_arguments(OpenCASCADE_LINKER_FLAGS NATIVE_COMMAND "")
      list(APPEND CHRONO_CXX_FLAGS ${OpenCASCADE_CXX_FLAGS})
      list(APPEND CHRONO_LINKER_FLAGS ${OpenCASCADE_LINKER_FLAGS})
      
      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_cascade")
      list(APPEND CHRONO_LIBRARIES "")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_cascade.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "PARSERS")

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_parsers")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_parsers.dll")
      endif()

      if()
         find_package(urdfdom REQUIRED)
         find_package(urdfdom_headers REQUIRED)
         find_package(console_bridge REQUIRED)
         find_package(tinyxml2 REQUIRED)
         list(APPEND CHRONO_LIBRARIES "urdfdom::urdfdom_model;urdfdom::urdfdom_world;urdfdom::urdfdom_sensor;tinyxml2::tinyxml2")
      endif()

      set(CHRONO_PARSERS_PYTHON )
      set(CHRONO_PARSERS_URDF )

    elseif(${COMPONENT_UPPER} MATCHES "MATLAB")

      list(APPEND CHRONO_INCLUDE_DIRS "")
      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_matlab")
      list(APPEND CHRONO_LIBRARIES "")
      if (NOT CHRONO_STATIC)
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_matlab.dll")
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "CSHARP")

      function(FindDuplicates ret_list list1 list2)
        # Union of list1 and list2
        list(APPEND union ${list1} ${list2})
        list(REMOVE_DUPLICATES union)

        # Difference 1 - 2
        list(APPEND diff_12 ${list1})
        list(REMOVE_ITEM diff_12 ${list2})

        # Difference 2 -1
        list(APPEND diff_21 ${list2})
        list(REMOVE_ITEM diff_21 ${list1})

        # Calculate union of (1-2) and (2-1)
        list(APPEND delta ${diff_12} ${diff_21})
        list(REMOVE_DUPLICATES delta)

        # Calculate the intersection as union-delta
        list(APPEND intersection ${union})
        list(REMOVE_ITEM intersection ${delta})

        set(${ret_list} "${intersection}" PARENT_SCOPE)
      endfunction()

      list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_csharp_core")
      list(APPEND CHRONO_DLL_NAMES "ChronoEngine_csharp_core.dll") # valid also in case of static

      set(CHRONO_CSHARP_SOURCE_DIR "/mingw64/chrono_csharp")
      set(CHRONO_CSHARP_SOURCES "")

      set(Chrono_CSHARP_CORE_DIR "${CHRONO_CSHARP_SOURCE_DIR}/core")
      file(GLOB Chrono_CSHARP_CORE_SOURCES 
           LIST_DIRECTORIES false 
           RELATIVE "${Chrono_CSHARP_CORE_DIR}" 
           CONFIGURE_DEPENDS 
           "${Chrono_CSHARP_CORE_DIR}/*.cs")
      foreach(CS ${Chrono_CSHARP_CORE_SOURCES})
         list(APPEND CHRONO_CSHARP_SOURCES "${Chrono_CSHARP_CORE_DIR}/${CS}")
      endforeach()
      
      if(Chrono_IRRLICHT_REQUESTED AND Chrono_IRRLICHT_AVAILABLE)
        list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_csharp_irrlicht")
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_csharp_irrlicht.dll")

        set(Chrono_CSHARP_IRRLICHT_DIR "${CHRONO_CSHARP_SOURCE_DIR}/irrlicht")
        file(GLOB Chrono_CSHARP_IRRLICHT_SOURCES
             LIST_DIRECTORIES false
             RELATIVE "${Chrono_CSHARP_IRRLICHT_DIR}"
             CONFIGURE_DEPENDS
             "${Chrono_CSHARP_IRRLICHT_DIR}/*.cs")
        FindDuplicates(Chrono_CSHARP_IRRLICHT_DUPLICATES "${Chrono_CSHARP_CORE_SOURCES}"
                                                         "${Chrono_CSHARP_IRRLICHT_SOURCES}")
        list(REMOVE_ITEM Chrono_CSHARP_IRRLICHT_SOURCES ${Chrono_CSHARP_IRRLICHT_DUPLICATES})
        foreach(CS ${Chrono_CSHARP_IRRLICHT_SOURCES})
          list(APPEND CHRONO_CSHARP_SOURCES "${Chrono_CSHARP_IRRLICHT_DIR}/${CS}")
        endforeach()
      endif()

      if(Chrono_VEHICLE_REQUESTED AND Chrono_VEHICLE_AVAILABLE)
        list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_csharp_vehicle")
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_csharp_vehicle.dll")

        set(Chrono_CSHARP_VEHICLE_DIR "${CHRONO_CSHARP_SOURCE_DIR}/vehicle")
        file(GLOB Chrono_CSHARP_VEHICLE_SOURCES
             LIST_DIRECTORIES false
             RELATIVE "${Chrono_CSHARP_VEHICLE_DIR}"
             CONFIGURE_DEPENDS
             "${Chrono_CSHARP_VEHICLE_DIR}/*.cs")
        FindDuplicates(Chrono_CSHARP_VEHICLE_DUPLICATES "${Chrono_CSHARP_CORE_SOURCES}"
                                                        "${Chrono_CSHARP_VEHICLE_SOURCES}")
        list(REMOVE_ITEM Chrono_CSHARP_VEHICLE_SOURCES ${Chrono_CSHARP_VEHICLE_DUPLICATES})
        foreach(CS ${Chrono_CSHARP_VEHICLE_SOURCES})
          list(APPEND CHRONO_CSHARP_SOURCES "${Chrono_CSHARP_VEHICLE_DIR}/${CS}")
        endforeach()
      endif() 

      if(Chrono_POSTPROCESS_REQUESTED AND Chrono_POSTPROCESS_AVAILABLE)
        list(PREPEND CHRONO_LIB_NAMES "ChronoEngine_csharp_postprocess")
        list(APPEND CHRONO_DLL_NAMES "ChronoEngine_csharp_postprocess.dll")

        set(Chrono_CSHARP_POSTPROCESS_DIR "${CHRONO_CSHARP_SOURCE_DIR}/postprocess")
        file(GLOB Chrono_CSHARP_POSTPROCESS_SOURCES 
             LIST_DIRECTORIES false 
             RELATIVE "${Chrono_CSHARP_POSTPROCESS_DIR}" 
             CONFIGURE_DEPENDS 
             "${Chrono_CSHARP_POSTPROCESS_DIR}/*.cs")
        FindDuplicates(Chrono_CSHARP_POSTPROCESS_DUPLICATES "${Chrono_CSHARP_CORE_SOURCES}"
                                                            "${Chrono_CSHARP_POSTPROCESS_SOURCES}")
        list(REMOVE_ITEM Chrono_CSHARP_POSTPROCESS_SOURCES ${Chrono_CSHARP_POSTPROCESS_DUPLICATES})
        foreach(CS ${Chrono_CSHARP_POSTPROCESS_SOURCES})
           list(APPEND CHRONO_CSHARP_SOURCES "${Chrono_CSHARP_POSTPROCESS_DIR}/${CS}")
        endforeach()
      endif()

    elseif(${COMPONENT_UPPER} MATCHES "FMI")

      set(CHRONO_FMU_TOOLS_DIR "")
      list(APPEND CHRONO_INCLUDE_DIRS "")

    endif() # end if-else for component type

  endif() # end check if component available

endforeach()

set(Chrono_FOUND ON)

#-------------------------------------------------------------------------------
# Loop over list of Chrono library names and find the actual libraries.
#-------------------------------------------------------------------------------
get_property(IS_MULTI_CONFIG GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG)
if(NOT CHRONO_CONFIGURATION_TYPES)
  if(IS_MULTI_CONFIG)
    set(CHRONO_CONFIGURATION_TYPES ${CMAKE_CONFIGURATION_TYPES}) # system has multi-config IDE
  else()
    if(CMAKE_BUILD_TYPE)
      set(CHRONO_CONFIGURATION_TYPES "${CMAKE_BUILD_TYPE}")
    else()
      set(CHRONO_CONFIGURATION_TYPES "Release")
    endif()
  endif()
endif()

if(${CMAKE_SYSTEM_NAME} MATCHES "Emscripten")
    set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY NEVER)
endif()

foreach(config ${CHRONO_CONFIGURATION_TYPES})
  string(TOUPPER config config_upper)
  foreach(lib ${CHRONO_LIB_NAMES})
    set(onelib "${lib}-NOTFOUND")
    find_library(onelib ${lib}
      PATHS "/mingw64/lib"
      PATH_SUFFIXES ${config}
      NO_DEFAULT_PATH
    )
    if(NOT onelib)
      list(APPEND CHRONO_MISSING_LIB_CONFIG_${config} ${lib})
    else()
      if(IS_MULTI_CONFIG)
        list(APPEND CHRONO_LIBRARIES_${config} "${onelib}")
      else()
        list(APPEND CHRONO_LIBRARIES "${onelib}")
      endif()
    endif()
  endforeach()
endforeach()

unset(onelib CACHE)


if (IS_MULTI_CONFIG)
  foreach(config ${CHRONO_CONFIGURATION_TYPES})
    # if the given configuration does not have a proper Chrono built library then link to Chrono Release, but only for non-static
    if (CHRONO_MISSING_LIB_CONFIG_${config})
      MESSAGE(STATUS "   Configuration ${config} will not work properly since some Chrono libraries are missing for this configuration:\n      missing: ${CHRONO_MISSING_LIB_CONFIG_${config}}")
    else()
      message(STATUS "   Chrono libraries for configuration ${config} have been successfully found.")
      foreach(onelib ${CHRONO_LIBRARIES_${config}})
        list(APPEND CHRONO_LIBRARIES "$<$<CONFIG:${config}>:${onelib}>")
      endforeach()
    endif()
  endforeach()
else()
  if (CHRONO_MISSING_LIB_CONFIG_Release)
    message(NOTICE "Some Chrono libraries are not installed properly: ${CHRONO_MISSING_LIB_CONFIG_Release}")
  endif()
endif() 

if(${CMAKE_SYSTEM_NAME} MATCHES "Emscripten")
    set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
endif()

# If not on Windows, clear the lists of DLLs
if(NOT ${CMAKE_SYSTEM_NAME} MATCHES "Windows")
  set(CHRONO_DLL_NAMES "")
  set(CHRONO_DEPENDENCY_DLLS "")
endif()

#-------------------------------------------------------------------------------
# Report the exported variables
#-------------------------------------------------------------------------------

message(STATUS "   CHRONO_CXX_FLAGS         (Compiler flags): ${CHRONO_CXX_FLAGS}")
message(STATUS "   CHRONO_C_FLAGS           (Compiler flags): ${CHRONO_C_FLAGS}")
message(STATUS "   CHRONO_LINKER_FLAGS      (Linker flags): ${CHRONO_LINKER_FLAGS}")
message(STATUS "   CHRONO_INCLUDE_DIRS      (Chrono include directories): ${CHRONO_INCLUDE_DIRS}")
message(STATUS "   CHRONO_LIB_NAMES         (Chrono library names): ${CHRONO_LIB_NAMES}")
message(STATUS "   CHRONO_LIBRARIES         (Chrono libraries): ${CHRONO_LIBRARIES}")
message(STATUS "   CHRONO_DATA_DIR          (Path to Chrono data folder): ${CHRONO_DATA_DIR}")
message(STATUS "   CHRONO_VEHICLE_DATA_DIR  (Path to Chrono::Vehicle data folder): ${CHRONO_VEHICLE_DATA_DIR}")
message(STATUS "   CHRONO_FSI_DATA_DIR      (Path to Chrono::FSI data folder): ${CHRONO_FSI_DATA_DIR}")

if(${CMAKE_SYSTEM_NAME} MATCHES "Windows")
  message(STATUS "   CHRONO_DLL_NAMES         (Chrono DLL names): ${CHRONO_DLL_NAMES}")
  message(STATUS "   CHRONO_DEPENDENCY_DLLS   (Dependency DLLs): ${CHRONO_DEPENDENCY_DLLS}")
endif()

#===============================================================================
# Provide a CMake function which adds a custom command (COPY_DLLS), invoked
# pre-build to copy all DLLs specified in the input list to the appropriate
# folder for the current VS configuration.
#
# The input list must contain a list of DLLs with full paths, such as that
# returned by the chrono-config script.
#===============================================================================

# Create custom commands, invoked pre-build to copy DLLs to the appropriate
# directory (depending on the configuration selected at build time in VS)

function(add_DLL_copy_command)

    # Return now if not windows
    if(NOT ${CMAKE_SYSTEM_NAME} MATCHES "Windows")
      return()
    endif()

    message(STATUS "------------------------------------")
    message(STATUS "Add custom commands for copying DLLs")
    message(STATUS "------------------------------------")
    
    if(${ARGC} GREATER 0)
      message(STATUS "DLLs that will be copied (user-provided lists):")
      set(DLL_NAMES ${ARGV0})
      set(DEPENDENCY_DLLS ${ARGV1})
    else()
      message(STATUS "DLLs that will be copied (default lists):")
      set(DLL_NAMES ${CHRONO_DLL_NAMES})
      set(DEPENDENCY_DLLS ${CHRONO_DEPENDENCY_DLLS})
    endif()

    get_property(IS_MULTI_CONFIG GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG)
    if(NOT CHRONO_CONFIGURATION_TYPES)
      if(IS_MULTI_CONFIG)
        set(CHRONO_CONFIGURATION_TYPES ${CMAKE_CONFIGURATION_TYPES}) # system has multi-config IDE
      else()
        if(CMAKE_BUILD_TYPE)
          set(CHRONO_CONFIGURATION_TYPES "${CMAKE_BUILD_TYPE}")
        else()
          set(CHRONO_CONFIGURATION_TYPES "Release")
        endif()
      endif()
    endif()

    # Remove duplicates in lists
    list(REMOVE_DUPLICATES DLL_NAMES)
    list(REMOVE_DUPLICATES DEPENDENCY_DLLS)

    # Find actual Chrono DLLs
    foreach(config ${CHRONO_CONFIGURATION_TYPES})
      unset(DLLS_${config})
      unset(DLL_MISSING_${config})
    endforeach()

    foreach(dep_dll ${DEPENDENCY_DLLS})
      message(STATUS "...${dep_dll}")
    endforeach()

    foreach(config ${CHRONO_CONFIGURATION_TYPES}) 
      foreach(dll ${DLL_NAMES})
        set(onedll "${dll}-NOTFOUND")
        find_file(onedll ${dll}
          PATHS "/mingw64/bin"
          PATH_SUFFIXES "${config}"
          NO_DEFAULT_PATH
        )
        if(NOT onedll)
          list(APPEND DLL_MISSING_${config} ${dll})
          # message("DLL '${dll}' in package Chrono is not installed properly")
        else()
          list(APPEND DLLS_${config} "${onedll}")
          # message(STATUS "...${DLL}")
        endif()
      endforeach()
    endforeach()  
    unset(onedll CACHE)
    
    # # if a given configuration is missing then the Release DLLs will be used as rollback for that given config
    # foreach(config ${CHRONO_CONFIGURATION_TYPES})
    #   if (DLL_MISSING_${config} AND NOT DLL_MISSING_Release)
    #     set(DLLS_${config} ${DLLS_Release})
    #   endif()
    # endforeach()

    # Create custom target for copying DLLs; add it to the default build target
    add_custom_target(COPY_DLLS ALL)

    # Grab the folder in which the given configuration will generate the files
    # this is not a per-target folder, but it assumed a commond folder for all the runtime artifacts for the entire project
    # unless otherwise specified through the CMAKE_RUNTIME_OUTPUT_DIRECTORY and CMAKE_RUNTIME_OUTPUT_DIRECTORY_<CONFIG> variables
    foreach(config ${CHRONO_CONFIGURATION_TYPES})
      string(TOUPPER ${config} config_upper)
      if(CMAKE_RUNTIME_OUTPUT_DIRECTORY_${config_upper})
        set(TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper} "${CMAKE_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}")
      else()
        if(CMAKE_RUNTIME_OUTPUT_DIRECTORY)
          set(TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper} "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/${config}/")
        else()
          set(TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper} "${PROJECT_BINARY_DIR}/${config}/")
        endif()
      endif()

      # Add custom command to create the destination folder
      add_custom_command(
        TARGET COPY_DLLS PRE_BUILD
        COMMENT "Creating DLL output directory ${TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}\n"
        COMMAND "$<$<CONFIG:${config}>:${CMAKE_COMMAND}>"
            "$<$<CONFIG:${config}>:-E>"
            "$<$<CONFIG:${config}>:make_directory>"
            "$<$<CONFIG:${config}>:${TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}>"
      )
    endforeach()

    # Add custom command for each Chrono DLL
    foreach(config ${CHRONO_CONFIGURATION_TYPES})
      string(TOUPPER ${config} config_upper)

      # copy Chrono DLLs in configuration-specific folder
      foreach(DLL ${DLLS_${config}})
          add_custom_command(
              TARGET COPY_DLLS POST_BUILD
              COMMENT "Copying Chrono DLL ${DLL} in ${TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}\n"  
              COMMAND "$<$<CONFIG:${config}>:${CMAKE_COMMAND}>"
                  "$<$<CONFIG:${config}>:-E>"
                  "$<$<CONFIG:${config}>:copy_if_different>"
                  "$<$<CONFIG:${config}>:${DLL}>"
                  "$<$<CONFIG:${config}>:${TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}>"
          )
          message(STATUS "...${DLL}")
      endforeach()

      # copy dependecies DLLs in configuration-specific folder
      foreach(DLL ${DEPENDENCY_DLLS})
          add_custom_command(
              TARGET COPY_DLLS POST_BUILD
              COMMENT "Copying DLL dependency ${DLL} in ${TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}\n"
              COMMAND "$<$<CONFIG:${config}>:${CMAKE_COMMAND}>"
              "$<$<CONFIG:${config}>:-E>"
              "$<$<CONFIG:${config}>:copy_if_different>"
              "$<$<CONFIG:${config}>:${DLL}>"
              "$<$<CONFIG:${config}>:${TEMP_RUNTIME_OUTPUT_DIRECTORY_${config_upper}}>"
          )
      endforeach()


    endforeach()
    unset(TEMP_RUNTIME_OUTPUT_DIRECTORY_CONFIG)
    unset(config_upper)

endfunction()
