#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldcreatedswithdg_ DMFIELDCREATEDSWITHDG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldcreatedswithdg_ dmfieldcreatedswithdg
#endif
PETSC_EXTERN void dmfieldcreatedswithdg_(DM *a, DM *b, PetscInt *c, Vec *d, Vec *e, DMField *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMFieldCreateDSWithDG(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldcreateds_ DMFIELDCREATEDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldcreateds_ dmfieldcreateds
#endif
PETSC_EXTERN void dmfieldcreateds_(DM *a, PetscInt *b, Vec *c, DMField *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMFieldCreateDS(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
