#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelmvmsymbadbroyden_ MATCREATELMVMSYMBADBROYDEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelmvmsymbadbroyden_ matcreatelmvmsymbadbroyden
#endif
PETSC_EXTERN void matcreatelmvmsymbadbroyden_(MPI_Fint *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateLMVMSymBadBroyden(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
