#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetperiodicity_ DMSETPERIODICITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetperiodicity_ dmsetperiodicity
#endif
PETSC_EXTERN void dmsetperiodicity_(DM *a, const PetscReal b[], const PetscReal c[], const PetscReal d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = DMSetPeriodicity(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocalizecoordinate_ DMLOCALIZECOORDINATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocalizecoordinate_ dmlocalizecoordinate
#endif
PETSC_EXTERN void dmlocalizecoordinate_(DM *a, const PetscScalar b[], PetscBool *c, PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(d);
  *ierr = DMLocalizeCoordinate(*a, b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinateslocalizedlocal_ DMGETCOORDINATESLOCALIZEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinateslocalizedlocal_ dmgetcoordinateslocalizedlocal
#endif
PETSC_EXTERN void dmgetcoordinateslocalizedlocal_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMGetCoordinatesLocalizedLocal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinateslocalized_ DMGETCOORDINATESLOCALIZED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinateslocalized_ dmgetcoordinateslocalized
#endif
PETSC_EXTERN void dmgetcoordinateslocalized_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMGetCoordinatesLocalized(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetsparselocalize_ DMGETSPARSELOCALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetsparselocalize_ dmgetsparselocalize
#endif
PETSC_EXTERN void dmgetsparselocalize_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMGetSparseLocalize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetsparselocalize_ DMSETSPARSELOCALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetsparselocalize_ dmsetsparselocalize
#endif
PETSC_EXTERN void dmsetsparselocalize_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMSetSparseLocalize(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocalizecoordinates_ DMLOCALIZECOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocalizecoordinates_ dmlocalizecoordinates
#endif
PETSC_EXTERN void dmlocalizecoordinates_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMLocalizeCoordinates(*a);
  if (*ierr) return;
}
