#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmultiblocksetfields_ SNESMULTIBLOCKSETFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmultiblocksetfields_ snesmultiblocksetfields
#endif
PETSC_EXTERN void snesmultiblocksetfields_(SNES *a, char b[], PetscInt *c, const PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  *ierr = SNESMultiblockSetFields(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmultiblocksetis_ SNESMULTIBLOCKSETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmultiblocksetis_ snesmultiblocksetis
#endif
PETSC_EXTERN void snesmultiblocksetis_(SNES *a, char b[], IS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = SNESMultiblockSetIS(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmultiblocksettype_ SNESMULTIBLOCKSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmultiblocksettype_ snesmultiblocksettype
#endif
PETSC_EXTERN void snesmultiblocksettype_(SNES *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = SNESMultiblockSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmultiblocksetblocksize_ SNESMULTIBLOCKSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmultiblocksetblocksize_ snesmultiblocksetblocksize
#endif
PETSC_EXTERN void snesmultiblocksetblocksize_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESMultiblockSetBlockSize(*a, *b);
  if (*ierr) return;
}
