#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgettmp_ PETSCGETTMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgettmp_ petscgettmp
#endif
PETSC_EXTERN void petscgettmp_(MPI_Fint *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  *ierr = PetscGetTmp(MPI_Comm_f2c(*(a)), b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsharedtmp_ PETSCSHAREDTMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsharedtmp_ petscsharedtmp
#endif
PETSC_EXTERN void petscsharedtmp_(MPI_Fint *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSharedTmp(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsharedworkingdirectory_ PETSCSHAREDWORKINGDIRECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsharedworkingdirectory_ petscsharedworkingdirectory
#endif
PETSC_EXTERN void petscsharedworkingdirectory_(MPI_Fint *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSharedWorkingDirectory(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfileretrieve_ PETSCFILERETRIEVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfileretrieve_ petscfileretrieve
#endif
PETSC_EXTERN void petscfileretrieve_(MPI_Fint *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscFileRetrieve(MPI_Comm_f2c(*(a)), c_b, c, l_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
