#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawstring_ PETSCDRAWSTRING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawstring_ petscdrawstring
#endif
PETSC_EXTERN void petscdrawstring_(PetscDraw *a, PetscReal *b, PetscReal *c, int *d, char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscDrawString(*a, *b, *c, *d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawstringvertical_ PETSCDRAWSTRINGVERTICAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawstringvertical_ petscdrawstringvertical
#endif
PETSC_EXTERN void petscdrawstringvertical_(PetscDraw *a, PetscReal *b, PetscReal *c, int *d, char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscDrawStringVertical(*a, *b, *c, *d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawstringcentered_ PETSCDRAWSTRINGCENTERED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawstringcentered_ petscdrawstringcentered
#endif
PETSC_EXTERN void petscdrawstringcentered_(PetscDraw *a, PetscReal *b, PetscReal *c, int *d, char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscDrawStringCentered(*a, *b, *c, *d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawstringboxed_ PETSCDRAWSTRINGBOXED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawstringboxed_ petscdrawstringboxed
#endif
PETSC_EXTERN void petscdrawstringboxed_(PetscDraw *a, PetscReal *b, PetscReal *c, int *d, int *e, char f[], PetscReal *g, PetscReal *h, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_f)
{
  char* c_f;
  FIXCHAR(f, l_f, c_f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  *ierr = PetscDrawStringBoxed(*a, *b, *c, *d, *e, c_f, g, h);
  if (*ierr) return;
  FREECHAR(f, c_f);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawstringsetsize_ PETSCDRAWSTRINGSETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawstringsetsize_ petscdrawstringsetsize
#endif
PETSC_EXTERN void petscdrawstringsetsize_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawStringSetSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawstringgetsize_ PETSCDRAWSTRINGGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawstringgetsize_ petscdrawstringgetsize
#endif
PETSC_EXTERN void petscdrawstringgetsize_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscDrawStringGetSize(*a, b, c);
  if (*ierr) return;
}
