#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningpartysetglobal_ MATPARTITIONINGPARTYSETGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningpartysetglobal_ matpartitioningpartysetglobal
#endif
PETSC_EXTERN void matpartitioningpartysetglobal_(MatPartitioning *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatPartitioningPartySetGlobal(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningpartysetlocal_ MATPARTITIONINGPARTYSETLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningpartysetlocal_ matpartitioningpartysetlocal
#endif
PETSC_EXTERN void matpartitioningpartysetlocal_(MatPartitioning *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatPartitioningPartySetLocal(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningpartysetcoarselevel_ MATPARTITIONINGPARTYSETCOARSELEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningpartysetcoarselevel_ matpartitioningpartysetcoarselevel
#endif
PETSC_EXTERN void matpartitioningpartysetcoarselevel_(MatPartitioning *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningPartySetCoarseLevel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningpartysetmatchoptimization_ MATPARTITIONINGPARTYSETMATCHOPTIMIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningpartysetmatchoptimization_ matpartitioningpartysetmatchoptimization
#endif
PETSC_EXTERN void matpartitioningpartysetmatchoptimization_(MatPartitioning *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningPartySetMatchOptimization(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningpartysetbipart_ MATPARTITIONINGPARTYSETBIPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningpartysetbipart_ matpartitioningpartysetbipart
#endif
PETSC_EXTERN void matpartitioningpartysetbipart_(MatPartitioning *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningPartySetBipart(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
