#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreatevector_ DMMOABCREATEVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreatevector_ dmmoabcreatevector
#endif
PETSC_EXTERN void dmmoabcreatevector_(DM *a, moab::Tag *b, const moab::Range *c, PetscBool *d, PetscBool *e, Vec *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMMoabCreateVector(*a, *b, c, *d ? PETSC_TRUE : PETSC_FALSE, *e ? PETSC_TRUE : PETSC_FALSE, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetvectag_ DMMOABGETVECTAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetvectag_ dmmoabgetvectag
#endif
PETSC_EXTERN void dmmoabgetvectag_(Vec *a, moab::Tag *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabGetVecTag(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetvecrange_ DMMOABGETVECRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetvecrange_ dmmoabgetvecrange
#endif
PETSC_EXTERN void dmmoabgetvecrange_(Vec *a, moab::Range *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabGetVecRange(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabvecgetarray_ DMMOABVECGETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabvecgetarray_ dmmoabvecgetarray
#endif
PETSC_EXTERN void dmmoabvecgetarray_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMMoabVecGetArray(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabvecrestorearray_ DMMOABVECRESTOREARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabvecrestorearray_ dmmoabvecrestorearray
#endif
PETSC_EXTERN void dmmoabvecrestorearray_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMMoabVecRestoreArray(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabvecgetarrayread_ DMMOABVECGETARRAYREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabvecgetarrayread_ dmmoabvecgetarrayread
#endif
PETSC_EXTERN void dmmoabvecgetarrayread_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMMoabVecGetArrayRead(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabvecrestorearrayread_ DMMOABVECRESTOREARRAYREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabvecrestorearrayread_ dmmoabvecrestorearrayread
#endif
PETSC_EXTERN void dmmoabvecrestorearrayread_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMMoabVecRestoreArrayRead(*a, *b, c);
  if (*ierr) return;
}
