#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfsetgraphfromcoordinates_ PETSCSFSETGRAPHFROMCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfsetgraphfromcoordinates_ petscsfsetgraphfromcoordinates
#endif
PETSC_EXTERN void petscsfsetgraphfromcoordinates_(PetscSF *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscReal *e, const PetscReal *f, const PetscReal *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = PetscSFSetGraphFromCoordinates(*a, *b, *c, *d, *e, f, g);
  if (*ierr) return;
}
