#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pclmvmsetupdatevec_ PCLMVMSETUPDATEVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pclmvmsetupdatevec_ pclmvmsetupdatevec
#endif
PETSC_EXTERN void pclmvmsetupdatevec_(PC *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = PCLMVMSetUpdateVec(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pclmvmsetmatlmvm_ PCLMVMSETMATLMVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pclmvmsetmatlmvm_ pclmvmsetmatlmvm
#endif
PETSC_EXTERN void pclmvmsetmatlmvm_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCLMVMSetMatLMVM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pclmvmgetmatlmvm_ PCLMVMGETMATLMVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pclmvmgetmatlmvm_ pclmvmgetmatlmvm
#endif
PETSC_EXTERN void pclmvmgetmatlmvm_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCLMVMGetMatLMVM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pclmvmsetis_ PCLMVMSETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pclmvmsetis_ pclmvmsetis
#endif
PETSC_EXTERN void pclmvmsetis_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCLMVMSetIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pclmvmclearis_ PCLMVMCLEARIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pclmvmclearis_ pclmvmclearis
#endif
PETSC_EXTERN void pclmvmclearis_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCLMVMClearIS(*a);
  if (*ierr) return;
}
