"""

 @file enum.py

 PaStiX python wrapper to define enums and datatypes

 @copyright 2017-2023 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
                      Univ. Bordeaux. All rights reserved.

 @version 6.3.2
 @author Pierre Ramet
 @author Mathieu Faverge
 @author Tony Delarue
 @author Selmane Lebdaoui
 @author Alycia Lisito
 @author Esragul Korkmaz
 @author Tom Moenne-Loccoz
 @date 2023-11-10

 This file has been automatically generated with gen_wrappers.py

 @ingroup wrap_python

"""
from ctypes import *
import numpy as np

# Start with __ to prevent broadcast to file importing enum
__pastix_int__ = c_int
__pastix_mpi_enabled__ = 0

class iparm:
    verbose                        = 0
    io_strategy                    = 1
    nnzeros                        = 2
    nnzeros_block_local            = 3
    allocated_terms                = 4
    produce_stats                  = 5
    trace                          = 6
    mc64                           = 7
    ordering                       = 8
    ordering_default               = 9
    scotch_mt                      = 10
    scotch_switch_level            = 11
    scotch_cmin                    = 12
    scotch_cmax                    = 13
    scotch_frat                    = 14
    metis_ctype                    = 15
    metis_rtype                    = 16
    metis_no2hop                   = 17
    metis_nseps                    = 18
    metis_niter                    = 19
    metis_ufactor                  = 20
    metis_compress                 = 21
    metis_ccorder                  = 22
    metis_pfactor                  = 23
    metis_seed                     = 24
    metis_dbglvl                   = 25
    amalgamation_lvlblas           = 26
    amalgamation_lvlcblk           = 27
    reordering_split               = 28
    reordering_stop                = 29
    splitting_strategy             = 30
    splitting_levels_projections   = 31
    splitting_levels_kway          = 32
    splitting_projections_depth    = 33
    splitting_projections_distance = 34
    splitting_projections_width    = 35
    min_blocksize                  = 36
    max_blocksize                  = 37
    tasks2d_level                  = 38
    tasks2d_width                  = 39
    allcand                        = 40
    incomplete                     = 41
    level_of_fill                  = 42
    factorization                  = 43
    facto_look_side                = 44
    static_pivoting                = 45
    free_cscuser                   = 46
    schur_fact_mode                = 47
    transpose_solve                = 48
    schur_solv_mode                = 49
    applyperm_ws                   = 50
    refinement                     = 51
    nbiter                         = 52
    itermax                        = 53
    gmres_im                       = 54
    scheduler                      = 55
    thread_nbr                     = 56
    socket_nbr                     = 57
    autosplit_comm                 = 58
    gpu_nbr                        = 59
    gpu_memory_percentage          = 60
    gpu_memory_block_size          = 61
    global_allocation              = 62
    compress_min_width             = 63
    compress_min_height            = 64
    compress_when                  = 65
    compress_method                = 66
    compress_ortho                 = 67
    compress_reltol                = 68
    compress_preselect             = 69
    compress_iluk                  = 70
    mixed                          = 71
    ftz                            = 72
    mpi_thread_level               = 73
    modify_parameter               = 74
    start_task                     = 75
    end_task                       = 76
    float                          = 77
    mtx_type                       = 78
    dof_nbr                        = 79
    size                           = 80

class dparm:
    fill_in            = 0
    epsilon_refinement = 1
    relative_error     = 2
    epsilon_magn_ctrl  = 3
    order_time         = 4
    symbfact_time      = 5
    reorder_time       = 6
    blend_time         = 7
    analyze_time       = 8
    pred_fact_time     = 9
    fact_time          = 10
    fact_flops         = 11
    fact_thflops       = 12
    fact_rlflops       = 13
    fact_energy        = 14
    mem_fr             = 15
    mem_lr             = 16
    solv_time          = 17
    solv_flops         = 18
    solv_thflops       = 19
    solv_rlflops       = 20
    solv_energy        = 21
    refine_time        = 22
    a_norm             = 23
    compress_tolerance = 24
    compress_min_ratio = 25
    size               = 26

class task:
    Init     = 0
    Ordering = 1
    Symbfact = 2
    Analyze  = 3
    Numfact  = 4
    Solve    = 5
    Refine   = 6
    Clean    = 7

class trace:
    Not          = 0
    Numfact      = 16
    Solve        = 32
    FactAndSolve = 48

class verbose:
    Not = 0
    No  = 1
    Yes = 2

class io:
    No        = 0
    Load      = 1
    Save      = 2
    LoadGraph = 4
    SaveGraph = 8
    LoadCSC   = 16
    SaveCSC   = 32

class fact_mode:
    Local = 0
    Schur = 1
    Both  = 2

class solv_mode:
    Local     = 0
    Interface = 1
    Schur     = 2

class refine:
    GMRES    = 0
    CG       = 1
    SR       = 2
    BiCGSTAB = 3

class factotype:
    POTRF = 0
    SYTRF = 1
    GETRF = 2
    PXTRF = 3
    HETRF = 4
    LLH   = 0
    LDLT  = 1
    LU    = 2
    LLT   = 3
    LDLH  = 4

class factolookside:
    FactLeftLooking  = 0
    FactRightLooking = 1

class scheduler:
    Sequential = 0
    Static     = 1
    Parsec     = 2
    StarPU     = 3
    Dynamic    = 4

class ordering:
    Scotch   = 0
    Metis    = 1
    Personal = 2
    PtScotch = 3
    ParMetis = 4

class mpithreadmode:
    MpiNone             = 0
    MpiThreadSingle     = 1
    MpiThreadFunneled   = 2
    MpiThreadSerialized = 3
    MpiThreadMultiple   = 4

class error:
    SUCCESS        = 0
    UNKNOWN        = 1
    ALLOC          = 2
    NOTIMPLEMENTED = 3
    OUTOFMEMORY    = 4
    THREAD         = 5
    INTERNAL       = 6
    BADPARAMETER   = 7
    FILE           = 8
    INTEGER_TYPE   = 9
    IO             = 10
    MPI            = 11

class compress_when:
    Never  = 0
    Begin  = 1
    End    = 2
    During = 3

class compress_method:
    SVD   = 0
    PQRCP = 1
    RQRCP = 2
    TQRCP = 3
    RQRRT = 4
    Nbr   = 5

class compress_ortho:
    OrthoCGS       = 0
    OrthoQR        = 1
    OrthoPartialQR = 2

class split:
    Not             = 0
    Kway            = 1
    KwayProjections = 2

class layout:
    RowMajor = 101
    ColMajor = 102

class trans:
    NoTrans   = 111
    Trans     = 112
    ConjTrans = 113

class uplo:
    Upper      = 121
    Lower      = 122
    UpperLower = 123

class coefside:
    LCoef  = 0
    UCoef  = 1
    LUCoef = 2

class diag:
    NonUnit = 131
    Unit    = 132

class side:
    Left  = 141
    Right = 142

class normtype:
    One       = 171
    Frobenius = 174
    Inf       = 175
    Max       = 177

class dir:
    Forward  = 391
    Backward = 392

class mtxtype:
    General   = trans.NoTrans
    Symmetric = trans.Trans
    Hermitian = trans.ConjTrans
    SymPosDef = trans.ConjTrans + 1
    HerPosDef = trans.ConjTrans + 2

