%feature("docstring") OT::NormalCopula
"Normal copula.

Available constructor:
    NormalCopula(*n*)

    NormalCopula(*R*)

Parameters
----------
n : int, :math:`n \\geq 1`
    Dimension of the copula.
    
    Default value is 2.
R : :class:`~openturns.CorrelationMatrix`
    Shape matrix :math:`\\mat{R}` of the copula, ie the correlation matrix of
    any normal distribution with this copula (it is not the Kendall nor the
    Spearman rank correlation matrix of the distribution).
    
    Default value is the identity matrix.

Notes
-----
The Normal copula is defined by :

.. math::

    C(u_1, \\cdots, u_n) = \\Phi_{\\mat{R}}^n(\\Phi^{-1}(u_1), \\cdots, \\Phi^{-1}(u_n))

where :math:`\\Phi_{\\mat{R}}^n` is the cumulative distribution function of the
normal distribution with zero mean, unit marginal variances and correlation :math:`R`:

.. math::

    \\Phi_{\\mat{R}}^n(\\vect{x}) = \\int_{-\\infty}^{x_1} \\ldots
                                   \\int_{-\\infty}^{x_n}
                                   \\frac{1}
                                        {{(2\\pi\\det{\\mat{R}})}^{\\frac{n}{2}}}
                                 \\exp \\left(-\\frac{\\Tr{\\vect{u}}\\mat{R}\\vect{u}}{2} \\right)\\di{\\vect{u}}

with :math:`\\Phi` given by:

.. math::

      \\Phi(x) = \\int_{-\\infty}^x \\frac{1}{\\sqrt{2\\pi}} e^{-\\frac{t^2}{2}}\\di{t}

The correlation matrix :math:`\\mat{R}` is linked to the Spearman correlation
and the Kendall concordance through the following relations:      

- From the Spearman correlation matrix:

  .. math ::

      \\mat{R}_{ij} = 2 \\sin \\left( \\frac{\\pi}{6}\\rho_{ij}^S \\right)

  where :math:`\\rho_{ij}^S = \\rho^S(X_i,X_j) = \\rho^P(F_{X_i}(X_i),F_{X_j}(X_j))`

- From the Kendall concordance matrix:

  .. math::

      \\mat{R}_{ij} = \\sin \\left( \\frac{\\pi}{2} \\tau_{ij} \\right)

  with

  .. math::

      \\tau_{ij} = \\tau(X_i,X_j)
                = \\Prob{(X_{i_1} - X_{i_2})(X_{j_1} - X_{j_2}) > 0} -
                  \\Prob{(X_{i_1} - X_{i_2})(X_{j_1} - X_{j_2}) < 0}

  where :math:`(X_{i_1},X_{j_1}` and :math:`(X_{i_2},X_{j_2})` follow the
  distribution of :math:`(X_i,X_j)`.

See also
--------
Distribution

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> R = ot.CorrelationMatrix(3)
>>> R[0, 1] = 0.25
>>> R[1, 2] = 0.25
>>> copula = ot.NormalCopula(R)

Draw a sample:

>>> sample = copula.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::NormalCopula::GetCorrelationFromKendallCorrelation
"Get the correlation matrix from the Kendall correlation matrix.

Parameters
----------
K : :class:`~openturns.CorrelationMatrix`
    Kendall correlation matrix of the considered random vector.

Returns
-------
R : :class:`~openturns.CorrelationMatrix`
    Correlation matrix :math:`\\mat{R}` of the normal copula evaluated from
    the Kendall correlation matrix :math:`K`."

// ---------------------------------------------------------------------

%feature("docstring") OT::NormalCopula::GetCorrelationFromSpearmanCorrelation
"Get the correlation matrix from the Spearman correlation matrix.

Parameters
----------
S : :class:`~openturns.CorrelationMatrix`
    Spearman correlation matrix :math:`S` of the considered random vector.

Returns
-------
R : :class:`~openturns.CorrelationMatrix`
    Correlation matrix :math:`\\mat{R}` of the normal copula evaluated from
    the Spearman correlation matrix :math:`S`."

