%feature("docstring") OT::PolyaFactory
"Negative Binomial factory.

Notes
-----
We use the following estimator:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      data : (\\vect{x}^1, \\hdots,\\vect{x}^n)\\\\
      \\displaystyle  \\hat{p}_n = \\frac{\\bar{x}_n}{\\hat{r}_n+\\bar{x}_n} \\\\
      \\displaystyle  \\hat{r}_n\\mbox{ solution of } n\\left(\\log\\left(\\frac{\\hat{r}_n}{\\hat{r}_n+\\bar{x}_n}\\right)-\\psi(\\hat{r}_n)\\right)+\\sum_{i=1}^n\\psi(x^i+\\hat{r}_n)=0\\\\
      \\mbox{The resolution is done using Brent's method.}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Polya"


// ---------------------------------------------------------------------

%feature("docstring") OT::PolyaFactory::buildAsPolya
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsPolya()

    buildAsPolya(*sample*)

    buildAsPolya(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
   The parameters of the :class:`~openturns.Polya`.

Returns
-------
distribution : :class:`~openturns.Polya`
    The estimated distribution as a Polya.
    
    In the first usage, the default Polya distribution is built."

