%feature("docstring") OT::Polygon
"Polygon.

Available constructors:
    Polygon(*legend=' '*)

    Polygon(*data, legend=' '*)

    Polygon(*dataX, dataY, legend=' '*)

    Polygon(*data, color, edgeColor, legend=' '*)

Parameters
----------
data : 2-d sequence of float of dimension 2
    Vertices of the polygon.
dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
    List of the first and second coordinates of the vertices.
legend : str
    Legend of the polygon.
color, edgeColor : two str
    Fill color and the edge color. If not specified, the default color is the first color in the default palette.

Examples
--------
>>> import openturns as ot
>>> # Generate the data for the polygons to be drawn
>>> data =[[9.0*i/51, (9.0*i/51)*(9.0*i/51)] for i in range(50)]
>>> # Create an empty graph
>>> graph = ot.Graph('Polygon example', 'x1', 'x2', True, '', 1.0)
>>> polygon = ot.Polygon(data)
>>> polygon.setColor('red')
>>> graph.add(polygon)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Polygon::setEdgeColor
"Set the color of the Polygon edge.

Parameters
----------
edgeColor : str
    Color of the edge of the :class:`~openturns.Polygon`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Polygon::FillBetween
"Fill an area between two curves.

Parameters
----------
dataX : 2-d sequence of float of dimension 1, or sequence of float
    First coordinates common to the curves.
dataY1 : 2-d sequence of float of dimension 1, or sequence of float
    Second coordinates of the first curve.
dataY2 : 2-d sequence of float of dimension 1, or sequence of float
    Second coordinates of the second curve.

Returns
-------
polygon : :class:`~openturns.Polygon`
    Polygon which fills the surface between the two curves.

Examples
--------
>>> import openturns as ot
>>> from math import pi, sin
>>> # Generate the data for the curve to be drawn
>>> data = [[-3 * pi + 6 * pi * i / 100, sin(-3 * pi + 6 * pi * i / 100)] for i in range(100)]
>>> # Create the curve
>>> curve = ot.Curve(data, 'blue', 'solid', 2, '')
>>> # Create the polygon to fill between the curve and the x-axis
>>> x = [xy[0] for xy in data]
>>> y = [xy[1] for xy in data]
>>> polygon = ot.Polygon.FillBetween(x, y, [0.] * len(data))
>>> # Create an empty graph
>>> graph = ot.Graph('A filled curve', 'x', 'sin(x)', True, '')
>>> # Add drawables into the graph
>>> graph.add(curve)
>>> graph.add(polygon)"
