# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Distribution special function."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _DistFunc
else:
    import _DistFunc

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _DistFunc.delete_SwigPyIterator

    def value(self):
        return _DistFunc.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _DistFunc.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _DistFunc.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _DistFunc.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _DistFunc.SwigPyIterator_equal(self, x)

    def copy(self):
        return _DistFunc.SwigPyIterator_copy(self)

    def next(self):
        return _DistFunc.SwigPyIterator_next(self)

    def __next__(self):
        return _DistFunc.SwigPyIterator___next__(self)

    def previous(self):
        return _DistFunc.SwigPyIterator_previous(self)

    def advance(self, n):
        return _DistFunc.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _DistFunc.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _DistFunc.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _DistFunc.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _DistFunc.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _DistFunc.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _DistFunc.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _DistFunc:
_DistFunc.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo

def pBeta(p1, p2, x, tail=False):
    r"""
    Cumulative distribution function  of a Beta distribution on :math:`[0,1]`.

    Parameters
    ----------
    alpha : float, :math:`\alpha > 0`
        Parameter :math:`\alpha`.
    beta : float, :math:`\beta > 0`
        Parameter :math:`\beta`.
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at :math:`x`.

    Notes
    -----
    The probability density function is defined as:

    .. math::
        p(x) = \dfrac{1}{B(\alpha, \beta)}x^{(\alpha-1)}(1-x)^{(\beta-1)} \quad x \in [0,1]

    with :math:`\alpha, \beta > 0` and where :math:`\rm B` denotes
    Euler's beta function :meth:`~openturns.SpecFunc.Beta`.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pBeta(2.5, 3.5, 0.9)
    """
    return _DistFunc.pBeta(p1, p2, x, tail)

def qBeta(p1, p2, p, tail=False):
    r"""
    Quantile of a Beta distribution on :math:`[0,1]`.

    Parameters
    ----------
    alpha : float, :math:`\alpha > 0`
        Parameter :math:`\alpha`.
    beta : float, :math:`\beta > 0`
        Parameter :math:`\beta`.
    p : float, in :math:`[0,1]`
        The probability.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----
    The probability density function is defined as:

    .. math::
        p(x) = \dfrac{1}{B(\alpha, \beta)}x^{(\alpha-1)}(1-x)^{(\beta-1)} \quad x \in [0,1]

    with :math:`\alpha, \beta > 0` and where :math:`\rm B` denotes
    Euler's beta function :meth:`~openturns.SpecFunc.Beta`.

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qBeta(2.5, 3.5, 0.95)
    >>> q = ot.DistFunc.qBeta(2.5, 3.5, 0.95, True)
    """
    return _DistFunc.qBeta(p1, p2, p, tail)

def rBeta(*args):
    r"""
    Realization of a Beta distribution on :math:`[0,1]`.

    Parameters
    ----------
    alpha : float, :math:`\alpha > 0`
        Parameter :math:`\alpha`.
    beta : float, :math:`\beta > 0`
        Parameter :math:`\beta`.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the  distribution.

    Notes
    -----
    The probability density function is defined as:

    .. math::
        p(x) = \dfrac{1}{B(\alpha, \beta)}x^{(\alpha-1)}(1-x)^{(\beta-1)} \quad x \in [0,1]

    with :math:`\alpha, \beta > 0` and where :math:`\rm B` denotes
    Euler's beta function :meth:`~openturns.SpecFunc.Beta`.

    This method is based on Cheng's algorithm (1978) and Johnk, Atkinson and Whittaker's algorithm (1979)
    described in [devroye1986]_ with the important errata [devroye1986b]_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rBeta(2.5, 3.5)
    """
    return _DistFunc.rBeta(*args)

def logdBinomial(n, p, k):
    r"""
    Logarithm of the probability distribution function of a binomial distribution.

    Parameters
    ----------
    n : int, :math:`n>0`
        The number of trials.
    p : float, :math:`0\leq p\leq 1`
        The success probability of each trial.
    k : int
        The number of success.

    Returns
    -------
    logp : float
        The natural logarithm of the probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.logdBinomial(5, 0.2, 2)
    """
    return _DistFunc.logdBinomial(n, p, k)

def dBinomial(n, p, k):
    r"""
    probability distribution function of a binomial distribution.

    Parameters
    ----------
    n : int, :math:`n>0`
        The number of trials.
    p : float, :math:`0\leq p\leq 1`
        The success probability of each trial.
    k : int
        The number of success.

    Returns
    -------
    probability : float
        The probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.dBinomial(5, 0.2, 2)
    """
    return _DistFunc.dBinomial(n, p, k)

def rBinomial(*args):
    r"""
    Realization of a binomial distribution.

    Parameters
    ----------
    n : int, :math:`n>0`
        The number of trials.
    p : float, :math:`0\leq p\leq 1`
        The success probability of each trial.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the distribution.

    Notes
    -----
    This method implements the rejection algorithm described in [hormann1993]_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rBinomial(5, 0.3)
    >>> r = ot.DistFunc.rBinomial(5, 0.3, 10)
    """
    return _DistFunc.rBinomial(*args)

def rDiscrete(*args):
    r"""
    Realization of a bounded integral discrete distribution.

    Parameters
    ----------
    probabilities : sequence of float, :math:`(p_1, \dots, p_n)\in[0,1]` with :math:`\sum_{k=1}^n p_k=1`,
        The probabilities of the discrete distribution.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the distribution.

    Notes
    -----
    This method implements the *alias* method as described in [devroye1986]_,
    Chapter 3. It has an optimal space complexity of :math:`\cO(n)` and runtime CPU
    complexity of :math:`\cO(1)`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rDiscrete([0.2, 0.3, 0.5])
    >>> r = ot.DistFunc.rDiscrete([0.2, 0.3, 0.5], 10)
    """
    return _DistFunc.rDiscrete(*args)

def pGamma(k, x, tail=False):
    r"""
    Cumulative distribution function  of a Gamma distribution on :math:`[0,+\infty[`.

    Parameters
    ----------
    k : float
        Shape parameter :math:`k > 0` with :math:`k = (\mu - \gamma)^2 / \sigma^2`.
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at x.

    Notes
    -----
    The probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{\Gamma(k)}
                 \left(x )\right)^{k - 1}
                 \exp\left(- x)\right),
                 \quad x \in [0; +\infty[

    with :math:`k, \lambda > 0`.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pGamma(2.5, 0.9)
    """
    return _DistFunc.pGamma(k, x, tail)

def qGamma(k, p, tail=False):
    r"""
    Quantile of a Gamma distribution on :math:`[0,+\infty[`.

    Parameters
    ----------
    k : float
        Shape parameter :math:`k > 0` with :math:`k = (\mu - \gamma)^2 / \sigma^2`.
    x : float
    p : float, in :math:`[0,1]`
        The probability.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----
    The probability density function is defined as:


    .. math::

        f_X(x) = \frac{1}{\Gamma(k)}
                 \left(x )\right)^{k - 1}
                 \exp\left(- x)\right),
                 \quad x \in [0; +\infty[

    with :math:`k, \lambda > 0`.

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qGamma(2.5, 0.95)
    >>> q = ot.DistFunc.qGamma(2.5, 0.95, True)
    """
    return _DistFunc.qGamma(k, p, tail)

def rGamma(*args):
    r"""
    Realization of a Gamma distribution on :math:`[0,+\infty[`.

    Parameters
    ----------
    k : float
        Shape parameter :math:`k > 0` with :math:`k = (\mu - \gamma)^2 / \sigma^2`.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the  distribution.

    Notes
    -----
    The probability density function is defined as:


    .. math::

        f_X(x) = \frac{1}{\Gamma(k)}
                 \left(x )\right)^{k - 1}
                 \exp\left(- x)\right),
                 \quad x \in [0; +\infty[

    This method is based on the algorithm (1979) described in [marsaglia2000]_ with a small
    optimization on the :math:`\beta` parameter that appears in the squeezing
    function :math:`(1 + beta * x^4)*exp(-x^2/2)`. We also add the special treatment of
    the case :math:`k < 1`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rGamma(2.5)
    """
    return _DistFunc.rGamma(*args)

def dHypergeometric(n, k, m, x):
    r"""
    The probability distribution function of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The  size of the sample.
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the sample.
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw.
    x : int, :math:`x\geq 0`
        The number of candidates in a draw.

    Returns
    -------
    p : float
        The probability to get :math:`x` candidates in a draw.

    Notes
    -----
    This method is based on an algorithm similar to Loader's algorithm, the *fast*
    and *accurate* method described in [loader2000]_, with the further improvements
    mentioned in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.dHypergeometric(10, 4, 7, 2)
    """
    return _DistFunc.dHypergeometric(n, k, m, x)

def logdHypergeometric(n, k, m, x):
    r"""
    Logarithm of the probability distribution function of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The size of the sample.
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the sample.
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw.
    x : int, :math:`x\geq 0`
        The number of candidates in a draw.

    Returns
    -------
    logp : float
        The natural logarithm of the probability to get :math:`x` candidates in a draw.

    Notes
    -----
    This method is based on an algorithm similar to Loader's algorithm, the *fast*
    and *accurate* method described in [loader2000]_, with the further improvements
    mentioned in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.logdHypergeometric(10, 4, 7, 2)
    """
    return _DistFunc.logdHypergeometric(n, k, m, x)

def pHypergeometric(n, k, m, x, tail=False):
    r"""
    Cumulative distribution function of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The size of the sample.
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the sample.
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw.
    x : int, :math:`x\geq 0`
        The number of candidates in a draw.
    tail : bool, optional
        Tail flag.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The probability to get at most :math:`x` candidates in a draw.

    Notes
    -----
    This method is based on a summation of the probability distribution function towards the upper
    bound or the lower bound of the range depending on the position of :math:`x` wrt
    the mode :math:`\left\lfloor\dfrac{(k+1)(m+1)}{n+2}\right\rfloor` of the
    distribution, then take the complement if needed.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.pHypergeometric(10, 4, 7, 2)
    >>> p = ot.DistFunc.pHypergeometric(10, 4, 7, 2, True)
    """
    return _DistFunc.pHypergeometric(n, k, m, x, tail)

def rHypergeometric(*args):
    r"""
    Realization of an hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n\geq 0`
        The size of the sample.
    k : int, :math:`0\leq k\leq n`
        The number of candidates in the sample.
    m : int, :math:`0\leq m\leq n`
        The number of individuals in a draw.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the distribution.

    Notes
    -----
    This method is based on the alias method.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rHypergeometric(10, 4, 7)
    >>> r = ot.DistFunc.rHypergeometric(10, 4, 7, 10)
    """
    return _DistFunc.rHypergeometric(*args)

def pKolmogorov(n, x, tail=False):
    r"""
    Cumulative distribution function  of a Kolmogorov distribution.

    Parameters
    ----------
    n : int
        The number of the iid observations.
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at x.

    Notes
    -----
    The Kolmogorov distribution is the distribution of :math:`D_n = \sup_y \|F(y) - F_n(y) \|`
    where :math:`F_n` is the empirical cumulative distribution built from :math:`n` independent and identically
    distributed observations and :math:`F` the cumulative distribution  to be tested.

    We use the algorithm and the selection  strategy is described in [simard2011]_.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pKolmogorov(100, 0.1)
    """
    return _DistFunc.pKolmogorov(n, x, tail)

def dNonCentralChiSquare(*args):
    r"""
    Probability density function of a NonCentralChiSquare distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    lambda : float, :math:`\lambda \geq 0`
        The :math:`\lambda` parameter.
    x : float
        The location.
    precision : float, optional
        The precision of the algorithm.

        Default value is fixed in the  :class:`~openturns.ResourceMap`,
        key (scalar) *DistFunc-Precision*.
    maximum_iteration : int, optional
        The max number of iterations of the algorithm.

        Default value is fixed in the  :class:`~openturns.ResourceMap`,
        key (integer) *DistFunc-MaximumIteration*.

    Returns
    -------
    d : float
        The PDF at :math:`x`.

    Notes
    -----
    The probability density function is defined as:

    .. math::

        f_X(x) = \sum_{j=0}^{\infty} e^{-\lambda}
                                     \frac{\lambda^j}{j!}p_{\chi^2(\nu + 2j)}(x),
                 \quad x \in [0; +\infty[

    where :math:`p_{\chi^2(q)}` is the probability density function of a
    :math:`\chi^2(q)` random variate.

    We use the algorithms described in [benton2003]_
    and Johnson and al algorithm described in [johnson1995]_.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.dNonCentralChiSquare(2.5, 0.5, 1.0)
    >>> r = ot.DistFunc.dNonCentralChiSquare(2.5, 0.5, 10, True)
    """
    return _DistFunc.dNonCentralChiSquare(*args)

def pNonCentralChiSquare(*args):
    r"""
    Cumulative distribution function  of a NonCentralChiSquare.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    lambda : float, :math:`\lambda \geq 0`
        The :math:`\lambda` parameter.
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.
    precision : float, optional
        The precision of the evaluation.
    maxInter : int, optional
        The maximum number of iterations of the algorithm.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at :math:`x`.

    Notes
    -----
    The probability density function is defined as:

    .. math::

        f_X(x) = \sum_{j=0}^{\infty} e^{-\lambda}
                                     \frac{\lambda^j}{j!}p_{\chi^2(\nu + 2j)}(x),
                 \quad x \in [0; +\infty[

    where :math:`p_{\chi^2(q)}` is the probability density function of a
    :math:`\chi^2(q)` random variate.

    We use Benton and Krishnamoorthy's algorithm described in [benton2003]_.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNonCentralChiSquare(2.5, 2.7, 3.0, True, 0.001, 100)
    >>> cdf = ot.DistFunc.pNonCentralChiSquare(2.5, 2.7, 3.0, False, 0.001, 100)
    """
    return _DistFunc.pNonCentralChiSquare(*args)

def rNonCentralChiSquare(*args):
    r"""
    Realization of a NonCentralChiSquare distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    lambda : float, :math:`\lambda \geq 0`
        The :math:`\lambda` parameter.
    size : int
        The number of realizations (optional).

        Default value is 1.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the distribution.

    Notes
    -----
    The probability density function is defined as:

    .. math::

        f_X(x) = \sum_{j=0}^{\infty} e^{-\lambda}
                                     \frac{\lambda^j}{j!}p_{\chi^2(\nu + 2j)}(x),
                 \quad x \in [0; +\infty[

    where :math:`p_{\chi^2(q)}` is the probability density function of a
    :math:`\chi^2(q)` random variate.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rNonCentralChiSquare(2.5, 0.5)
    >>> r = ot.DistFunc.rNonCentralChiSquare(2.5, 0.5, 10)
    """
    return _DistFunc.rNonCentralChiSquare(*args)

def dNonCentralStudent(nu, delta, x):
    r"""
    Probability density function of a NonCentralStudent distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    delta : float, :math:`\delta > 0`
        The :math:`\nu` parameter.
    x : float

    Returns
    -------
    p : float
        The PDF at point :math:`x`.

    Notes
    -----
    The position parameter  :math:`\gamma` is equal to zero.

    The probability density function is defined as:

    .. math::

        f_X(x) = \frac{exp \left(-\delta^2 / 2 \right)}
                      {\sqrt{\nu\pi} \Gamma \left(\frac{\nu}{2} \right)}
                 \left(\frac{\nu}{\nu + x^2}\right) ^ {\frac{\nu + 1}{2}}
                 \sum_{j=0}^{\infty}
                 \frac{\Gamma \left(\frac{\nu + j + 1}{2}\right)}{\Gamma(j + 1)}
                 \left(\delta(x - \gamma)
                 \sqrt{\frac{2}{\nu + x^2}}\right) ^ j,
                 \quad x \in \Rset

    With :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.dNonCentralStudent(2.5, 0.5, 4.0)
    """
    return _DistFunc.dNonCentralStudent(nu, delta, x)

def dNonCentralStudentAlt0(*args):
    return _DistFunc.dNonCentralStudentAlt0(*args)

def pNonCentralStudent(nu, delta, x, tail=False):
    r"""
    Cumulative distribution function  of a NonCentralStudent distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    delta : float, :math:`\delta > 0`
        The :math:`\nu` parameter.
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at x.

    Notes
    -----
    The position parameter  :math:`\gamma` is equal to zero.

    The probability density function is defined as:

    .. math::

        f_X(x) = \frac{exp \left(-\delta^2 / 2 \right)}
                      {\sqrt{\nu\pi} \Gamma \left(\frac{\nu}{2} \right)}
                 \left(\frac{\nu}{\nu + x^2}\right) ^ {\frac{\nu + 1}{2}}
                 \sum_{j=0}^{\infty}
                 \frac{\Gamma \left(\frac{\nu + j + 1}{2}\right)}{\Gamma(j + 1)}
                 \left(\delta(x - \gamma)
                 \sqrt{\frac{2}{\nu + x^2}}\right) ^ j,
                 \quad x \in \Rset

    With :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.

    We use Viktor Witkovsky's algorithm described in [witkovsky2003]_.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNonCentralStudent(2.5, 3.5, 9.5)
    >>> cdf = ot.DistFunc.pNonCentralStudent(2.5, 3.5, 9.5, True)
    """
    return _DistFunc.pNonCentralStudent(nu, delta, x, tail)

def rNonCentralStudent(*args):
    r"""
    Realization of a scalar NonCentralStudent distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    delta : float, :math:`\delta > 0`
        The :math:`\delta` parameter.
    size : int, optional
        The number of realizations.
        Default value is 1.

    Returns
    -------
    realizations : float or a sequence of float
        The realizations of the distribution.

    Notes
    -----
    The position parameter  :math:`\gamma` is equal to zero.

    The probability density function is defined as:

    .. math::

        f_X(x) = \frac{exp \left(-\delta^2 / 2 \right)}
                      {\sqrt{\nu\pi} \Gamma \left(\frac{\nu}{2} \right)}
                 \left(\frac{\nu}{\nu + x^2}\right) ^ {\frac{\nu + 1}{2}}
                 \sum_{j=0}^{\infty}
                 \frac{\Gamma \left(\frac{\nu + j + 1}{2}\right)}{\Gamma(j + 1)}
                 \left(\delta(x - \gamma)
                 \sqrt{\frac{2}{\nu + x^2}}\right) ^ j,
                 \quad x \in \Rset

    With :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rNonCentralStudent(2.5, 0.5)
    >>> r = ot.DistFunc.rNonCentralStudent(2.5, 0.5, 10)
    """
    return _DistFunc.rNonCentralStudent(*args)

def pNormal(*args):
    r"""
    Cumulative distribution function of a unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at point :math:`x`.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNormal(0.9)
    """
    return _DistFunc.pNormal(*args)

def pNormal2D(x1, x2, rho, tail=False):
    r"""
    Cumulative distribution function  of an 2D standard Normal distribution.

    Parameters
    ----------
    x1 : float
        First component of :math:`\vect{x}`.
    x2 : float, :math:`\sigma >0`
        Second component of :math:`\vect{x}`.
    rho : float
        Correlation between the first and second margin.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at point
        :math:`\vect{x} = (x_1, x_2)`.

    Notes
    -----
    The Normal distribution is bidimensional, centered and with a unit-variance.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNormal2D(1.0, 1.0, 0.9)
    >>> cdf = ot.DistFunc.pNormal2D(1.0, 1.0, 0.9, True)
    """
    return _DistFunc.pNormal2D(x1, x2, rho, tail)

def pNormal3D(x1, x2, x3, rho12, rho13, rho23, tail=False):
    r"""
    Cumulative distribution function of a 3D Normal distribution.

    Parameters
    ----------
    x1 : float
        First component of :math:`\vect{x}`.
    x2 : float, :math:`\sigma >0`
        Second component of :math:`\vect{x}`.
    x3 : float
        Third component of :math:`\vect{x}`.
    rho12 : float
        Correlation between the first and second margin.
    rho13 : float
        Correlation between the first and third margin.
    rho23 : float
        Correlation between the second and third margin.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or the complementary CDF at point
        :math:`\vect{x} = (x_1, x_2, x_3)`.

    Notes
    -----
    The Normal distribution is tridimensional, centered and with a unit-variance.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNormal3D(1.0, 0.5, 2.5, 0.5, 0.2, 0.0)
    >>> cdf = ot.DistFunc.pNormal3D(1.0, 0.5, 2.5, 0.5, 0.2, 0.0, True)
    """
    return _DistFunc.pNormal3D(x1, x2, x3, rho12, rho13, rho23, tail)

def logpNormal(x, tail=False):
    r"""
    Log-CDF of a unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the log-complementary CDF is computed.

    Returns
    -------
    logCdf : float
        The log-CDF or the log-complementary CDF at :math:`x`.


    Examples
    --------
    >>> import openturns as ot
    >>> logCdf = ot.DistFunc.logpNormal(0.9)
    """
    return _DistFunc.logpNormal(x, tail)

def qNormal(*args):
    r"""
    Quantile of a unit-variance centered Normal distribution.

    Parameters
    ----------
    p : float, in :math:`[0,1]`
       The probability.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----
    This method is based on Peter John Acklam's algorithm, described in [acklam2017]_.

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qNormal(0.95)
    """
    return _DistFunc.qNormal(*args)

def rNormal(*args):
    r"""
    Realization of a unit-variance centered Normal distribution.


    Parameters
    ----------
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rNormal()
    """
    return _DistFunc.rNormal(*args)

def dNormal(*args):
    r"""
    PDF of a unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float or sequence of floats
        Location.

    Returns
    -------
    pdf : float or sequence of floats
        The PDF at :math:`x`.

    Examples
    --------
    >>> import openturns as ot
    >>> pdf = ot.DistFunc.dNormal(3.0)
    >>> pdf = ot.DistFunc.dNormal([-3, -2, 2, 3])
    """
    return _DistFunc.dNormal(*args)

def logdNormal(x):
    r"""
    Log-PDF of a unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location.

    Returns
    -------
    logPdf : float
        The log-PDF at :math:`x`.

    Examples
    --------
    >>> import openturns as ot
    >>> pdf = ot.DistFunc.logdNormal(3.0)
    """
    return _DistFunc.logdNormal(x)

def logdPoisson(_lambda, k):
    r"""
    Logarithm of the probability distribution function of a Poisson distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda \geq 0`
        The intensity of the Poisson distribution.
    k : int
        The number of success.

    Returns
    -------
    logp : float
        The natural logarithm of the probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.logdPoisson(5.0, 2)
    """
    return _DistFunc.logdPoisson(_lambda, k)

def dPoisson(_lambda, k):
    r"""
    probability distribution function of a Poisson distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda \geq 0`
        The intensity of the Poisson distribution.
    k : int
        The number of success.

    Returns
    -------
    p : float
        The probability to get :math:`k` successes.

    Notes
    -----
    This method implements Loader's algorithm, the *fast* and *accurate* method
    described in [loader2000]_, with the further improvements mentioned
    in [dimitriadis2016]_.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.DistFunc.dPoisson(5.0, 2)
    """
    return _DistFunc.dPoisson(_lambda, k)

def qPoisson(_lambda, p, tail=False):
    r"""
    Quantile of a Poisson distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda\geq 0`
        The intensity of the Poisson distribution.
    p : float, in :math:`[0,1]`
        The probability.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qPoisson(2.0, 0.95)
    """
    return _DistFunc.qPoisson(_lambda, p, tail)

def rPoisson(*args):
    r"""
    Realization of a Poisson distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda \geq 0`
        The intensity of the Poisson distribution.
    size : int
        The number of realizations to generate.

    Returns
    -------
    realizations : int or :class:`~openturns.Indices`
        The realizations of the distribution.

    Notes
    -----
    For the small values of :math:`\lambda`, we use the method of inversion by
    sequential search described in [devroye1986]_ and with the important errata in
    [devroye1986b]_. For the large values of :math:`\lambda`, we use the ratio of
    uniform method described in [stadlober1990]_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rPoisson(5.0)
    >>> r = ot.DistFunc.rPoisson(5.0, 10)
    """
    return _DistFunc.rPoisson(*args)

def pPearsonCorrelation(size, rho, tail=False):
    r"""
    Cumulative distribution function  of the Pearson statistic distribution.

    Parameters
    ----------
    n : int
        The size of the samples.

    rho : float, :math:`-1<rho<1`
        The Pearson correlation coefficient.

    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or its complementary of the Pearson statistic distribution.

    Notes
    -----
    This method enables to test whether an observed value of the Pearson correlation :math:`\rho`
    is significantly different from zero. It implements the distribution of the statistic under the
    null hypothesis where the Pearson correlation is assumed to be not significantly different from 0.

    The CDF value is the probability that the statistic is lower than or equal
    to the value calculated from :math:`\rho`. The complementary CDF value is the p-value.

    We use the Student asymptotic approximation of the statistic distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> pval = ot.DistFunc.pPearsonCorrelation(100, 0.3, True)
    """
    return _DistFunc.pPearsonCorrelation(size, rho, tail)

def pSpearmanCorrelation(size, rho, tail=False, ties=False):
    r"""
    Cumulative distribution function  of a the Spearman correlation distribution.

    Parameters
    ----------
    n : int
        The number of distinct ranks.
    rho : float
        Location.
    tail : bool, optional
        Tail flag. 
        Default value is False.
        If True, the complementary CDF is computed.
    ties : bool
        Indicates whether ties in the samples are taken into account.

        Default value is False.

    Returns
    -------
    p : float
        The CDF or its complementary of the Spearman statistic distribution.

    Notes
    -----
    This method enables to test whether an observed value of the Spearman correlation :math:`\rho`
    is significantly different from zero. It implements the distribution of the statistic under the
    null hypothesis where the Spearmann correlation is assumed to be not significantly different from 0.

    The CDF value is the probability that the statistic is lower than or equal
    to the value calculated from :math:`\rho`. The complementary CDF value is the p-value.

    When there is no tie, we use the tabulated exact distribution of the statistic for small sample
    size thanks to the values given in [luke]_ and the Edgeworth
    expansion for the other sample sizes.

    When there are ties, we use the Student asymptotic approximation.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pSpearmanCorrelation(100, 0.1)
    """
    return _DistFunc.pSpearmanCorrelation(size, rho, tail, ties)

def pStudent(*args):
    r"""
    Cumulative distribution function  of a scalar Student distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    x : float or sequence of float
        Location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float or sequence of float
        The CDF or the complementary CDF at x or at each :math:`x[i]`.

    Notes
    -----
    The probability density function is defined as:

    .. math::
        p(x) = \dfrac{1}{\sqrt{\nu}B(1/2, \nu/2)} \left(1+ \dfrac{x^2}{\nu}\right)^{-\dfrac{\nu+1}{2}} \quad x \in \Rset

    with :math:`\nu > 0`.

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pStudent(2.5, 0.9)
    >>> cdf = ot.DistFunc.pStudent(2.5, 0.9, True)
    """
    return _DistFunc.pStudent(*args)

def qStudent(*args):
    r"""
    Quantile of a scalar Student distribution.


    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    p : float, in :math:`[0,1]`
        The probability.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----
    The probability density function is defined as:

    .. math::
        p(x) = \dfrac{1}{\sqrt{\nu}B(1/2, \nu/2)} \left(1+ \dfrac{x^2}{\nu}\right)^{-\dfrac{\nu+1}{2}} \quad x \in \Rset

    with :math:`\nu > 0`.

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qStudent(2.0, 0.95)
    """
    return _DistFunc.qStudent(*args)

def rStudent(*args):
    r"""
    Realization of a scalar Student distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        The :math:`\nu` parameter.
    size : int, optional
        The number of realizations.
        Default value is 1.

    Returns
    -------
    realization : float or a sequence of float
        The realizations of the  distribution.

    Notes
    -----
    The probability density function is defined as:

    .. math::
        p(x) = \dfrac{1}{\sqrt{\nu}B(1/2, \nu/2)} \left(1+ \dfrac{x^2}{\nu}\right)^{-\dfrac{\nu+1}{2}} \quad x \in \Rset

    with :math:`\nu > 0`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rStudent(2.5)
    >>> r = ot.DistFunc.rStudent(2.5, 10)
    """
    return _DistFunc.rStudent(*args)

def rUniformSegment(*args):
    r"""
    Realization of a uniform distribution over a segment.

    Parameters
    ----------
    a : sequence of float, in :math:`\Rset^n`
        The first vertex of the segment.
    b : sequence of float, in :math:`\Rset^n`
        The second vertex of the segment.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the  distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> a = [1, 5]
    >>> b = [2, 3]
    >>> r = ot.DistFunc.rUniformSegment(a, b)
    >>> r = ot.DistFunc.rUniformSegment(a, b, 10)
    """
    return _DistFunc.rUniformSegment(*args)

def rUniformTriangle(*args):
    r"""
    Realization of a uniform distribution over a triangle.

    Parameters
    ----------
    a : sequence of float, in :math:`\Rset^n`
        The first vertex of the triangle.
    b : sequence of float, in :math:`\Rset^n`
        The second vertex of the triangle.
    c : sequence of float, in :math:`\Rset^n`
        The third vertex of the triangle.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> a = [1, 5]
    >>> b = [2, 3]
    >>> c = [-1, 2]
    >>> r = ot.DistFunc.rUniformTriangle(a, b, c)
    >>> r = ot.DistFunc.rUniformTriangle(a, b, c, 10)
    """
    return _DistFunc.rUniformTriangle(*args)

def rUniformTetrahedron(*args):
    r"""
    Realization of a uniform distribution over a tetrahedron.

    Parameters
    ----------
    a : sequence of float, in :math:`\Rset^n`
        The first vertex of the triangle.
    b : sequence of float, in :math:`\Rset^n`
        The second vertex of the triangle.
    c : sequence of float, in :math:`\Rset^n`
        The third vertex of the triangle.
    d : sequence of float, in :math:`\Rset^n`
        The fourth vertex of the triangle.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the  distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> a = [1, 5, 0]
    >>> b = [2, 3, -1]
    >>> c = [-1, 2, 2]
    >>> d = [1, 2, 1]
    >>> r = ot.DistFunc.rUniformTetrahedron(a, b, c, d)
    >>> r = ot.DistFunc.rUniformTetrahedron(a, b, c, d, 10)
    """
    return _DistFunc.rUniformTetrahedron(*args)

def rUniformSimplex(*args):
    r"""
    Realization of a uniform distribution over a simplex.

    Parameters
    ----------
    vertices : 2-d sequence of float, a list of points in :math:`\Rset^n`
        The vertices of the simplex.
    size : int
        The number of realizations to generate.

    Notes
    -----
    This method samples the barycentric coordinates, allowing to work in any dimension.

    Returns
    -------
    realizations : float or sequence of float
        The realizations of the  distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> vertices = [[0, 1, 0, 2, 0, 0],
    ...             [1, 0, 2, 3, 1, 0],
    ...             [3, 4, 0, 0, 1, 2],
    ...             [2, 0, 2, 0, 1, 1],
    ...             [1, 3, 1, 4, 1, 5]]
    >>> r = ot.DistFunc.rUniformSimplex(vertices)
    >>> r = ot.DistFunc.rUniformSimplex(vertices, 10)
    """
    return _DistFunc.rUniformSimplex(*args)

def eZ1(n):
    r"""
    Expectation of the min of *n* independent standard normal random variables.

    Parameters
    ----------
    n : int

    Returns
    -------
    mu : float
        The mean value of the min of *n* independent standard normal random variables.
    """
    return _DistFunc.eZ1(n)

def kFactorPooled(n, m, p, alpha):
    r"""
    Exact margin factor for bilateral covering interval of pooled Normal samples.

    Parameters
    ----------
    n : int
        The size of the sample.

    m : int
        The size of the pool.

    p : float :math:`0<p<1`
        The probability level of the covering interval.

    alpha : float :math:`0<\alpha<1`
        The confidence level of the covering interval.

    Returns
    -------
    k : float
        The margin factor

    Notes
    -----
    This method allows one to compute the *exact* margin factor :math:`k` of a
    pool of :math:`m` Normal samples of size :math:`n` with unknown
    means :math:`\mu_i` and unknown common variance :math:`\sigma^2`.
    This implements the standard NF ISO 16269-6. 
    Let :math:`m_i=\dfrac{1}{n}\sum_{j=1}^nX_{ij}` be the empirical mean
    of the ith sample :math:`(X_{i1},\dots,X_{in})` and
    :math:`\sigma^2_{mn}=\dfrac{}{}\sum_{i=1}^m\sum_{j=1}^n(X_{ij}-m_i)^2`
    the empirical *pooled* variance. The covering factor :math:`k` is such
    that the intervals :math:`[m_i-k\sigma_{mn},m_i+k\sigma_{mn}]` satisfy:

    .. math::
        \Prob{\Prob{X_i\in[m_i-k\sigma_{mn},m_i+k\sigma_{mn}]}\geq p}=\alpha

    for :math:`i\in\{1,\dots,m\}`. It reduces to find :math:`k` such that:

    .. math::
        \int_{\Rset}F(x,k;\nu_{m,n},p)\phi_{0,1/\sqrt{n}}(x)\,\di x = \alpha

    where :math:`phi_{0,1/\sqrt{n}}` is the density function of the normal
    distribution with a mean equals to 0 and a variance equals to
    :math:`1/n`, :math:`\nu_{m,n}=m(n-1)` and :math:`F(x,k;\nu_{m,n},p)`
    the function defined by:

    .. math::
        F(x,k;\nu_{m,n},p)=\bar{F}_{\chi^2_{\nu_{m,n}}}(\nu_{m,n} R^2(x;p)/k^2)

    where :math:`\bar{F}_{\chi^2_{\nu_{m,n}}}` is the complementary distribution
    function of a chi-square distribution with :math:`\nu_{m,n}` degrees
    of freedom and :math:`R(x;p)` the solution of:

    .. math::
        \Phi(x + R) - \Phi(x - R) = p

    Examples
    --------
    >>> import openturns as ot
    >>> k = ot.DistFunc.kFactorPooled(5, 3, 0.95, 0.9)
    """
    return _DistFunc.kFactorPooled(n, m, p, alpha)

def kFactor(n, p, alpha):
    r"""
    Exact margin factor for bilateral covering interval of a Normal sample.

    Parameters
    ----------
    n : int
        The size of the sample.

    p : float :math:`0<p<1`
        The probability level of the covering interval.

    alpha : float :math:`0<\alpha<1`
        The confidence level of the covering interval.

    Returns
    -------
    k : float
        The margin factor.

    Notes
    -----
    This method allows one to compute the *exact* margin factor :math:`k` of a
    Normal sample of size :math:`n` with unknown
    means :math:`\mu_i` and unknown common variance :math:`\sigma^2`. It
    is equivalent to the pooled version with :math:`m=1`.
    This implements the standard NF ISO 16269-6. 

    Examples
    --------
    >>> import openturns as ot
    >>> k = ot.DistFunc.kFactor(5, 0.95, 0.9)
    """
    return _DistFunc.kFactor(n, p, alpha)

def pDickeyFullerTrend(x, tail=False):
    r"""
    Cumulative distribution function of the Dickey-Fuller statistic.

    Parameters
    ----------
    x : float
        The location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or its complementary at :math:`x`.

    Notes
    -----

    Refer to :ref:`dickey_fuller`.


    Let :math:`(X_1, \hdots, X_n)` denote the data and :math:`W(r)` the Wiener process. Let us define
    :math:`W^{a}(r) = W(r) - \int_{0}^{1} W(r)\di{r}` and
    :math:`W^{b}(r) = W^{a}(r) - 12 \left(r - \frac{1}{2} \right) \int_{0}^{1} \left(s - \frac{1}{2} \right) W(s)\di{s}`.

    The Dickey-Fuller statistic is the asymptotic distribution of the Student statistic used to test the model with drift and trend in a time series: 

    .. math::

        \boldsymbol{X_t = a + bt + \rho X_{t-1} + \varepsilon_{t}}

    We test:

    .. math::

        \left\{
        \begin{array}{lr}
          \cH_0: & \rho = 1 \\
          \cH_1: & \rho < 1
        \end{array}
        \right.

    thanks to the Student statistic defined by:

    .. math::

        t_{\rho=1} = \frac{\rho_n-1}{\hat{\sigma}_{\rho_n}}

    where :math:`\sigma_{\rho_n}` is the least square estimate of the standard deviation of :math:`\Hat{\rho}_n`. Under
    the  null hypothesis :math:`\cH_0`, :math:`t_{\rho=1}` converges towards the Dickey-Fuller distribution:

    .. math::

        t_{\rho = 1} \stackrel{\mathcal{L}}{\longrightarrow} \frac{\int_{0}^{1}W^{b}(r) \di{W(r)}}{\int_{1}^{0} W^{b}(r)^2 \di{r}}


    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.pDickeyFullerTrend(5.4)
    >>> q = ot.DistFunc.pDickeyFullerTrend(5.4, True)
    """
    return _DistFunc.pDickeyFullerTrend(x, tail)

def pDickeyFullerConstant(x, tail=False):
    r"""
    Cumulative distribution function of the Dickey-Fuller statistic.

    Parameters
    ----------
    x : float
        The location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or its complementary at :math:`x`.

    Notes
    -----

    Refer to :ref:`dickey_fuller`.


    Let :math:`(X_1, \hdots, X_n)` denote the data and :math:`W(r)` the Wiener process. Let us define
    :math:`W^{a}(r) = W(r) - \int_{0}^{1} W(r)\di{r}` and
    :math:`W^{b}(r) = W^{a}(r) - 12 \left(r - \frac{1}{2} \right) \int_{0}^{1} \left(s - \frac{1}{2} \right) W(s)\di{s}`.

    The Dickey-Fuller statistic is the asymptotic distribution of the Student statistic used to test the model with drift but no trend in a time series: 

    .. math::

        \boldsymbol{X_t = a + \rho X_{t-1} + \varepsilon_{t}}

    We test:

    .. math::

        \left\{
        \begin{array}{lr}
          \cH_0: & \rho = 1 \\
          \cH_1: & \rho < 1
        \end{array}
        \right.

    thanks to the Student statistic defined by:

    .. math::

        t_{\rho=1} = \frac{\rho_n-1}{\hat{\sigma}_{\rho_n}}

    where :math:`\sigma_{\rho_n}` is the least square estimate of the standard deviation of :math:`\Hat{\rho}_n`. Under
    the  null hypothesis :math:`\cH_0`, :math:`t_{\rho=1}` converges towards the Dickey-Fuller distribution:

    .. math::

        t_{\rho = 1} \stackrel{\mathcal{L}}{\longrightarrow} \frac{\int_{0}^{1}W^{a}(r) \di{W(r)}}{\int_{1}^{0} W^{a}(r)^2 \di{r}}


    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.pDickeyFullerConstant(5.4)
    >>> q = ot.DistFunc.pDickeyFullerConstant(5.4, True)
    """
    return _DistFunc.pDickeyFullerConstant(x, tail)

def pDickeyFullerNoConstant(x, tail=False):
    r"""
    Cumulative distribution function of the Dickey-Fuller statistic.

    Parameters
    ----------
    x : float
        The location.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the complementary CDF is computed.

    Returns
    -------
    p : float
        The CDF or its complementary at :math:`x`.

    Notes
    -----

    Refer to :ref:`dickey_fuller`.


    Let :math:`(X_1, \hdots, X_n)` denote the data and :math:`W(r)` the Wiener process. Let us define
    :math:`W^{a}(r) = W(r) - \int_{0}^{1} W(r)\di{r}` and
    :math:`W^{b}(r) = W^{a}(r) - 12 \left(r - \frac{1}{2} \right) \int_{0}^{1} \left(s - \frac{1}{2} \right) W(s)\di{s}`.

    The Dickey-Fuller statistic is the asymptotic distribution of the Student statistic used to test the model with no drift nor trend in a time series: 

    .. math::

        \boldsymbol{X_t = \rho X_{t-1} + \varepsilon_{t}}

    We test:

    .. math::

        \left\{
        \begin{array}{lr}
          \cH_0: & \rho = 1 \\
          \cH_1: & \rho < 1
        \end{array}
        \right.

    thanks to the Student statistic defined by:

    .. math::

        t_{\rho=1} = \frac{\rho_n-1}{\hat{\sigma}_{\rho_n}}

    where :math:`\sigma_{\rho_n}` is the least square estimate of the standard deviation of :math:`\Hat{\rho}_n`. Under
    the null hypothesis :math:`\cH_0`, :math:`t_{\rho=1}` converges towards the Dickey-Fuller distribution:

    .. math::

        t_{\rho = 1} \stackrel{\mathcal{L}}{\longrightarrow} \frac{\int_{0}^{1}W(r) \di{W(r)}}{\int_{1}^{0} W(r)^2 \di{r}}


    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.pDickeyFullerNoConstant(5.4)
    >>> q = ot.DistFunc.pDickeyFullerNoConstant(5.4, True)
    """
    return _DistFunc.pDickeyFullerNoConstant(x, tail)

def qDickeyFullerTrend(p, tail=False):
    r"""
    Quantile of the Dickey-Fuller statistic.

    Parameters
    ----------
    p : float
        The probability.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----

    Refer to :ref:`dickey_fuller`.

    Let :math:`(X_1, \hdots, X_n)` denote the data and :math:`W(r)` the Wiener process. Let us define
    :math:`W^{a}(r) = W(r) - \int_{0}^{1} W(r)\di{r}` and
    :math:`W^{b}(r) = W^{a}(r) - 12 \left(r - \frac{1}{2} \right) \int_{0}^{1} \left(s - \frac{1}{2} \right) W(s)\di{s}`.

    The Dickey-Fuller statistic is the asymptotic distribution of the Student statistic used to test the model with drift and trend in a time series: 

    .. math::

        \boldsymbol{X_t = a + bt + \rho X_{t-1} + \varepsilon_{t}}

    We test:

    .. math::

        \left\{
        \begin{array}{lr}
          \cH_0: & \rho = 1 \\
          \cH_1: & \rho < 1
        \end{array}
        \right.

    thanks to the Student statistic defined by:

    .. math::

        t_{\rho=1} = \frac{\rho_n-1}{\hat{\sigma}_{\rho_n}}

    where :math:`\sigma_{\rho_n}` is the least square estimate of the standard deviation of :math:`\Hat{\rho}_n`. Under
    the  null hypothesis :math:`\cH_0`, :math:`t_{\rho=1}` converges towards the Dickey-Fuller distribution:

    .. math::

        t_{\rho = 1} \stackrel{\mathcal{L}}{\longrightarrow} \frac{\int_{0}^{1}W^{b}(r) \di{W(r)}}{\int_{1}^{0} W^{b}(r)^2 \di{r}}


    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qDickeyFullerTrend(0.01)
    """
    return _DistFunc.qDickeyFullerTrend(p, tail)

def qDickeyFullerConstant(p, tail=False):
    r"""
    Quantile of the Dickey-Fuller statistic.

    Parameters
    ----------
    p : float
        The probability.
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----

    Refer to :ref:`dickey_fuller`.

    Let :math:`(X_1, \hdots, X_n)` denote the data and :math:`W(r)` the Wiener process. Let us define
    :math:`W^{a}(r) = W(r) - \int_{0}^{1} W(r)\di{r}` and
    :math:`W^{b}(r) = W^{a}(r) - 12 \left(r - \frac{1}{2} \right) \int_{0}^{1} \left(s - \frac{1}{2} \right) W(s)\di{s}`.

    The Dickey-Fuller statistic is the asymptotic distribution of the Student statistic used to test the model with drift but no trend in a time series: 

    .. math::

        \boldsymbol{X_t = a + \rho X_{t-1} + \varepsilon_{t}}

    We test:

    .. math::

        \left\{
        \begin{array}{lr}
          \cH_0: & \rho = 1 \\
          \cH_1: & \rho < 1
        \end{array}
        \right.

    thanks to the Student statistic defined by:

    .. math::

        t_{\rho=1} = \frac{\rho_n-1}{\hat{\sigma}_{\rho_n}}

    where :math:`\sigma_{\rho_n}` is the least square estimate of the standard deviation of :math:`\Hat{\rho}_n`. Under
    the  null hypothesis :math:`\cH_0`, :math:`t_{\rho=1}` converges towards the Dickey-Fuller distribution:

    .. math::

        t_{\rho = 1} \stackrel{\mathcal{L}}{\longrightarrow} \frac{\int_{0}^{1}W^{a}(r) \di{W(r)}}{\int_{1}^{0} W^{a}(r)^2 \di{r}}


    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qDickeyFullerConstant(0.01)
    """
    return _DistFunc.qDickeyFullerConstant(p, tail)

def qDickeyFullerNoConstant(p, tail=False):
    r"""
    Quantile of the Dickey-Fuller statistic.

    Parameters
    ----------
    p : float
        The probability.
    x : float
    tail : bool, optional
        Tail flag.
        Default value is False.
        If True, the quantile associated to :math:`(1-p)` is computed.

    Returns
    -------
    q : float
        The quantile of order :math:`p` or :math:`(1-p)`.

    Notes
    -----

    Refer to :ref:`dickey_fuller`.


    Let :math:`(X_1, \hdots, X_n)` denote the data and :math:`W(r)` the Wiener process. Let us define
    :math:`W^{a}(r) = W(r) - \int_{0}^{1} W(r)\di{r}` and
    :math:`W^{b}(r) = W^{a}(r) - 12 \left(r - \frac{1}{2} \right) \int_{0}^{1} \left(s - \frac{1}{2} \right) W(s)\di{s}`.

    The Dickey-Fuller statistic is the asymptotic distribution of the Student statistic used to test the model with no drift nor trend in a time series: 

    .. math::

        \boldsymbol{X_t = \rho X_{t-1} + \varepsilon_{t}}

    We test:

    .. math::

        \left\{
        \begin{array}{lr}
          \cH_0: & \rho = 1 \\
          \cH_1: & \rho < 1
        \end{array}
        \right.

    thanks to the Student statistic defined by:

    .. math::

        t_{\rho=1} = \frac{\rho_n-1}{\hat{\sigma}_{\rho_n}}

    where :math:`\sigma_{\rho_n}` is the least square estimate of the standard deviation of :math:`\Hat{\rho}_n`. Under
    the  null hypothesis :math:`\cH_0`, :math:`t_{\rho=1}` converges towards the Dickey-Fuller distribution:

    .. math::

        t_{\rho = 1} \stackrel{\mathcal{L}}{\longrightarrow} \frac{\int_{0}^{1}W(r) \di{W(r)}}{\int_{1}^{0} W(r)^2 \di{r}}


    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qDickeyFullerNoConstant(0.01)
    """
    return _DistFunc.qDickeyFullerNoConstant(p, tail)

cvar = _DistFunc.cvar
NumberOfBandNormalZigurrat = cvar.NumberOfBandNormalZigurrat
NormalZigguratTail = cvar.NormalZigguratTail
NormalZigguratAbscissa = cvar.NormalZigguratAbscissa
NormalZigguratRatio = cvar.NormalZigguratRatio

