// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Media_Miracast_H
#define WINRT_Windows_Media_Miracast_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Media.h"
#include "winrt/impl/Windows.ApplicationModel.Core.2.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Graphics.2.h"
#include "winrt/impl/Windows.Media.Core.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.Media.Miracast.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::GetDefaultSettings() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultSettings(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->GetDefaultSettings(&result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverSettings{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::GetCurrentSettings() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentSettings(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->GetCurrentSettings(&result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverSettings{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::GetCurrentSettingsAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentSettingsAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->GetCurrentSettingsAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverSettings>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::DisconnectAllAndApplySettings(winrt::Windows::Media::Miracast::MiracastReceiverSettings const& settings) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisconnectAllAndApplySettings(*(void**)(&settings), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->DisconnectAllAndApplySettings(*(void**)(&settings), &result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsResult{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::DisconnectAllAndApplySettingsAsync(winrt::Windows::Media::Miracast::MiracastReceiverSettings const& settings) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisconnectAllAndApplySettingsAsync(*(void**)(&settings), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->DisconnectAllAndApplySettingsAsync(*(void**)(&settings), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsResult>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::GetStatus() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStatus(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->GetStatus(&result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverStatus{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::GetStatusAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStatusAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->GetStatusAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverStatus>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::StatusChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiver, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->add_StatusChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::StatusChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiver, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, StatusChanged_revoker>(this, StatusChanged(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::StatusChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            _winrt_abi_type->remove_StatusChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::CreateSession(winrt::Windows::ApplicationModel::Core::CoreApplicationView const& view) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSession(*(void**)(&view), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->CreateSession(*(void**)(&view), &result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverSession{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::CreateSessionAsync(winrt::Windows::ApplicationModel::Core::CoreApplicationView const& view) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSessionAsync(*(void**)(&view), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->CreateSessionAsync(*(void**)(&view), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverSession>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::ClearKnownTransmitters() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearKnownTransmitters());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->ClearKnownTransmitters());
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiver<D>::RemoveKnownTransmitter(winrt::Windows::Media::Miracast::MiracastTransmitter const& transmitter) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveKnownTransmitter(*(void**)(&transmitter)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiver>**)this;
            check_hresult(_winrt_abi_type->RemoveKnownTransmitter(*(void**)(&transmitter)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverApplySettingsResult<D>::Status() const
    {
        winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverApplySettingsResult<D>::ExtendedError() const
    {
        winrt::hresult value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedError(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedError(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::Disconnect(winrt::Windows::Media::Miracast::MiracastReceiverDisconnectReason const& reason) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Disconnect(static_cast<int32_t>(reason)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->Disconnect(static_cast<int32_t>(reason)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::Disconnect(winrt::Windows::Media::Miracast::MiracastReceiverDisconnectReason const& reason, param::hstring const& message) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisconnectWithMessage(static_cast<int32_t>(reason), *(void**)(&message)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->DisconnectWithMessage(static_cast<int32_t>(reason), *(void**)(&message)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::Pause() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Pause());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->Pause());
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::PauseAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PauseAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->PauseAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::Resume() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Resume());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->Resume());
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::ResumeAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ResumeAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->ResumeAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::Transmitter() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Transmitter(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->get_Transmitter(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastTransmitter{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::InputDevices() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InputDevices(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->get_InputDevices(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverInputDevices{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::CursorImageChannel() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CursorImageChannel(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->get_CursorImageChannel(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnection<D>::StreamControl() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StreamControl(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnection>**)this;
            check_hresult(_winrt_abi_type->get_StreamControl(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverStreamControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnectionCreatedEventArgs<D>::Connection() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Connection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Connection(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverConnection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnectionCreatedEventArgs<D>::Pin() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Pin(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Pin(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverConnectionCreatedEventArgs<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::Foundation::Deferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::MaxImageSize() const
    {
        winrt::Windows::Graphics::SizeInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxImageSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            check_hresult(_winrt_abi_type->get_MaxImageSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::Position() const
    {
        winrt::Windows::Graphics::PointInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Position(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            check_hresult(_winrt_abi_type->get_Position(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::ImageStream() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ImageStream(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            check_hresult(_winrt_abi_type->get_ImageStream(&value));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStreamWithContentType{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::ImageStreamChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ImageStreamChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            check_hresult(_winrt_abi_type->add_ImageStreamChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::ImageStreamChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, ImageStreamChanged_revoker>(this, ImageStreamChanged(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::ImageStreamChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ImageStreamChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            _winrt_abi_type->remove_ImageStreamChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::PositionChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PositionChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            check_hresult(_winrt_abi_type->add_PositionChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::PositionChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, PositionChanged_revoker>(this, PositionChanged(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannel<D>::PositionChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PositionChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>**)this;
            _winrt_abi_type->remove_PositionChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannelSettings<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannelSettings<D>::IsEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)this;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannelSettings<D>::MaxImageSize() const
    {
        winrt::Windows::Graphics::SizeInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxImageSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)this;
            check_hresult(_winrt_abi_type->get_MaxImageSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverCursorImageChannelSettings<D>::MaxImageSize(winrt::Windows::Graphics::SizeInt32 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxImageSize(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>**)this;
            check_hresult(_winrt_abi_type->put_MaxImageSize(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverDisconnectedEventArgs<D>::Connection() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Connection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Connection(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverConnection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::TransmitInput() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransmitInput(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->get_TransmitInput(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::TransmitInput(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransmitInput(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->put_TransmitInput(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::IsRequestedByTransmitter() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRequestedByTransmitter(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->get_IsRequestedByTransmitter(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::IsTransmittingInput() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTransmittingInput(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->get_IsTransmittingInput(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::Mode() const
    {
        winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDeviceUsageMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::Mode(winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDeviceUsageMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Mode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->put_Mode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::Changed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDevice, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::Changed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDevice, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Changed_revoker>(this, Changed(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverGameControllerDevice<D>::Changed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>**)this;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverInputDevices<D>::Keyboard() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Keyboard(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>**)this;
            check_hresult(_winrt_abi_type->get_Keyboard(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverKeyboardDevice{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverInputDevices<D>::GameController() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GameController(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>**)this;
            check_hresult(_winrt_abi_type->get_GameController(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDevice{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::TransmitInput() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransmitInput(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)this;
            check_hresult(_winrt_abi_type->get_TransmitInput(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::TransmitInput(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransmitInput(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)this;
            check_hresult(_winrt_abi_type->put_TransmitInput(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::IsRequestedByTransmitter() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRequestedByTransmitter(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)this;
            check_hresult(_winrt_abi_type->get_IsRequestedByTransmitter(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::IsTransmittingInput() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTransmittingInput(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)this;
            check_hresult(_winrt_abi_type->get_IsTransmittingInput(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::Changed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverKeyboardDevice, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)this;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::Changed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverKeyboardDevice, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Changed_revoker>(this, Changed(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverKeyboardDevice<D>::Changed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>**)this;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverMediaSourceCreatedEventArgs<D>::Connection() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Connection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Connection(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverConnection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverMediaSourceCreatedEventArgs<D>::MediaSource() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MediaSource(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_MediaSource(&value));
        }
        return winrt::Windows::Media::Core::MediaSource{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverMediaSourceCreatedEventArgs<D>::CursorImageChannelSettings() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CursorImageChannelSettings(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_CursorImageChannelSettings(&value));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannelSettings{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverMediaSourceCreatedEventArgs<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::Foundation::Deferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::ConnectionCreated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverConnectionCreatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ConnectionCreated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->add_ConnectionCreated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::ConnectionCreated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverConnectionCreatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ConnectionCreated_revoker>(this, ConnectionCreated(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::ConnectionCreated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ConnectionCreated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            _winrt_abi_type->remove_ConnectionCreated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::MediaSourceCreated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverMediaSourceCreatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_MediaSourceCreated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->add_MediaSourceCreated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::MediaSourceCreated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverMediaSourceCreatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, MediaSourceCreated_revoker>(this, MediaSourceCreated(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::MediaSourceCreated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            _winrt_abi_type->remove_MediaSourceCreated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            _winrt_abi_type->remove_MediaSourceCreated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::Disconnected(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverDisconnectedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Disconnected(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->add_Disconnected(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::Disconnected(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverDisconnectedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Disconnected_revoker>(this, Disconnected(handler));
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::Disconnected(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Disconnected(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            _winrt_abi_type->remove_Disconnected(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::AllowConnectionTakeover() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowConnectionTakeover(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->get_AllowConnectionTakeover(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::AllowConnectionTakeover(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowConnectionTakeover(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->put_AllowConnectionTakeover(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::MaxSimultaneousConnections() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxSimultaneousConnections(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->get_MaxSimultaneousConnections(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::MaxSimultaneousConnections(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxSimultaneousConnections(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->put_MaxSimultaneousConnections(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::Start() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Start(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->Start(&result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverSessionStartResult{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSession<D>::StartAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSession, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSession>**)this;
            check_hresult(_winrt_abi_type->StartAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverSessionStartResult>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSessionStartResult<D>::Status() const
    {
        winrt::Windows::Media::Miracast::MiracastReceiverSessionStartStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSessionStartResult<D>::ExtendedError() const
    {
        winrt::hresult value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedError(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedError(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::FriendlyName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FriendlyName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->get_FriendlyName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::FriendlyName(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FriendlyName(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->put_FriendlyName(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::ModelName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ModelName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->get_ModelName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::ModelName(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ModelName(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->put_ModelName(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::ModelNumber() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ModelNumber(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->get_ModelNumber(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::ModelNumber(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ModelNumber(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->put_ModelNumber(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::AuthorizationMethod() const
    {
        winrt::Windows::Media::Miracast::MiracastReceiverAuthorizationMethod value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AuthorizationMethod(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->get_AuthorizationMethod(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::AuthorizationMethod(winrt::Windows::Media::Miracast::MiracastReceiverAuthorizationMethod const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AuthorizationMethod(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->put_AuthorizationMethod(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::RequireAuthorizationFromKnownTransmitters() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RequireAuthorizationFromKnownTransmitters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->get_RequireAuthorizationFromKnownTransmitters(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverSettings<D>::RequireAuthorizationFromKnownTransmitters(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RequireAuthorizationFromKnownTransmitters(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverSettings>**)this;
            check_hresult(_winrt_abi_type->put_RequireAuthorizationFromKnownTransmitters(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStatus<D>::ListeningStatus() const
    {
        winrt::Windows::Media::Miracast::MiracastReceiverListeningStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ListeningStatus(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)this;
            check_hresult(_winrt_abi_type->get_ListeningStatus(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStatus<D>::WiFiStatus() const
    {
        winrt::Windows::Media::Miracast::MiracastReceiverWiFiStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_WiFiStatus(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)this;
            check_hresult(_winrt_abi_type->get_WiFiStatus(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStatus<D>::IsConnectionTakeoverSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsConnectionTakeoverSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)this;
            check_hresult(_winrt_abi_type->get_IsConnectionTakeoverSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStatus<D>::MaxSimultaneousConnections() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxSimultaneousConnections(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)this;
            check_hresult(_winrt_abi_type->get_MaxSimultaneousConnections(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStatus<D>::KnownTransmitters() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KnownTransmitters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStatus>**)this;
            check_hresult(_winrt_abi_type->get_KnownTransmitters(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Miracast::MiracastTransmitter>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStreamControl<D>::GetVideoStreamSettings() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetVideoStreamSettings(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)this;
            check_hresult(_winrt_abi_type->GetVideoStreamSettings(&result));
        }
        return winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStreamControl<D>::GetVideoStreamSettingsAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetVideoStreamSettingsAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)this;
            check_hresult(_winrt_abi_type->GetVideoStreamSettingsAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStreamControl<D>::SuggestVideoStreamSettings(winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings const& settings) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SuggestVideoStreamSettings(*(void**)(&settings)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)this;
            check_hresult(_winrt_abi_type->SuggestVideoStreamSettings(*(void**)(&settings)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStreamControl<D>::SuggestVideoStreamSettingsAsync(winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings const& settings) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SuggestVideoStreamSettingsAsync(*(void**)(&settings), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)this;
            check_hresult(_winrt_abi_type->SuggestVideoStreamSettingsAsync(*(void**)(&settings), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStreamControl<D>::MuteAudio() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MuteAudio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)this;
            check_hresult(_winrt_abi_type->get_MuteAudio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverStreamControl<D>::MuteAudio(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MuteAudio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>**)this;
            check_hresult(_winrt_abi_type->put_MuteAudio(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverVideoStreamSettings<D>::Size() const
    {
        winrt::Windows::Graphics::SizeInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverVideoStreamSettings<D>::Size(winrt::Windows::Graphics::SizeInt32 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)this;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverVideoStreamSettings<D>::Bitrate() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bitrate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)this;
            check_hresult(_winrt_abi_type->get_Bitrate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastReceiverVideoStreamSettings<D>::Bitrate(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Bitrate(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>**)this;
            check_hresult(_winrt_abi_type->put_Bitrate(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::Name(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::AuthorizationStatus() const
    {
        winrt::Windows::Media::Miracast::MiracastTransmitterAuthorizationStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AuthorizationStatus(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->get_AuthorizationStatus(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::AuthorizationStatus(winrt::Windows::Media::Miracast::MiracastTransmitterAuthorizationStatus const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AuthorizationStatus(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->put_AuthorizationStatus(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::GetConnections() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetConnections(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->GetConnections(&result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Miracast::MiracastReceiverConnection>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::MacAddress() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MacAddress(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->get_MacAddress(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Miracast_IMiracastTransmitter<D>::LastConnectionTime() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Miracast::IMiracastTransmitter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LastConnectionTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Miracast::IMiracastTransmitter>**)this;
            check_hresult(_winrt_abi_type->get_LastConnectionTime(put_abi(value)));
        }
        return value;
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiver> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiver>
    {
        int32_t __stdcall GetDefaultSettings(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverSettings>(this->shim().GetDefaultSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCurrentSettings(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverSettings>(this->shim().GetCurrentSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCurrentSettingsAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverSettings>>(this->shim().GetCurrentSettingsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisconnectAllAndApplySettings(void* settings, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsResult>(this->shim().DisconnectAllAndApplySettings(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverSettings const*>(&settings)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisconnectAllAndApplySettingsAsync(void* settings, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsResult>>(this->shim().DisconnectAllAndApplySettingsAsync(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverSettings const*>(&settings)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetStatus(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverStatus>(this->shim().GetStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetStatusAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverStatus>>(this->shim().GetStatusAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_StatusChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StatusChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiver, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StatusChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StatusChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall CreateSession(void* view, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverSession>(this->shim().CreateSession(*reinterpret_cast<winrt::Windows::ApplicationModel::Core::CoreApplicationView const*>(&view)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSessionAsync(void* view, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverSession>>(this->shim().CreateSessionAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Core::CoreApplicationView const*>(&view)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearKnownTransmitters() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ClearKnownTransmitters();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveKnownTransmitter(void* transmitter) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveKnownTransmitter(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastTransmitter const*>(&transmitter));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedError(winrt::hresult* value) noexcept final try
        {
            zero_abi<winrt::hresult>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::hresult>(this->shim().ExtendedError());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnection>
    {
        int32_t __stdcall Disconnect(int32_t reason) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Disconnect(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverDisconnectReason const*>(&reason));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisconnectWithMessage(int32_t reason, void* message) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Disconnect(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverDisconnectReason const*>(&reason), *reinterpret_cast<hstring const*>(&message));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Pause() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall PauseAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().PauseAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Resume() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resume();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ResumeAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ResumeAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Transmitter(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastTransmitter>(this->shim().Transmitter());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InputDevices(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverInputDevices>(this->shim().InputDevices());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CursorImageChannel(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel>(this->shim().CursorImageChannel());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StreamControl(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverStreamControl>(this->shim().StreamControl());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs>
    {
        int32_t __stdcall get_Connection(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverConnection>(this->shim().Connection());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Pin(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Pin());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Deferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel>
    {
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxImageSize(struct struct_Windows_Graphics_SizeInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::SizeInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::SizeInt32>(this->shim().MaxImageSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Position(struct struct_Windows_Graphics_PointInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::PointInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::PointInt32>(this->shim().Position());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ImageStream(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStreamWithContentType>(this->shim().ImageStream());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ImageStreamChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ImageStreamChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ImageStreamChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ImageStreamChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_PositionChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().PositionChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_PositionChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PositionChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings>
    {
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxImageSize(struct struct_Windows_Graphics_SizeInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::SizeInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::SizeInt32>(this->shim().MaxImageSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MaxImageSize(struct struct_Windows_Graphics_SizeInt32 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MaxImageSize(*reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs>
    {
        int32_t __stdcall get_Connection(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverConnection>(this->shim().Connection());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice>
    {
        int32_t __stdcall get_TransmitInput(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().TransmitInput());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransmitInput(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransmitInput(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsRequestedByTransmitter(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsRequestedByTransmitter());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsTransmittingInput(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTransmittingInput());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDeviceUsageMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Mode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Mode(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDeviceUsageMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Changed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Changed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDevice, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Changed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Changed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices>
    {
        int32_t __stdcall get_Keyboard(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverKeyboardDevice>(this->shim().Keyboard());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_GameController(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDevice>(this->shim().GameController());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice>
    {
        int32_t __stdcall get_TransmitInput(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().TransmitInput());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransmitInput(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransmitInput(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsRequestedByTransmitter(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsRequestedByTransmitter());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsTransmittingInput(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTransmittingInput());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Changed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Changed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverKeyboardDevice, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Changed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Changed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs>
    {
        int32_t __stdcall get_Connection(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverConnection>(this->shim().Connection());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MediaSource(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Core::MediaSource>(this->shim().MediaSource());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CursorImageChannelSettings(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannelSettings>(this->shim().CursorImageChannelSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Deferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverSession>
    {
        int32_t __stdcall add_ConnectionCreated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ConnectionCreated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverConnectionCreatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ConnectionCreated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ConnectionCreated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_MediaSourceCreated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().MediaSourceCreated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverMediaSourceCreatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_MediaSourceCreated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MediaSourceCreated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_Disconnected(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Disconnected(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Miracast::MiracastReceiverSession, winrt::Windows::Media::Miracast::MiracastReceiverDisconnectedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Disconnected(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Disconnected(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall get_AllowConnectionTakeover(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AllowConnectionTakeover());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AllowConnectionTakeover(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AllowConnectionTakeover(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxSimultaneousConnections(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MaxSimultaneousConnections());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MaxSimultaneousConnections(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MaxSimultaneousConnections(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Start(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverSessionStartResult>(this->shim().Start());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverSessionStartResult>>(this->shim().StartAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverSessionStartStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedError(winrt::hresult* value) noexcept final try
        {
            zero_abi<winrt::hresult>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::hresult>(this->shim().ExtendedError());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverSettings>
    {
        int32_t __stdcall get_FriendlyName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FriendlyName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FriendlyName(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FriendlyName(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ModelName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ModelName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ModelName(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ModelName(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ModelNumber(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ModelNumber());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ModelNumber(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ModelNumber(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AuthorizationMethod(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverAuthorizationMethod>(this->shim().AuthorizationMethod());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AuthorizationMethod(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AuthorizationMethod(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverAuthorizationMethod const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RequireAuthorizationFromKnownTransmitters(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().RequireAuthorizationFromKnownTransmitters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RequireAuthorizationFromKnownTransmitters(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RequireAuthorizationFromKnownTransmitters(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverStatus>
    {
        int32_t __stdcall get_ListeningStatus(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverListeningStatus>(this->shim().ListeningStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_WiFiStatus(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverWiFiStatus>(this->shim().WiFiStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsConnectionTakeoverSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsConnectionTakeoverSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxSimultaneousConnections(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MaxSimultaneousConnections());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_KnownTransmitters(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Miracast::MiracastTransmitter>>(this->shim().KnownTransmitters());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl>
    {
        int32_t __stdcall GetVideoStreamSettings(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings>(this->shim().GetVideoStreamSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetVideoStreamSettingsAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings>>(this->shim().GetVideoStreamSettingsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SuggestVideoStreamSettings(void* settings) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SuggestVideoStreamSettings(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings const*>(&settings));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SuggestVideoStreamSettingsAsync(void* settings, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SuggestVideoStreamSettingsAsync(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings const*>(&settings)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MuteAudio(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().MuteAudio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MuteAudio(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MuteAudio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings>
    {
        int32_t __stdcall get_Size(struct struct_Windows_Graphics_SizeInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::SizeInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::SizeInt32>(this->shim().Size());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Size(struct struct_Windows_Graphics_SizeInt32 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Size(*reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Bitrate(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Bitrate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Bitrate(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Bitrate(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Miracast::IMiracastTransmitter> : produce_base<D, winrt::Windows::Media::Miracast::IMiracastTransmitter>
    {
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Name(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Name(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AuthorizationStatus(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Miracast::MiracastTransmitterAuthorizationStatus>(this->shim().AuthorizationStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AuthorizationStatus(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AuthorizationStatus(*reinterpret_cast<winrt::Windows::Media::Miracast::MiracastTransmitterAuthorizationStatus const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetConnections(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Miracast::MiracastReceiverConnection>>(this->shim().GetConnections());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MacAddress(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().MacAddress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LastConnectionTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().LastConnectionTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Media::Miracast
{
    inline MiracastReceiver::MiracastReceiver() :
        MiracastReceiver(impl::call_factory_cast<MiracastReceiver(*)(winrt::Windows::Foundation::IActivationFactory const&), MiracastReceiver>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<MiracastReceiver>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiver> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverApplySettingsResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverConnection> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverConnectionCreatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannel> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverCursorImageChannelSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverDisconnectedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverGameControllerDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverInputDevices> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverKeyboardDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverMediaSourceCreatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverSession> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverSessionStartResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverStatus> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverStreamControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastReceiverVideoStreamSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::IMiracastTransmitter> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiver> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverApplySettingsResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverConnection> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverConnectionCreatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannel> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverCursorImageChannelSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverDisconnectedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverGameControllerDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverInputDevices> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverKeyboardDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverMediaSourceCreatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverSession> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverSessionStartResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverStatus> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverStreamControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastReceiverVideoStreamSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Miracast::MiracastTransmitter> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
