/**
 *
 * @file s_spm.h
 *
 * SParse Matrix package precision dependent header.
 *
 * @copyright 2016-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 1.2.4
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Alban Bellot
 * @author Tony Delarue
 * @author Alycia Lisito
 * @date 2024-05-29
 *
 * @generated from D:/W/B/src/pastix/spm/include/spm/z_spm.h, normal z -> s, Fri Jun 20 12:51:16 2025
 *
 * @addtogroup spm_dev_integer
 * @{
 *
 **/
#ifndef _s_spm_h_
#define _s_spm_h_

/**
 * @brief Integer routines
 */
void s_spmIntFltSortAsc( void **const    pbase,
                         const spm_int_t n );
void s_spmIntIntFltSortAsc( void ** const   pbase,
                            const spm_int_t n );

/**
 * @}
 * @addtogroup spm_dev_convert
 * @{
 *
 * @brief Conversion routines
 */
int s_spmConvertCSC2CSR( spmatrix_t *spm );
int s_spmConvertCSC2IJV( spmatrix_t *spm );
int s_spmConvertCSR2CSC( spmatrix_t *spm );
int s_spmConvertCSR2IJV( spmatrix_t *spm );
int s_spmConvertIJV2CSC( spmatrix_t *spm );
int s_spmConvertIJV2CSR( spmatrix_t *spm );

void s_spm2dense( const spmatrix_t *spm, float *A );

/**
 * @}
 * @addtogroup spm_dev_matvec
 * @{
 *
 * @brief Matrix-Vector and matrix-matrix product routines
 */
int spm_sspmv( spm_trans_t            trans,
               float        alpha,
               const spmatrix_t      *A,
               const float *x,
               spm_int_t              incx,
               float        beta,
               float       *y,
               spm_int_t              incy );
int spm_sspmm( spm_side_t             side,
               spm_trans_t            transA,
               spm_trans_t            transB,
               spm_int_t              K,
               float        alpha,
               const spmatrix_t      *A,
               const float *B,
               spm_int_t              ldb,
               float        beta,
               float       *C,
               spm_int_t              ldc );

/**
 * @}
 * @addtogroup spm_dev_norm
 * @{
 *
 * @brief Norm computation routines
 */
float s_spmNorm( spm_normtype_t    ntype,
                  const spmatrix_t *spm );
float s_spmNormMat( spm_normtype_t         ntype,
                     const spmatrix_t      *spm,
                     spm_int_t              n,
                     const float *A,
                     spm_int_t              lda );

/**
 * @}
 * @addtogroup spm_dev_check
 * @{
 *
 * @brief Extra routines
 */
void s_spmSort( spmatrix_t *spm );
spm_int_t s_spmMergeDuplicate( spmatrix_t *spm );

/**
 * @}
 * @addtogroup spm_dev_rhs
 * @{
 *
 * @brief RHS routines
 */
int s_spmGenRHS( spm_rhstype_t     type,
                 int               nrhs,
                 const spmatrix_t *spm,
                 void             *x,
                 int               ldx,
                 void             *b,
                 int               ldb );
int s_spmGenMat( spm_rhstype_t           type,
                 int                     nrhs,
                 const spmatrix_t       *spm,
                 void                   *alpha,
                 unsigned long long int  seed,
                 void                   *A,
                 int                     lda );
int s_spmCheckAxb( spm_fixdbl_t      eps,
                   int               nrhs,
                   const spmatrix_t *spm,
                   void             *x0,
                   int               ldx0,
                   void             *b,
                   int               ldb,
                   const void       *x,
                   int               ldx );

void s_spmGatherRHS( int                    nrhs,
                     const spmatrix_t      *spm,
                     const float *x,
                     spm_int_t              ldx,
                     int                    root,
                     float       *gx,
                     spm_int_t              ldgx );

void s_spmReduceRHS( int               nrhs,
                     const spmatrix_t *spm,
                     float  *bglob,
                     spm_int_t         ldbg,
                     float  *bloc,
                     spm_int_t         ldbl );
void s_spmExtractLocalRHS( int                    nrhs,
                           const spmatrix_t      *spm,
                           const float *bglob,
                           spm_int_t              ldbg,
                           float       *bloc,
                           spm_int_t              ldbl );

/**
 * @}
 * @addtogroup spm_dev_print
 * @{
 *
 * @brief Output routines
 */
void s_spmPrint( FILE             *f,
                 const spmatrix_t *spm );
void s_spmPrintRHS( FILE             *f,
                    const spmatrix_t *spm,
                    int               nrhs,
                    const void       *x,
                    spm_int_t         ldx );
void s_spmDensePrint( FILE                  *f,
                      spm_int_t              m,
                      spm_int_t              n,
                      const float *A,
                      spm_int_t              lda );

/**
 * @}
 * @addtogroup spm_dev_dof
 * @{
 *
 * @brief DOF routines
 */
void s_spmExpand( const spmatrix_t *spm_in,
                  spmatrix_t       *spm_out );
void s_spmDofExtend( spmatrix_t *spm );

/**
 * @}
 * @addtogroup spm_dev_scal
 * @{
 *
 * @brief Scaling routines
 */
void s_spmScal( const float  alpha,
                spmatrix_t   *spm );

/**
 * @}
 * @addtogroup spm_dev_rhs
 * @{
 *
 * @brief Subroutines for random vector generation to be used in testings
 */
int s_spmRhsGenRndShm( const spmatrix_t      *spm,
                       float        scale,
                       spm_int_t              n,
                       float       *A,
                       spm_int_t              lda,
                       int                    shift,
                       unsigned long long int seed );
int s_spmRhsGenRndDist( const spmatrix_t      *spm,
                        float        scale,
                        spm_int_t              n,
                        float       *A,
                        spm_int_t              lda,
                        int                    shift,
                        unsigned long long int seed );

/**
 * @}
 */
#endif /* _s_spm_h_ */
