/**************************************************************************/
/*  audio_effect_distortion.hpp                                           */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

// THIS FILE IS GENERATED. EDITS WILL BE LOST.

#ifndef GODOT_CPP_AUDIO_EFFECT_DISTORTION_HPP
#define GODOT_CPP_AUDIO_EFFECT_DISTORTION_HPP

#include <godot_cpp/classes/audio_effect.hpp>
#include <godot_cpp/classes/ref.hpp>

#include <godot_cpp/core/class_db.hpp>

#include <type_traits>

namespace godot {

class AudioEffectDistortion : public AudioEffect {
	GDEXTENSION_CLASS(AudioEffectDistortion, AudioEffect)

public:
	enum Mode {
		MODE_CLIP = 0,
		MODE_ATAN = 1,
		MODE_LOFI = 2,
		MODE_OVERDRIVE = 3,
		MODE_WAVESHAPE = 4,
	};

	void set_mode(AudioEffectDistortion::Mode p_mode);
	AudioEffectDistortion::Mode get_mode() const;
	void set_pre_gain(float p_pre_gain);
	float get_pre_gain() const;
	void set_keep_hf_hz(float p_keep_hf_hz);
	float get_keep_hf_hz() const;
	void set_drive(float p_drive);
	float get_drive() const;
	void set_post_gain(float p_post_gain);
	float get_post_gain() const;

protected:
	template <typename T, typename B>
	static void register_virtuals() {
		AudioEffect::register_virtuals<T, B>();
	}

public:
};

} // namespace godot

VARIANT_ENUM_CAST(AudioEffectDistortion::Mode);

#endif // ! GODOT_CPP_AUDIO_EFFECT_DISTORTION_HPP
